/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ObjectStore;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLObjectStore
implements ObjectStore {
    public static final String CLASS_ATTR = "class";
    public static final String NSELEM_ATTR = "nselem";
    private static final HashMap _transforms = new HashMap();

    XMLObjectStore() {
    }

    public static void registerTransform(String string, String string2, String string3, URL uRL) {
        HashMap<TransformKey, URL> hashMap = (HashMap<TransformKey, URL>)_transforms.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<TransformKey, URL>();
            _transforms.put(string, hashMap);
        }
        hashMap.put(new TransformKey(string, string2, string3), uRL);
    }

    Element applyTransforms(Element element, Class clazz, ArrayList arrayList) throws ClassNotFoundException {
        String string;
        String string2;
        TransformKey transformKey;
        HashMap hashMap;
        URL uRL;
        String string3 = this.getClassStr(element, clazz);
        Object v = _transforms.get(string3);
        if (!(v == null || (uRL = (URL)(hashMap = (HashMap)v).get(transformKey = new TransformKey(string3, string2 = XMLObjectStore.getNamespaceURI(element), string = XMLObjectStore.getNselem(element)))) == null || arrayList != null && arrayList.contains(transformKey))) {
            try {
                XSLStylesheet xSLStylesheet = XMLUtil.loadXSLT(uRL);
                Document document = element.getOwnerDocument();
                XMLDocumentFragment xMLDocumentFragment = (XMLDocumentFragment)document.createDocumentFragment();
                xMLDocumentFragment.appendChild(element.cloneNode(true));
                XSLProcessor xSLProcessor = new XSLProcessor();
                XMLDocumentFragment xMLDocumentFragment2 = xSLProcessor.processXSL(xSLStylesheet, xMLDocumentFragment);
                Element element2 = (Element)xMLDocumentFragment2.getFirstChild();
                element.getParentNode().replaceChild(element2, element);
                ArrayList arrayList2 = arrayList != null ? arrayList : new ArrayList();
                arrayList2.add(transformKey);
                Element element3 = this.applyTransforms(element2, clazz, arrayList2);
                return element3;
            }
            catch (Exception exception) {
                this.logOtherExceptionImpl(exception);
            }
        }
        return element;
    }

    void logOtherExceptionImpl(Throwable throwable) {
    }

    private static String getNselem(Element element) {
        Attr attr = element.getAttributeNode(NSELEM_ATTR);
        return attr != null ? attr.getValue() : element.getLocalName();
    }

    private static String getNamespaceURI(Element element) {
        return ModelUtil.nullifyIfEmpty((String)element.getNamespaceURI());
    }

    private String getClassStr(Element element, Class clazz) {
        String string = ModelUtil.nullifyIfEmpty((String)element.getAttribute(CLASS_ATTR));
        return ModelUtil.hasLength((String)string) ? string : clazz.getName();
    }

    private static class TransformKey {
        final String classStr;
        final String namespaceURI;
        final String localElemName;
        private Integer _hashCode;

        TransformKey(String string, String string2, String string3) {
            this.classStr = string;
            this.namespaceURI = string2;
            this.localElemName = string3;
        }

        public boolean equals(Object object) {
            TransformKey transformKey = (TransformKey)object;
            return ModelUtil.areEqual((Object)this.classStr, (Object)transformKey.classStr) && ModelUtil.areEqual((Object)this.namespaceURI, (Object)transformKey.namespaceURI) && ModelUtil.areEqual((Object)this.localElemName, (Object)transformKey.localElemName);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int n = this.classStr != null ? this.classStr.hashCode() : 0;
                int n2 = this.namespaceURI != null ? this.namespaceURI.hashCode() : 0;
                int n3 = this.localElemName != null ? this.localElemName.hashCode() : 0;
                this._hashCode = new Integer(n ^ n2 ^ n3);
            }
            return this._hashCode;
        }
    }
}

