/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.config.ClientSetting;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.Copyable;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public abstract class ExtensionMigrator
implements Migrator {
    protected static final int SETTINGS = 0;
    protected boolean isSelected;

    void $init$() {
        this.isSelected = true;
    }

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int n) {
        return null;
    }

    public boolean canMigrate(int n, File file) {
        File file2;
        return n == 0 && file != null && file.exists() && (file2 = this.getSourceFile(file)) != null && file2.exists() && file2.canRead();
    }

    public void setSelected(int n, boolean bl) {
        if (n == 0) {
            this.isSelected = bl;
        }
    }

    public boolean isSelected(int n) {
        return n == 0 ? this.isSelected : false;
    }

    public String[] migrate(File file, File file2) {
        if (!this.isSelected(0)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file != null && file.exists()) {
            File file3 = this.getSourceFile(file);
            URL uRL = URLFactory.newFileURL(file3);
            Object2Dom object2Dom = Object2Dom.newInstance();
            Map map = null;
            try {
                NullLogger nullLogger = new NullLogger(null);
                object2Dom.setLogger(2, nullLogger);
                map = (Map)object2Dom.toObject(uRL);
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{exception.getLocalizedMessage()};
                return stringArray;
            }
            File file4 = this.getDestFile(file2);
            if (file4 != null && file4.exists()) {
                try {
                    file4.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ClientSetting clientSetting = ClientSetting.findOrCreate(this.getExtensionID());
            List list = this.getSettingKeys();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Object e = iterator.next();
                    if (!map.containsKey(e)) continue;
                    clientSetting.putData((String)e, (Copyable)map.get(e));
                }
                catch (Exception exception) {
                    arrayList.add(exception.getLocalizedMessage());
                }
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected File getSourceFile(File file) {
        File file2 = new File(file, "preferences.xml");
        if (!file2.exists()) {
            file2 = new File(file, "settings.xml");
        }
        return file2;
    }

    protected File getDestFile(File file) {
        return new File(file, "preferences.xml");
    }

    protected abstract List getSettingKeys();

    protected abstract String getExtensionID();

    public ExtensionMigrator() {
        this.$init$();
    }

    private static final class NullLogger
    implements Object2DomLogger {
        public void logXMLParseException(XMLParseException xMLParseException) {
        }

        public void logSAXParseException(SAXParseException sAXParseException) {
        }

        public void logUnmarshalException(int n, int n2, Throwable throwable) {
        }

        public void logOtherException(Throwable throwable) {
        }

        public void logMessage(String string) {
        }

        public void logXMLDocument(XMLDocument xMLDocument) {
        }

        private NullLogger() {
        }

        NullLogger(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

