/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.File;
import java.util.List;
import javax.ide.extension.Extension;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.ide.migration.Migrator;
import oracle.javatools.jndi.Names;

public abstract class MigrationManager {
    private static final String MIGRATION_MANAGER_NAME = "ide/migration-manager";

    public static MigrationManager getMigrationManager() {
        return (MigrationManager)Names.lookup((Context)Names.newInitialContext(), (String)MIGRATION_MANAGER_NAME);
    }

    public static void setMigrationManager(MigrationManager migrationManager) {
        InitialContext initialContext = Names.newInitialContext();
        if (migrationManager != null) {
            Names.bind((Context)initialContext, (String)MIGRATION_MANAGER_NAME, (Object)migrationManager);
        } else {
            Names.unbind((Context)initialContext, (String)MIGRATION_MANAGER_NAME);
        }
    }

    public abstract void migrate();

    public abstract void finishMigration();

    public abstract List getMigrators();

    public abstract Migrator getMigrator(Class var1);

    public abstract File getOracleHomeDirectory(File var1);

    public abstract void registerMigrator(String var1, Extension var2);
}

