/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.migration.MigrationPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.MigratorArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.ide.wizard.WizardCallbacks;

public class MigrationWizard {
    private static final int WIZARD_WELCOME_PAGE = 0;
    private static final int WIZARD_INTRO_PAGE = 1;
    private static final int WIZARD_PAD_PAGE_NO = 2;
    private static final int WIZARD_PAGE_COUNT = 3;
    private static final String HELP_TOPIC_WELCOME = "f1_migwelcome_html";
    private static final String HELP_TOPIC_INTRO = "f1_migintro_html";
    private static final String HELP_TOPIC_SUMMARY = "f1_migfinish_html";
    public static final String USER_CANCELED_MIGRATION = "user-canceled-migration";

    public static boolean runWizard(String string, String string2, String string3, TraversableContext traversableContext, List list) {
        if (list.size() == 0) {
            return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), string2, string, HELP_TOPIC_WELCOME);
        }
        return MigrationWizard.runWizardImpl(string, string2, string3, traversableContext, list);
    }

    private static boolean runWizardImpl(String string, String string2, String string3, TraversableContext traversableContext, List list) {
        int n = list.size() + 3;
        Step[] stepArray = new Step[n];
        stepArray[0] = MigrationWizard.createWelcomePage();
        stepArray[1] = MigrationWizard.createIntroPage(string2);
        Traversable[] traversableArray = list.toArray(new Traversable[list.size()]);
        int n2 = 0;
        while (n2 < traversableArray.length) {
            stepArray[n2 + 2] = new Step(traversableArray[n2].getClass());
            ++n2;
        }
        stepArray[n - 1] = MigrationWizard.createFinishPage(string3, traversableArray);
        FSMWizard fSMWizard = new FSMWizard(stepArray, (Namespace)traversableContext);
        String string4 = MigratorArb.getString(0);
        fSMWizard.setWizardTitle(string4);
        fSMWizard.setWelcomePageAdded(true);
        fSMWizard.setFinishPageAdded(true);
        fSMWizard.setShowStepNumber(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)((Object)Ide.getMainWindow()));
        boolean bl = WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.dispose();
        return bl;
    }

    private static Step createWelcomePage() {
        String string = MigratorArb.getString(3);
        String string2 = MigratorArb.getString(1);
        String string3 = MigratorArb.getString(2);
        return WelcomePanel.newStep(string, string2, string3, MigrationWizard.class.getName(), HELP_TOPIC_WELCOME);
    }

    private static Step createIntroPage(String string) {
        return new Step(IntroPanel.class, new Class[]{String.class}, new Object[]{string});
    }

    private static Step createFinishPage(String string, Traversable[] traversableArray) {
        return new Step(SummaryPanel.class, new Class[]{String.class, Traversable[].class}, new Object[]{string, traversableArray});
    }

    private static final class IntroPanel
    extends DefaultTraversablePanel
    implements ItemListener {
        private WizardCallbacks callbacks;
        private final JRadioButton yesOption;
        private final JRadioButton noOption;

        IntroPanel(String string) {
            this.setDefaultTitle(MigratorArb.getString(4));
            this.setHelpID(MigrationWizard.HELP_TOPIC_INTRO);
            this.setLayout(new GridBagLayout());
            this.yesOption = new JRadioButton();
            this.noOption = new JRadioButton();
            this.yesOption.addItemListener(this);
            this.noOption.addItemListener(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.yesOption);
            buttonGroup.add(this.noOption);
            this.yesOption.setSelected(true);
            ResourceUtils.resButton(this.yesOption, MigratorArb.getString(8));
            ResourceUtils.resButton(this.noOption, MigratorArb.getString(9));
            GridBagConstraints gridBagConstraints = this.gbc(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0));
            if (ModelUtil.hasLength((String)string)) {
                MultiLineLabel multiLineLabel = new MultiLineLabel();
                multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
                multiLineLabel.setText(string);
                this.add((Component)multiLineLabel, gridBagConstraints);
            }
            this.add((Component)this.yesOption, gridBagConstraints);
            gridBagConstraints.weighty += 1.0;
            gridBagConstraints.weightx += 1.0;
            this.add((Component)this.noOption, gridBagConstraints);
        }

        public void onEntry(TraversableContext traversableContext) {
            this.callbacks = traversableContext.getWizardCallbacks();
            Boolean bl = (Boolean)traversableContext.get(MigrationWizard.USER_CANCELED_MIGRATION);
            boolean bl2 = bl != null ? bl : false;
            this.noOption.setSelected(bl2);
            this.updateButtons();
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            this.updateButtons();
            traversableContext.put(MigrationWizard.USER_CANCELED_MIGRATION, (Object)new Boolean(this.noOption.isSelected()));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateButtons();
        }

        private void updateButtons() {
            if (this.callbacks != null) {
                boolean bl = this.noOption.isSelected();
                this.callbacks.wizardEnableButtons(null, bl ? Boolean.FALSE : null, bl ? Boolean.TRUE : Boolean.TRUE);
            }
        }
    }

    private static final class SummaryPanel
    extends FinishPanel {
        private final JTree summaryTree;
        private final JPanel summaryPanel;
        private final JScrollPane treeScroller;
        private Traversable[] panels;

        SummaryPanel(String string, Traversable[] traversableArray) {
            super(MigratorArb.getString(6), MigratorArb.getString(7));
            this.panels = traversableArray;
            this.summaryTree = new JTree(new DefaultMutableTreeNode());
            this.summaryTree.setCellRenderer(new ResultCellRenderer(null));
            this.treeScroller = new JScrollPane(this.summaryTree);
            this.summaryPanel = new JPanel(new BorderLayout(0, 2));
            if (ModelUtil.hasLength((String)string)) {
                MultiLineLabel multiLineLabel = new MultiLineLabel();
                multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
                multiLineLabel.setText(string);
                this.summaryPanel.add((Component)multiLineLabel, "North");
            }
            this.setFinishComponent(this.summaryPanel);
        }

        public void onEntry(TraversableContext traversableContext) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.summaryTree.getModel().getRoot();
            int n = 0;
            while (n < this.panels.length) {
                MigrationPanel.ResultData resultData;
                if (this.panels[n] instanceof MigrationPanel && (resultData = ((MigrationPanel)this.panels[n]).getResults(traversableContext)) != null) {
                    String string = resultData.getHeading();
                    String string2 = resultData.getText();
                    if (ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2)) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(string2));
                    }
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.summaryTree.getRowCount()) {
                this.summaryTree.expandRow(n2);
                ++n2;
            }
            this.summaryTree.setSelectionRow(0);
            this.summaryTree.setRootVisible(false);
            this.summaryTree.setShowsRootHandles(true);
            if (this.summaryTree.getRowCount() > 1) {
                this.summaryPanel.add((Component)this.treeScroller, "Center");
            } else {
                Component[] componentArray = this.summaryPanel.getComponents();
                int n3 = 0;
                while (n3 < componentArray.length) {
                    if (componentArray[n3] == this.treeScroller) {
                        this.summaryPanel.remove(n3);
                        break;
                    }
                    ++n3;
                }
            }
            this.setHelpID(MigrationWizard.HELP_TOPIC_SUMMARY);
        }
    }

    private static class ResultCellRenderer
    extends DefaultTreeCellRenderer {
        private JLabel label;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.label = new JLabel(((DefaultMutableTreeNode)object).toString());
            this.label.setOpaque(true);
            if (bl) {
                this.label.setForeground(super.getTextSelectionColor());
                this.label.setBackground(super.getBackgroundSelectionColor());
            } else {
                this.label.setForeground(super.getTextNonSelectionColor());
                this.label.setBackground(super.getBackgroundNonSelectionColor());
            }
            this.label.setIcon(null);
            if (((TreeNode)object).getChildCount() > 0) {
                Font font = component.getFont();
                this.label.setFont(font.deriveFont(1));
            }
            return this.label;
        }

        private ResultCellRenderer() {
        }

        ResultCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

