/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.naming.Context;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.MigrationWizard;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.ProjectVersion;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.SwingUtils;

public abstract class NodeMigrator {
    public static final String MIGRATOR_MAP_DATA = "node-migrator-data";
    private static final String MIGRATOR_MSG_DATA = "node-migrator-errors";
    private List _helpers;
    private ProgressBar _progressBar;

    void $init$() {
        this._helpers = new ArrayList();
    }

    public static NodeMigrator getNodeMigrator(String string) {
        return (NodeMigrator)Names.lookup((Context)Names.newInitialContext(), (String)string);
    }

    public static String getLookupKey(Node node) {
        return node.getClass().getName();
    }

    public abstract MigrationInfo getMigrationInfo(Node var1);

    public MigrationInfo[] migrate(MigrationInfo[] migrationInfoArray) {
        TraversableContext traversableContext = new TraversableContext(new Namespace(), 1);
        List list = this.getPages(migrationInfoArray, traversableContext);
        MigrationInfo.MigrationStatus migrationStatus = this.invokeWizard(traversableContext, list, migrationInfoArray);
        if (migrationStatus == MigrationInfo.MIGRATION_PENDING) {
            NodeMigrator.logTimestampedMessage(405);
            List list2 = null;
            try {
                ArrayList arrayList = new ArrayList();
                traversableContext.putDesignTimeObject(MIGRATOR_MSG_DATA, arrayList);
                list2 = this.doMigration(traversableContext);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                ArrayList<String> arrayList5 = new ArrayList<String>();
                for (MigrationInfo migrationInfo : list2) {
                    Node node = migrationInfo.getNode();
                    URL uRL = node.getURL();
                    String string = URLFileSystem.getPlatformPathName(uRL);
                    MigrationInfo.MigrationStatus migrationStatus2 = migrationInfo.getMigrationStatus();
                    if (migrationStatus2 == MigrationInfo.MIGRATION_DONE) {
                        arrayList5.add(string);
                    } else if (migrationStatus2 == MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED) {
                        arrayList4.add(string);
                        migrationInfo.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                    } else {
                        arrayList2.add(string);
                    }
                    if (migrationInfo.getBackupURL() != null) continue;
                    arrayList3.add(string);
                }
                NodeMigrator.emitMessages(arrayList2, arrayList, 401);
                NodeMigrator.emitMessages(arrayList3, arrayList, 402);
                NodeMigrator.emitMessages(arrayList4, arrayList, 403);
                NodeMigrator.emitMessages(arrayList5, arrayList, 404);
                this.displayMessages(arrayList);
            }
            catch (Throwable throwable) {
                NodeMigrator.logTimestampedMessage(407);
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                throwable.printStackTrace();
            }
            return list2 != null ? list2.toArray(new MigrationInfo[list2.size()]) : null;
        }
        return migrationInfoArray;
    }

    private static void emitMessages(ArrayList arrayList, ArrayList arrayList2, int n) {
        if (!arrayList.isEmpty()) {
            if (!arrayList2.isEmpty()) {
                arrayList2.add("");
            }
            arrayList2.add(IdeArb.getString(n));
            for (Object e : arrayList) {
                if (e == null) continue;
                arrayList2.add("      " + e.toString());
            }
        }
    }

    public MigrationInfo[] getMigrationInfos(Node[] nodeArray) {
        ArrayList<MigrationInfo> arrayList = new ArrayList<MigrationInfo>(nodeArray.length);
        int n = 0;
        int n2 = nodeArray.length;
        while (n < n2) {
            arrayList.add(this.getMigrationInfo(nodeArray[n]));
            ++n;
        }
        return arrayList.toArray(new MigrationInfo[arrayList.size()]);
    }

    public List getPages(MigrationInfo[] migrationInfoArray, TraversableContext traversableContext) {
        Map map = this.getInfoToMigratorMap(traversableContext);
        int n = 0;
        int n2 = migrationInfoArray.length;
        while (n < n2) {
            this.mapInfoToMigrator(this, migrationInfoArray[n], map);
            ++n;
        }
        NodeMigratorHelper[] nodeMigratorHelperArray = this.getHelpers();
        ArrayList arrayList = new ArrayList();
        int n3 = nodeMigratorHelperArray.length;
        int n4 = 0;
        while (n4 < n3) {
            arrayList.addAll(nodeMigratorHelperArray[n4].getPages(migrationInfoArray, traversableContext));
            ++n4;
        }
        ArrayList arrayList2 = arrayList;
        return arrayList2;
    }

    public MigrationInfo migrate(MigrationInfo migrationInfo) {
        MigrationInfo[] migrationInfoArray = new MigrationInfo[]{migrationInfo};
        this.migrate(migrationInfoArray);
        return migrationInfoArray[0];
    }

    public List doMigration(TraversableContext traversableContext) {
        ArrayList arrayList = new ArrayList();
        1 var3_3 = new 1(this, traversableContext, arrayList);
        this._progressBar = new ProgressBar((Component)((Object)Ide.getMainWindow()), IdeArb.getString(398), var3_3, true);
        this._progressBar.setCancelable(false);
        this._progressBar.start(IdeArb.format(399, Version.NAME_SHORT, Version.VER), null);
        this._progressBar.waitUntilDone();
        this._progressBar = null;
        return arrayList;
    }

    public List doMigration(List list, TraversableContext traversableContext) {
        MigrationInfo[] migrationInfoArray = list.toArray(new MigrationInfo[list.size()]);
        this.backup(migrationInfoArray);
        int n = 0;
        while (n < migrationInfoArray.length) {
            MigrationInfo migrationInfo = migrationInfoArray[n];
            this.callHelpersMigrate(migrationInfo, traversableContext);
            ++n;
        }
        return list;
    }

    protected void callHelpersMigrate(MigrationInfo migrationInfo, TraversableContext traversableContext) {
        NodeMigratorHelper[] nodeMigratorHelperArray = this.getHelpers(migrationInfo);
        int n = 0;
        while (n < nodeMigratorHelperArray.length) {
            NodeMigratorHelper nodeMigratorHelper = nodeMigratorHelperArray[n];
            this.callHelperMigrate(nodeMigratorHelper, migrationInfo, traversableContext);
            ++n;
        }
    }

    protected final void callHelperMigrate(NodeMigratorHelper nodeMigratorHelper, MigrationInfo migrationInfo, TraversableContext traversableContext) {
        try {
            MigrationInfo[] migrationInfoArray = new MigrationInfo[]{migrationInfo};
            nodeMigratorHelper.migrate(migrationInfoArray, traversableContext);
            Node node = migrationInfo.getNode();
            if (node instanceof PropertyStorage) {
                PropertyStorage propertyStorage = (PropertyStorage)migrationInfo.getNode();
                ProjectVersion projectVersion = new ProjectVersion(propertyStorage);
                String string = nodeMigratorHelper.getNodeMigratorHelperKey();
                if (string != null) {
                    String string2 = nodeMigratorHelper.getNodeMigratorHelperVersion();
                    projectVersion.addVersion(string, new VersionNumber(string2));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void addHelper(NodeMigratorHelper nodeMigratorHelper) {
        this._helpers.add(nodeMigratorHelper);
    }

    public final void removeHelper(NodeMigratorHelper nodeMigratorHelper) {
        this._helpers.remove(nodeMigratorHelper);
    }

    public MigrationInfo.MigrationStatus checkVersions(MigrationInfo[] migrationInfoArray) {
        int n = 0;
        int n2 = 0;
        int n3 = migrationInfoArray.length;
        while (n2 < n3) {
            MigrationInfo.MigrationStatus migrationStatus = migrationInfoArray[n2].getMigrationStatus();
            if (migrationStatus == MigrationInfo.MIGRATION_NOT_POSSIBLE) {
                URL uRL = migrationInfoArray[n2].getNode().getURL();
                String string = IdeArb.format(414, Version.NAME_SHORT, URLFileSystem.getPlatformPathName(uRL), migrationInfoArray[n2].getVersion());
                MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)string, (String)IdeArb.getString(413), null);
                return migrationStatus;
            }
            if (migrationStatus == MigrationInfo.MIGRATION_NOT_NEEDED) {
                ++n;
            }
            ++n2;
        }
        return n != migrationInfoArray.length ? MigrationInfo.MIGRATION_PENDING : MigrationInfo.MIGRATION_NOT_NEEDED;
    }

    protected abstract String getTitle();

    protected abstract String getMsg(MigrationInfo[] var1);

    protected abstract String getSummaryMsg(MigrationInfo[] var1);

    protected MigrationInfo.MigrationStatus invokeWizard(TraversableContext traversableContext, List list, MigrationInfo[] migrationInfoArray) {
        MigrationInfo.MigrationStatus migrationStatus = this.checkVersions(migrationInfoArray);
        if (migrationStatus == MigrationInfo.MIGRATION_PENDING) {
            String string;
            String string2;
            String string3 = this.getTitle();
            boolean bl = MigrationWizard.runWizard(string3, string2 = this.getMsg(migrationInfoArray), string = this.getSummaryMsg(migrationInfoArray), traversableContext, list);
            if (!bl) {
                migrationStatus = MigrationInfo.MIGRATION_CANCELED;
            } else {
                boolean bl2;
                Boolean bl3 = (Boolean)traversableContext.get("user-canceled-migration");
                boolean bl4 = bl2 = bl3 != null ? bl3 : false;
                if (bl2) {
                    migrationStatus = MigrationInfo.MIGRATION_CANCELED;
                }
            }
        }
        return migrationStatus;
    }

    public NodeMigratorHelper[] getHelpers() {
        return this._helpers.toArray(new NodeMigratorHelper[this._helpers.size()]);
    }

    protected NodeMigratorHelper[] getHelpers(MigrationInfo migrationInfo) {
        return this.getHelpers();
    }

    protected Map getInfoToMigratorMap(TraversableContext traversableContext) {
        HashMap hashMap = (HashMap)traversableContext.find(MIGRATOR_MAP_DATA);
        if (hashMap == null) {
            hashMap = new HashMap();
            traversableContext.put(MIGRATOR_MAP_DATA, hashMap);
        }
        return hashMap;
    }

    protected void mapInfoToMigrator(NodeMigrator nodeMigrator, MigrationInfo migrationInfo, Map map) {
        if (migrationInfo.getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
            ArrayList<MigrationInfo> arrayList = (ArrayList<MigrationInfo>)map.get(nodeMigrator);
            if (arrayList == null) {
                arrayList = new ArrayList<MigrationInfo>(1);
                map.put(nodeMigrator, arrayList);
            }
            if (!arrayList.contains(migrationInfo)) {
                arrayList.add(migrationInfo);
            }
        }
    }

    protected void finishMigration(List list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            MigrationInfo migrationInfo = (MigrationInfo)list.get(n);
            if (migrationInfo.getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
                migrationInfo.setMigrationStatus(MigrationInfo.MIGRATION_DONE_BUT_NOT_SAVED);
                if (migrationInfo.getBackupURL() != null) {
                    try {
                        Node node = migrationInfo.getNode();
                        if (node.isDirty()) {
                            URL uRL = node.getURL();
                            if (!URLFileSystem.isReadOnly(uRL) || URLFileSystem.setReadOnly(uRL, false)) {
                                node.save();
                                migrationInfo.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                                node.close();
                            }
                        } else {
                            migrationInfo.setMigrationStatus(MigrationInfo.MIGRATION_DONE);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
    }

    private void backup(MigrationInfo[] migrationInfoArray) {
        int n = 0;
        int n2 = migrationInfoArray.length;
        while (n < n2) {
            MigrationInfo migrationInfo = migrationInfoArray[n];
            URL uRL = migrationInfo.getNode().getURL();
            if (URLFileSystem.exists(uRL)) {
                URL uRL2 = URLFileSystem.getParent(uRL);
                String string = URLFileSystem.getName(uRL);
                String string2 = URLFileSystem.getSuffix(uRL);
                BackupNameGenerator backupNameGenerator = new BackupNameGenerator(string, string2);
                URL uRL3 = URLFactory.newUniqueURL(uRL2, backupNameGenerator);
                MigrationInfo.MigrationStatus migrationStatus = this.updateStatus(migrationInfo, MigrationInfo.MIGRATION_IO_ERROR);
                try {
                    URLFileSystem.copy(uRL, uRL3);
                    migrationInfo.setBackupURL(uRL3);
                }
                catch (IOException iOException) {
                    migrationInfo.setBackupURL(null);
                }
                this.updateStatus(migrationInfo, migrationStatus);
            }
            ++n;
        }
    }

    private MigrationInfo.MigrationStatus updateStatus(MigrationInfo migrationInfo, MigrationInfo.MigrationStatus migrationStatus) {
        MigrationInfo.MigrationStatus migrationStatus2 = migrationInfo.getMigrationStatus();
        migrationInfo.setMigrationStatus(migrationStatus);
        return migrationStatus2;
    }

    private void displayMessages(ArrayList arrayList) {
        Iterator iterator;
        Iterator iterator2 = iterator = arrayList != null ? arrayList.iterator() : null;
        if (iterator != null) {
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                stringBuffer.append("\n");
            }
            if (stringBuffer.length() > 0) {
                LogPage logPage;
                String string = stringBuffer.toString();
                LogManager logManager = LogManager.getLogManager();
                if (logManager != null && (logPage = logManager.getMsgPage()) != null) {
                    logPage.log(string);
                    NodeMigrator.logTimestampedMessage(406);
                }
                JMultiLineLabel jMultiLineLabel = new JMultiLineLabel(string);
                jMultiLineLabel.setAllowFocus(true);
                AccessibleUtils.updateAccessibleName((Accessible)((Object)jMultiLineLabel), IdeArb.getString(398), false);
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)jMultiLineLabel));
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)jScrollPane, (String)IdeArb.getString(398), null);
            }
        }
    }

    private static void logTimestampedMessage(int n) {
        LogPage logPage;
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null && (logPage = logManager.getMsgPage()) != null) {
            logPage.log(IdeArb.format(n, NodeMigrator.getFormattedTimestamp()));
            logPage.log("\n");
        }
    }

    private static String getFormattedTimestamp() {
        DateFormat dateFormat = DateFormat.getTimeInstance();
        return dateFormat.format(new Date());
    }

    public NodeMigrator() {
        this.$init$();
    }

    static ProgressBar ra$_progressBar(NodeMigrator nodeMigrator) {
        return nodeMigrator._progressBar;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ TraversableContext v$context;
        private final /* synthetic */ List v$infoList;
        final /* synthetic */ NodeMigrator this$0;

        public void run() {
            try {
                Map map = this.this$0.getInfoToMigratorMap(this.v$context);
                for (NodeMigrator nodeMigrator : map.keySet()) {
                    this.v$infoList.addAll(nodeMigrator.doMigration((List)map.get(nodeMigrator), this.v$context));
                }
                this.this$0.finishMigration(this.v$infoList);
            }
            finally {
                NodeMigrator.ra$_progressBar(this.this$0).setDoneStatus();
            }
        }

        public 1(NodeMigrator nodeMigrator, TraversableContext traversableContext, List list) {
            this.v$infoList = list;
            this.v$context = traversableContext;
            this.this$0 = nodeMigrator;
        }
    }

    public static class BackupNameGenerator
    implements NameGenerator {
        private static final String BAK = ".bak";
        private int _counter;
        private String _baseName;
        private String _extension;
        private String _nextName;

        void $init$() {
            this._counter = 0;
        }

        public BackupNameGenerator(String string, String string2) {
            this.$init$();
            this._baseName = string;
            this._extension = string2;
            this._nextName = this._baseName + this._extension + BAK;
        }

        public String nextName() {
            String string = this._nextName;
            this._nextName = this._baseName + this._extension + "." + Integer.toString(this._counter++) + BAK;
            return string;
        }
    }
}

