/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.migration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.IdeArb;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXParseException;

public abstract class XMLMigrator
implements Migrator {
    private int[] categories;
    private boolean[] selections;
    private Object2Dom o2d;
    private MigrationLogger log;

    protected XMLMigrator(int[] nArray) {
        this.categories = new int[nArray.length];
        this.selections = new boolean[nArray.length];
        System.arraycopy(nArray, 0, this.categories, 0, nArray.length);
        int n = 0;
        while (n < this.selections.length) {
            this.selections[n] = true;
            ++n;
        }
    }

    public final int[] getMigrationCategories() {
        return this.categories;
    }

    public void setSelected(int n, boolean bl) {
        int n2 = this.categoryToIndex(n);
        if (n2 >= 0) {
            this.selections[n2] = bl;
        }
    }

    public final boolean isSelected(int n) {
        int n2 = this.categoryToIndex(n);
        if (n2 >= 0) {
            return this.selections[n2];
        }
        return false;
    }

    public boolean canMigrate(int n, File file) {
        File file2;
        return this.isValidCategory(n) && file != null && file.exists() && (file2 = new File(file, this.getFileName())) != null && file2.exists() && file2.canRead();
    }

    public String[] migrate(File file, File file2) {
        if (!this.isAnyCategorySelected()) {
            return null;
        }
        try {
            this.prepareToMigrate();
            Object object = this.readObject(file, file2);
            Object object2 = object = object != null ? this.adjustObject(file, file2, object) : null;
            if (object != null) {
                this.writeObject(file, file2, object);
            }
        }
        catch (Exception exception) {
            this.getLogger().logOtherException(exception);
        }
        return this.getLogger().getErrors();
    }

    protected abstract String getFileName();

    protected abstract String getNamespaceURI();

    protected abstract String getRootTag();

    protected final boolean isValidCategory(int n) {
        int n2 = 0;
        while (n2 < this.categories.length) {
            if (n == this.categories[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final int categoryToIndex(int n) {
        int n2 = 0;
        while (n2 < this.categories.length) {
            if (this.categories[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected final boolean isAnyCategorySelected() {
        int n = 0;
        while (n < this.selections.length) {
            if (this.selections[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void prepareToMigrate() {
    }

    protected Object readObject(File file, File file2) throws Exception {
        File file3 = this.getSourceFile(file, file2);
        URL uRL = URLFactory.newFileURL(file3);
        return this.getObjectStore().toObject(uRL);
    }

    protected void writeObject(File file, File file2, Object object) throws Exception {
        File file3 = this.getDestFile(file, file2);
        URL uRL = URLFactory.newFileURL(file3);
        this.getObjectStore().setNamespaceURI(this.getNamespaceURI());
        this.getObjectStore().toDocument(object, this.getRootTag(), uRL);
    }

    protected Object adjustObject(File file, File file2, Object object) throws Exception {
        return object;
    }

    protected File getSourceFile(File file, File file2) {
        return new File(file, this.getFileName());
    }

    protected File getDestFile(File file, File file2) {
        return new File(file2, this.getFileName());
    }

    protected final synchronized MigrationLogger getLogger() {
        if (this.log == null) {
            this.log = new MigrationLogger(this);
        }
        return this.log;
    }

    protected final synchronized Object2Dom getObjectStore() {
        if (this.o2d == null) {
            this.o2d = Object2Dom.newInstance();
            this.o2d.setLogger(2, this.getLogger());
        }
        return this.o2d;
    }

    static int[] ra$categories(XMLMigrator xMLMigrator) {
        return xMLMigrator.categories;
    }

    public static final class MigrationLogger
    implements Object2DomLogger {
        final ArrayList errors;
        final XMLMigrator migrator;

        void $init$() {
            this.errors = new ArrayList();
        }

        public MigrationLogger(XMLMigrator xMLMigrator) {
            this.$init$();
            this.migrator = xMLMigrator;
        }

        private void logMessage(Throwable throwable, int n, int n2) {
            this.logMessage(throwable.getLocalizedMessage(), n, n2);
        }

        private void logMessage(String string, int n, int n2) {
            if (this.errors.size() == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < XMLMigrator.ra$categories(this.migrator).length) {
                    if (this.migrator.isSelected(XMLMigrator.ra$categories(this.migrator)[n3])) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.migrator.getDescription(XMLMigrator.ra$categories(this.migrator)[n3]));
                    }
                    ++n3;
                }
                this.errors.add(IdeArb.format(374, new String[]{stringBuffer.toString(), this.migrator.getFileName()}));
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (n >= 0) {
                stringBuffer.append(" ");
                stringBuffer.append(IdeArb.getString(383));
                stringBuffer.append(" ");
                stringBuffer.append(n);
                stringBuffer.append(".");
            }
            if (n2 >= 0) {
                stringBuffer.append(" ");
                stringBuffer.append(IdeArb.getString(384));
                stringBuffer.append(" ");
                stringBuffer.append(n2);
                stringBuffer.append(".");
            }
            this.errors.add(stringBuffer.toString());
        }

        String[] getErrors() {
            if (this.errors.size() == 0) {
                return null;
            }
            String[] stringArray = new String[this.errors.size()];
            this.errors.toArray(stringArray);
            return stringArray;
        }

        public void logXMLParseException(XMLParseException xMLParseException) {
            this.logMessage(xMLParseException, xMLParseException.getLineNumber(), xMLParseException.getColumnNumber());
        }

        public void logSAXParseException(SAXParseException sAXParseException) {
            this.logMessage(sAXParseException, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }

        public void logUnmarshalException(int n, int n2, Throwable throwable) {
            this.logMessage(throwable, n, n2);
        }

        public void logOtherException(Throwable throwable) {
            this.logMessage(throwable, -1, -1);
        }

        public void logMessage(String string) {
        }

        public void logXMLDocument(XMLDocument xMLDocument) {
        }

        public void logInformation(String string) {
            this.logMessage(string, -1, -1);
        }
    }
}

