/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.WorkingSet;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;

final class ContentAtom {
    private final URL _contentRoot;
    private final IntersectedFilters _filters;
    final String _contentSetKey;
    private boolean _displayFoldersAsPackages;

    ContentAtom(URL uRL, IntersectedFilters intersectedFilters, String string) {
        this._contentRoot = uRL;
        this._filters = intersectedFilters;
        this._contentSetKey = string;
        this._displayFoldersAsPackages = ProjectContent.isDisplayFoldersAsPackages(string);
    }

    URL getContentRoot() {
        return this._contentRoot;
    }

    IntersectedFilters getFilters() {
        return this._filters;
    }

    boolean getDisplayFoldersAsPackages() {
        return this._displayFoldersAsPackages;
    }

    void setDisplayFoldersAsPackages(boolean bl) {
        this._displayFoldersAsPackages = bl;
    }

    static ContentAtom[] atomize(ContentSet contentSet, Project project, boolean bl) {
        PatternFilters patternFilters = bl ? WorkingSet.getCurrentWorkingSetFilters(project) : null;
        return ContentAtom.atomize(contentSet, patternFilters);
    }

    static ContentAtom[] atomize(ContentSet contentSet, IntersectedFilters intersectedFilters) {
        ArrayList arrayList = new ArrayList();
        PatternFilters patternFilters = ContentSet.getExcludeJprJwsFilters();
        PatternFilters patternFilters2 = GlobalIgnoreList.getPatternFilters();
        IntersectedFilters intersectedFilters2 = new IntersectedFilters(patternFilters, patternFilters2);
        IntersectedFilters intersectedFilters3 = new IntersectedFilters(intersectedFilters, intersectedFilters2);
        ContentAtom.atomizeImpl(arrayList, contentSet, intersectedFilters3, null);
        return arrayList.toArray(new ContentAtom[arrayList.size()]);
    }

    static ContentAtom[] atomize(ContentSet contentSet, PatternFilters patternFilters) {
        ArrayList arrayList = new ArrayList();
        PatternFilters patternFilters2 = ContentSet.getExcludeJprJwsFilters();
        PatternFilters patternFilters3 = GlobalIgnoreList.getPatternFilters();
        IntersectedFilters intersectedFilters = new IntersectedFilters(patternFilters, patternFilters2, patternFilters3);
        ContentAtom.atomizeImpl(arrayList, contentSet, intersectedFilters, null);
        return arrayList.toArray(new ContentAtom[arrayList.size()]);
    }

    private static void atomizeImpl(ArrayList arrayList, ContentSet contentSet, IntersectedFilters intersectedFilters, String string) {
        URLPath uRLPath;
        Iterator iterator;
        if (string == null) {
            string = contentSet.getContentSetName();
        }
        if ((iterator = (uRLPath = contentSet.getURLPath()).iterator()).hasNext()) {
            PatternFilters patternFilters = PatternFilters.getInstance(HashStructure.newInstance());
            contentSet.getPatternFilters().copyTo((Object)patternFilters);
            IntersectedFilters intersectedFilters2 = intersectedFilters.intersectWith(patternFilters);
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                arrayList.add(new ContentAtom(uRL, intersectedFilters2, string));
            }
        }
        int n = contentSet.countContentSets();
        int n2 = 0;
        while (n2 < n) {
            ContentSet contentSet2 = contentSet.getContentSet(n2);
            ContentAtom.atomizeImpl(arrayList, contentSet2, intersectedFilters, string);
            ++n2;
        }
    }
}

