/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentLevelFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.view.View;
import oracle.javatools.util.CopyOnWriteList;

final class ContentFilter
extends ChildFilter {
    private final CopyOnWriteList _helpers;
    private final Class _type;
    private final boolean _isProject;
    private final Object _lock;
    private ArrayList _children;

    void $init$() {
        this._lock = new Object();
    }

    ContentFilter(CopyOnWriteList copyOnWriteList, Class clazz) {
        this.$init$();
        this._helpers = copyOnWriteList;
        this._type = clazz;
        this._isProject = this._type == Project.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        Object object = this._lock;
        synchronized (object) {
            if (this._children == null) {
                this._children = new ArrayList();
                Context context = this.getContext();
                if (context != null) {
                    this.getChildrenImpl(context);
                }
            }
            Iterator iterator = this._children.iterator();
            return iterator;
        }
    }

    private Context getContext() {
        TNode tNode = this.getOwner();
        if (tNode != null) {
            Element element = tNode.getData();
            TreeExplorer treeExplorer = tNode.getOwner();
            Context context = treeExplorer.getContext();
            if (element instanceof Project) {
                context.setProject((Project)element);
            } else if (element instanceof Workspace) {
                context.setWorkspace((Workspace)element);
            } else {
                context.setElement(element);
            }
            View view = treeExplorer.owner();
            if (view instanceof ProjectNavigatorWindow) {
                ProjectNavigatorWindow projectNavigatorWindow = (ProjectNavigatorWindow)view;
                projectNavigatorWindow.copyPreferencesTo(context);
            }
            return context;
        }
        return null;
    }

    private void getChildrenImpl(Context context) {
        Object[] objectArray = this._helpers.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChildFilterHelper childFilterHelper = (ChildFilterHelper)objectArray[n2];
            try {
                childFilterHelper.initChildren(context, this._children);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(updateMessage.getAddObjects());
        return this.childrenAddedRemoved(updateMessage, arrayList, tNode, treeExplorer, true);
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(updateMessage.getRemoveObjects());
        return this.childrenAddedRemoved(updateMessage, arrayList, tNode, treeExplorer, false);
    }

    public void refresh(TNode[] tNodeArray) {
        this.closeChildren();
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return true;
    }

    public TNode update(TNode tNode, UpdateMessage updateMessage) {
        System.out.println("**** ContentFilter.update(..) not implemented.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChildren() {
        Object object = this._lock;
        synchronized (object) {
            this._children = null;
        }
    }

    private TNode childrenAddedRemoved(UpdateMessage updateMessage, List list, TNode tNode, TreeExplorer treeExplorer, boolean bl) {
        if (this._isProject) {
            this.refreshDirs(updateMessage, list, tNode, treeExplorer, bl);
        } else if (!this.callChildFilterHelpers(list, tNode, treeExplorer, bl)) {
            this.forceRefresh(tNode);
        }
        return tNode;
    }

    private void refreshDirs(UpdateMessage updateMessage, List list, TNode tNode, TreeExplorer treeExplorer, boolean bl) {
        int n;
        int n2;
        if (!(bl || (n2 = updateMessage.getMessageID()) != UpdateMessage.OBJECT_RENAMED && n2 != UpdateMessage.CHILD_RENAMED)) {
            for (Object e : updateMessage.getModifyObjects()) {
                if (!(e instanceof URL)) continue;
                list.add(new 1(this, e));
            }
        }
        if ((n = list.size()) == 1) {
            Object e = list.get(0);
            if (e instanceof Locatable) {
                URL uRL = ((Locatable)e).getURL();
                URL uRL2 = URLFileSystem.getParent(uRL);
                this.refreshDir(uRL2, list, tNode, treeExplorer, bl);
            }
        } else if (n > 1) {
            HashMap hashMap = new HashMap();
            for (Object e : list) {
                if (!(e instanceof Locatable)) continue;
                URL uRL = ((Locatable)e).getURL();
                URL uRL3 = URLFileSystem.getParent(uRL);
                ArrayList arrayList = (ArrayList)hashMap.get(uRL3);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(uRL3, arrayList);
                }
                arrayList.add(e);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                URL uRL = (URL)entry.getKey();
                ArrayList arrayList = (ArrayList)entry.getValue();
                this.refreshDir(uRL, arrayList, tNode, treeExplorer, bl);
            }
        }
    }

    private void refreshDir(URL uRL, List list, TNode tNode, TreeExplorer treeExplorer, boolean bl) {
        TNode tNode2 = this.findExactDirTNode(uRL, tNode);
        if (tNode2 != null) {
            Element element = tNode2.getData();
            if (element instanceof ContentLevelFolder) {
                ContentLevelFolder contentLevelFolder = (ContentLevelFolder)element;
                contentLevelFolder.prepareRefresh();
            }
            treeExplorer.refresh(tNode2);
        } else {
            this.callChildFilterHelpers(list, tNode, treeExplorer, bl);
        }
    }

    private boolean callChildFilterHelpers(List list, TNode tNode, TreeExplorer treeExplorer, boolean bl) {
        Context context = this.getContext();
        Object[] objectArray = this._helpers.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChildFilterHelper childFilterHelper = (ChildFilterHelper)objectArray[n2];
            try {
                if (bl) {
                    if (childFilterHelper.handleChildrenAdded(context, list, tNode, treeExplorer)) {
                        this.forceRepaint(tNode, treeExplorer);
                        boolean bl2 = true;
                        return bl2;
                    }
                } else if (childFilterHelper.handleChildrenRemoved(context, list, tNode, treeExplorer)) {
                    this.forceRepaint(tNode, treeExplorer);
                    boolean bl3 = true;
                    return bl3;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ++n2;
        }
        return false;
    }

    private void forceRepaint(TNode tNode, TreeExplorer treeExplorer) {
        List list = ExplorerContext.storeExpansionState(tNode, treeExplorer);
        treeExplorer.collapse(tNode, false);
        treeExplorer.getTreeModel().reload(tNode);
        ExplorerContext.restoreExpansionState(tNode, treeExplorer, list);
    }

    private void forceRefresh(TNode tNode) {
        tNode.getOwner().refresh(tNode, this._type);
    }

    private TNode findExactDirTNode(URL uRL, TNode tNode) {
        if (tNode.isSet(TNodeConstants.IS_OPENED)) {
            Enumeration enumeration = tNode.getChildTNodes();
            while (enumeration.hasMoreElements()) {
                RelativeDirectoryContextFolder relativeDirectoryContextFolder;
                URLPath uRLPath;
                String string;
                TNode tNode2 = (TNode)enumeration.nextElement();
                Element element = tNode2.getData();
                if (!(element instanceof RelativeDirectoryContextFolder) || (string = (uRLPath = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRootDirectories()).toRelativePath(uRL)) == null) continue;
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (string.equals(relativeDirectoryContextFolder.getRelativePath())) {
                    return tNode2;
                }
                TNode tNode3 = this.findExactDirTNode(uRL, tNode2);
                if (tNode3 == null) continue;
                return tNode3;
            }
        }
        return null;
    }

    final class 1
    implements Locatable {
        private final /* synthetic */ Object v$nextObj;
        final /* synthetic */ ContentFilter this$0;

        public URL getURL() {
            return (URL)this.v$nextObj;
        }

        public void setURL(URL uRL) {
        }

        public 1(ContentFilter contentFilter, Object object) {
            this.v$nextObj = object;
            this.this$0 = contentFilter;
        }
    }
}

