/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.ContentAtom;
import oracle.ide.model.ContentLevelFilter;
import oracle.ide.model.ContentLevelFolder;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetFolder;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.CopyOnWriteList;

public abstract class ContentLevel {
    public static final String FLAT_LEVEL = "flat-level";
    public static final String SHOW_ROOT_DIRS = "show-root-dirs";
    public static final String SORT_BY_TYPE = "sort-by-type";
    public static final String SHOW_CONTENT_SET_NAMES = "show-content-set-names";
    public static final String ENABLE_CONTENT_LEVEL_FILTERS = "enable-content-level-filters";
    public static final String ENABLE_WORKING_SETS = "enable-working-sets";
    private static final CopyOnWriteList _filters = new CopyOnWriteList(ContentLevelFilter.class);
    private static Icon _folderIcon;
    private static Icon _jarIcon;
    private boolean _skip;
    private static Comparator _displayableComparator;
    private static Comparator _sortByTypeComparator;
    private static Comparator _contentSetDisplayableComparator;
    private String _shortLabel;
    private static Comparator _childrenComparator;
    private static int debugLevel;

    static {
        debugLevel = Integer.getInteger("Project.debug.level", 0);
    }

    private ContentLevel() {
    }

    public static ContentLevel newInstanceForShowDirs(URL uRL, IntersectedFilters intersectedFilters, boolean bl) {
        ContentAtom contentAtom = new ContentAtom(uRL, intersectedFilters, null);
        contentAtom.setDisplayFoldersAsPackages(bl);
        return new Impl(0, contentAtom, "", "", null);
    }

    public static ContentLevel newInstanceForHideDirs(ContentSet contentSet, PatternFilters patternFilters, boolean bl) {
        ContentAtom[] contentAtomArray = ContentAtom.atomize(contentSet, patternFilters);
        int n = contentAtomArray.length;
        int n2 = 0;
        while (n2 < n) {
            contentAtomArray[n2].setDisplayFoldersAsPackages(bl);
            ++n2;
        }
        return new Group(contentAtomArray, null);
    }

    public static void initChildren(Context context, List list) {
        Project project = context.getProject();
        ProjectContent projectContent = ProjectContent.getInstance(project);
        if (context.getBoolean(SHOW_CONTENT_SET_NAMES)) {
            ContentLevel.initContentSetFolders(projectContent, context, list);
        } else {
            ContentSet contentSet = projectContent.getAllContents();
            if (context.getBoolean(SHOW_ROOT_DIRS)) {
                ContentLevel.initSourceRootFolders(contentSet, context, list);
            } else {
                ContentLevel.initMergedChildren(contentSet, context, list);
            }
        }
    }

    private static void initContentSetFolders(ProjectContent projectContent, Context context, List list) {
        ArrayList arrayList = new ArrayList();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ListStructure listStructure = projectContent.getContentSetList();
        Iterator iterator = listStructure.iterator();
        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
        int n = contentSetProviderArray.length;
        block0: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = 0;
            while (n2 < n) {
                ContentSetProvider contentSetProvider = contentSetProviderArray[n2];
                String string2 = contentSetProvider.getKey();
                if (string.equals(string2)) {
                    String string3 = contentSetProvider.getShortLabel();
                    if (hashMap.containsKey(string3)) {
                        Object v = hashMap.get(string3);
                        if (v instanceof ArrayList) {
                            ((ArrayList)v).add(contentSetProvider);
                            continue block0;
                        }
                        if (v instanceof ContentSetProvider) {
                            ArrayList<Object> arrayList3 = new ArrayList<Object>();
                            arrayList3.add(v);
                            arrayList3.add(contentSetProvider);
                            hashMap.put(string3, arrayList3);
                            continue block0;
                        }
                        new IllegalStateException("Unexpected object").printStackTrace();
                        continue block0;
                    }
                    hashMap.put(string3, contentSetProvider);
                    continue block0;
                }
                ++n2;
            }
            arrayList2.add(string);
        }
        for (String string : hashMap.keySet()) {
            Object v = hashMap.get(string);
            Context context2 = new Context(context);
            if (v instanceof ArrayList) {
                ArrayList arrayList4 = (ArrayList)v;
                ContentSet contentSet = new ContentSet(HashStructure.newInstance(), false);
                for (ContentSetProvider contentSetProvider : arrayList4) {
                    String string4 = contentSetProvider.getKey();
                    ContentSet contentSet2 = projectContent.getContentSet(string4);
                    contentSet.addContentSet(contentSet2);
                    context2.setBoolean(string4, true);
                }
                ContentLevel.addContentSetFolder(contentSet, string, arrayList, context2);
                continue;
            }
            if (v instanceof ContentSetProvider) {
                ContentSetProvider contentSetProvider = (ContentSetProvider)v;
                String string5 = contentSetProvider.getKey();
                ContentSet contentSet = projectContent.getContentSet(string5);
                context2.setBoolean(string5, true);
                ContentLevel.addContentSetFolder(contentSet, string, arrayList, context2);
                continue;
            }
            new IllegalStateException("Unexpected object").printStackTrace();
        }
        for (String string : arrayList2) {
            int n3 = string.lastIndexOf(47);
            int n4 = n3 + 1;
            String string6 = n4 < string.length() ? string.substring(n4) : string.substring(0, n3);
            String string7 = "<" + string6 + ">";
            ContentSet contentSet = projectContent.getContentSet(string);
            Context context3 = new Context(context);
            context3.setBoolean(string, true);
            ContentLevel.addContentSetFolder(contentSet, string7, arrayList, context3);
        }
        Collections.sort(arrayList, ContentLevel.getContentSetDisplayableComparator());
        list.addAll(arrayList);
    }

    private static void addContentSetFolder(ContentSet contentSet, String string, ArrayList arrayList, Context context) {
        URLPath uRLPath = contentSet.getAllRootDirs();
        Iterator iterator = uRLPath.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            if (!URLFileSystem.exists(uRL)) continue;
            List list = contentSet.getFilesAndDirectories("", null, null);
            if (list.size() > 0) {
                arrayList.add(new ContentSetFolder(contentSet, string, context));
            }
            return;
        }
    }

    static void initSourceRootFolders(ContentSet contentSet, Context context, List list) {
        ContentLevel[] contentLevelArray = ContentLevel.extractContentLevels(contentSet, context);
        int n = contentLevelArray.length;
        URL uRL = context.getProject().getURL();
        URL uRL2 = URLFileSystem.getParent(uRL);
        ContentLevel contentLevel = null;
        int n2 = 0;
        while (n2 < n) {
            ContentLevel contentLevel2 = contentLevelArray[n2];
            if (URLFileSystem.equals(uRL2, contentLevel2.getDirectoryURL())) {
                contentLevel = contentLevel2;
            } else {
                list.add(contentLevel2.newFolder(context));
            }
            ++n2;
        }
        if (contentLevel != null) {
            contentLevel.addFlatDirs(context, list);
        }
    }

    static void initMergedChildren(ContentSet contentSet, Context context, List list) {
        Project project = context.getProject();
        boolean bl = context.getBoolean(ENABLE_WORKING_SETS);
        ContentAtom[] contentAtomArray = ContentAtom.atomize(contentSet, project, bl);
        Group group = new Group(contentAtomArray, null);
        group.addFlatDirs(context, list);
    }

    private static ContentLevel[] extractContentLevels(ContentSet contentSet, Context context) {
        Project project = context.getProject();
        boolean bl = context.getBoolean(ENABLE_WORKING_SETS);
        ContentAtom[] contentAtomArray = ContentAtom.atomize(contentSet, project, bl);
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        int n = contentAtomArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentAtom contentAtom = contentAtomArray[n2];
            URL uRL = contentAtom.getContentRoot();
            if (URLFileSystem.exists(uRL)) {
                ContentLevel.put(hashMap, arrayList, uRL, contentAtom);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        ContentLevel[] contentLevelArray = new ContentLevel[n3];
        int n4 = 0;
        while (n4 < n3) {
            URL uRL = (URL)arrayList.get(n4);
            ArrayList arrayList2 = (ArrayList)hashMap.get(uRL);
            ContentAtom[] contentAtomArray2 = arrayList2.toArray(new ContentAtom[arrayList2.size()]);
            contentLevelArray[n4] = new Group(contentAtomArray2, null);
            ++n4;
        }
        return contentLevelArray;
    }

    public static void addContentLevelFilter(ContentLevelFilter contentLevelFilter) {
        if (contentLevelFilter != null) {
            _filters.addIfAbsent((Object)contentLevelFilter);
        }
    }

    public static void removeContentLevelFilter(ContentLevelFilter contentLevelFilter) {
        if (contentLevelFilter != null) {
            _filters.remove((Object)contentLevelFilter);
        }
    }

    public static final Comparator getDisplayableComparator() {
        if (_displayableComparator == null) {
            _displayableComparator = new 4();
        }
        return _displayableComparator;
    }

    private static int sortFolderBeforeLeaf(Element element, Element element2) {
        if (ContentLevel.isFolder(element)) {
            return ContentLevel.isFolder(element2) ? 0 : -1;
        }
        return ContentLevel.isFolder(element2) ? 1 : 0;
    }

    private static boolean isFolder(Element element) {
        return element != null && element.mayHaveChildren();
    }

    private static final Comparator getSortByTypeComparator() {
        if (_sortByTypeComparator == null) {
            _sortByTypeComparator = new 3();
        }
        return _sortByTypeComparator;
    }

    public static final Comparator getContentSetDisplayableComparator() {
        if (_contentSetDisplayableComparator == null) {
            _contentSetDisplayableComparator = new 2();
        }
        return _contentSetDisplayableComparator;
    }

    public abstract URL getDirectoryURL();

    public URLPath getDirectoryURLPath() {
        return new URLPath(this.getDirectoryURL());
    }

    public abstract String getRelPath();

    abstract void getContentSetKeys(ArrayList var1);

    public abstract int getLevel();

    public abstract List getFiles();

    public final List getDirectories() {
        return this._skip ? Collections.EMPTY_LIST : this.getDirectoriesImpl();
    }

    public abstract ContentLevel getContentLevel(String var1);

    public final void getNodes(List list) {
        List list2 = this.getFiles();
        for (URL uRL : list2) {
            try {
                Node node = NodeFactory.findOrCreate(uRL);
                list.add(node);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public final RelativeDirectoryContextFolder newFolder(Context context) {
        return new ContentLevelFolder(this, context);
    }

    public final void addFlatDirs(Context context, List list) {
        int n = context.getInt(FLAT_LEVEL);
        if (n <= 0) {
            ArrayList arrayList = new ArrayList();
            this.getAllNodes(arrayList);
            if (context.getBoolean(ENABLE_CONTENT_LEVEL_FILTERS)) {
                this.applyContentLevelFilters(context, arrayList, Collections.EMPTY_LIST);
            }
            Collections.sort(arrayList, ContentLevel.getDisplayableComparator());
            Iterator iterator = arrayList.iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2 == e) {
                        iterator.remove();
                    }
                    e = e2;
                }
            }
            list.addAll(arrayList);
        } else {
            ArrayList arrayList = new ArrayList();
            this.getNodes(arrayList);
            ArrayList<RelativeDirectoryContextFolder> arrayList2 = new ArrayList<RelativeDirectoryContextFolder>();
            ArrayList arrayList3 = this.getFlattenedDirs(n);
            for (ContentLevel contentLevel : arrayList3) {
                String string = contentLevel.getRelPath();
                if (string == null || string.length() <= 0) continue;
                arrayList2.add(contentLevel.newFolder(context));
            }
            if (context.getBoolean(ENABLE_CONTENT_LEVEL_FILTERS)) {
                this.applyContentLevelFilters(context, arrayList, arrayList2);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ContentLevelFolder contentLevelFolder = (ContentLevelFolder)iterator.next();
                ContentLevel contentLevel = contentLevelFolder.getContentLevel();
                if (contentLevel.getLevel() >= n || contentLevel.containsFile()) continue;
                iterator.remove();
            }
            arrayList.addAll(arrayList2);
            boolean bl = context.getBoolean(SORT_BY_TYPE);
            Comparator comparator = bl ? ContentLevel.getSortByTypeComparator() : ContentLevel.getChildrenComparator();
            Collections.sort(arrayList, comparator);
            list.addAll(arrayList);
        }
    }

    final String getShortLabel(Context context) {
        if (this._shortLabel == null) {
            String string;
            String string2;
            boolean bl = false;
            String string3 = this.getRelPath();
            int n = context.getInt(FLAT_LEVEL);
            boolean bl2 = this.getLevel() <= n;
            boolean bl3 = this.getDisplayFoldersAsPackages() && this.getLevel() > 0;
            while (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ("".equals(string3)) {
                URL uRL = this.getDirectoryURL();
                string2 = URLFileSystem.getFileName(uRL);
            } else {
                int n2;
                string2 = bl2 ? string3 : ((n2 = string3.lastIndexOf(47)) < 0 ? string3 : string3.substring(n2 + 1));
            }
            if (bl3 && IdeUtil.isPackageIdentifier(string = string2.replace('/', '.'))) {
                string2 = string;
                bl = true;
            }
            if (!bl && '/' != File.separatorChar) {
                string2 = string2.replace('/', File.separatorChar);
            }
            this._shortLabel = string2;
        }
        return this._shortLabel;
    }

    final void setShortLabel(String string) {
        this._shortLabel = string;
    }

    final Icon getIcon(Context context) {
        String string;
        if (this.getDisplayFoldersAsPackages() && this.getLevel() > 0 && IdeUtil.isPackageIdentifier(string = this.getShortLabel(context))) {
            return IdeIcons.getIcon(23);
        }
        return this.getIcon();
    }

    Icon getIcon() {
        return ContentLevel.getFolderIcon();
    }

    abstract boolean containsFile();

    abstract boolean getDisplayFoldersAsPackages();

    abstract List getDirectoriesImpl();

    abstract void prepareRefresh();

    private void applyContentLevelFilters(Context context, List list, List list2) {
        Object[] objectArray = _filters.getItems();
        int n = objectArray.length;
        if (n > 0) {
            URLPath uRLPath = this.getDirectoryURLPath();
            String string = this.getRelPath();
            EL eL = new EL(list, null);
            SL sL = new SL(list2, null);
            int n2 = 0;
            while (n2 < n) {
                ContentLevelFilter contentLevelFilter = (ContentLevelFilter)objectArray[n2];
                if (ContentLevel.filterAppliesToContext(contentLevelFilter, context)) {
                    try {
                        contentLevelFilter.updateDir(uRLPath, string, eL, sL, context);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    private static boolean filterAppliesToContext(ContentLevelFilter contentLevelFilter, Context context) {
        String[] stringArray = contentLevelFilter.getContentSetKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (context.getBoolean(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void getAllNodes(ArrayList arrayList) {
        this.getNodes(arrayList);
        List list = this.getDirectories();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            ContentLevel contentLevel = this.getContentLevel(string);
            if (contentLevel == null) continue;
            contentLevel.getAllNodes(arrayList);
        }
    }

    private ArrayList getFlattenedDirs(int n) {
        int n2 = this.getLevel();
        int n3 = n2 >= n ? 0 : n - n2 - 1;
        ArrayList<ContentLevel> arrayList = new ArrayList<ContentLevel>();
        ArrayList<ContentLevel> arrayList2 = new ArrayList<ContentLevel>();
        arrayList2.add(this);
        ArrayList<ContentLevel> arrayList3 = new ArrayList<ContentLevel>();
        int n4 = 0;
        while (arrayList2.size() > 0 && n4 <= n3) {
            Iterator iterator = arrayList2.iterator();
            boolean bl = n4 == n3;
            while (iterator.hasNext()) {
                ContentLevel contentLevel = (ContentLevel)iterator.next();
                List list = contentLevel.getDirectories();
                for (Object e : list) {
                    String string;
                    ContentLevel contentLevel2;
                    if (e == null || (contentLevel2 = contentLevel.getContentLevel(string = e.toString())) == null) continue;
                    if (bl) {
                        arrayList.add(contentLevel2);
                        continue;
                    }
                    ContentLevel contentLevel3 = contentLevel.getContentLevel(string);
                    contentLevel3.setSkipDirectories(true);
                    arrayList.add(contentLevel3);
                    arrayList3.add(contentLevel2);
                }
            }
            arrayList2.clear();
            arrayList2.addAll(arrayList3);
            arrayList3.clear();
            ++n4;
        }
        return arrayList;
    }

    private static Comparator getChildrenComparator() {
        if (_childrenComparator == null) {
            _childrenComparator = new 1();
        }
        return _childrenComparator;
    }

    private void setSkipDirectories(boolean bl) {
        this._skip = bl;
    }

    static ContentLevel newInstance(ContentSet contentSet, IntersectedFilters intersectedFilters) {
        ContentAtom[] contentAtomArray = ContentAtom.atomize(contentSet, intersectedFilters);
        return new Group(contentAtomArray, null);
    }

    static Icon getFolderIcon() {
        if (_folderIcon == null) {
            _folderIcon = IdeIcons.getIcon(4);
        }
        return _folderIcon;
    }

    private static Icon getJarIcon() {
        if (_jarIcon == null) {
            _jarIcon = IdeIcons.getIcon(26);
        }
        return _jarIcon;
    }

    private static void put(HashMap hashMap, ArrayList arrayList, URL uRL, ContentAtom contentAtom) {
        Object v = hashMap.get(uRL);
        if (v != null) {
            ((ArrayList)v).add(contentAtom);
        } else {
            ArrayList<ContentAtom> arrayList2 = new ArrayList<ContentAtom>();
            arrayList2.add(contentAtom);
            hashMap.put(uRL, arrayList2);
            arrayList.add(uRL);
        }
    }

    static int maS$sortFolderBeforeLeaf(Element element, Element element2) {
        return ContentLevel.sortFolderBeforeLeaf(element, element2);
    }

    ContentLevel(1 var1_1) {
        this();
    }

    static Icon maS$getJarIcon() {
        return ContentLevel.getJarIcon();
    }

    static int ra$debugLevel() {
        return debugLevel;
    }

    public static final class 4
    implements Comparator {
        private final Collator _collator;

        void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(Object object, Object object2) {
            return this._collator.compare(this.toName(object), this.toName(object2));
        }

        private String toName(Object object) {
            return ((Displayable)object).getShortLabel();
        }

        public 4() {
            this.$init$();
        }
    }

    public static final class 3
    implements Comparator {
        private final Collator _collator;

        void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(Object object, Object object2) {
            String string;
            Element element = (Element)object;
            Element element2 = (Element)object2;
            int n = ContentLevel.maS$sortFolderBeforeLeaf(element, element2);
            if (n != 0) {
                return n;
            }
            String string2 = element.getIcon().toString();
            int n2 = this._collator.compare(string2, string = element2.getIcon().toString());
            if (n2 != 0) {
                return n2;
            }
            String string3 = element.getShortLabel();
            String string4 = element2.getShortLabel();
            return this._collator.compare(string3, string4);
        }

        public 3() {
            this.$init$();
        }
    }

    public static final class 2
    implements Comparator {
        private final Collator _collator;

        void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            String string = ((Displayable)object).getShortLabel();
            String string2 = ((Displayable)object2).getShortLabel();
            if (string.startsWith("<")) {
                if (string2.startsWith("<")) {
                    String string3 = string.substring(1);
                    String string4 = string2.substring(1);
                    return this._collator.compare(string3, string4);
                }
                return 1;
            }
            if (string2.startsWith("<")) {
                return -1;
            }
            return this._collator.compare(string, string2);
        }

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }

        public 2() {
            this.$init$();
        }
    }

    public static final class 1
    implements Comparator {
        private Comparator _displayableComparator;

        void $init$() {
            this._displayableComparator = ContentLevel.getDisplayableComparator();
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof ContentSetFolder) {
                if (object2 instanceof ContentSetFolder) {
                    return this._displayableComparator.compare(object, object2);
                }
                return 1;
            }
            if (object2 instanceof ContentSetFolder) {
                return -1;
            }
            Element element = (Element)object;
            Element element2 = (Element)object2;
            int n = ContentLevel.maS$sortFolderBeforeLeaf(element, element2);
            if (n != 0) {
                return n;
            }
            return this._displayableComparator.compare(object, object2);
        }

        public 1() {
            this.$init$();
        }
    }

    private static class ListWrapper
    implements List {
        private final List _list;

        public ListWrapper(List list) {
            this._list = list;
        }

        public boolean add(Object object) {
            return this._list.add(object);
        }

        public void add(int n, Object object) {
            this._list.add(n, object);
        }

        public boolean addAll(Collection collection) {
            return this._list.addAll(collection);
        }

        public boolean addAll(int n, Collection collection) {
            return this._list.addAll(n, collection);
        }

        public void clear() {
            this._list.clear();
        }

        public boolean contains(Object object) {
            return this._list.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this._list.containsAll(collection);
        }

        public Object get(int n) {
            return this._list.get(n);
        }

        public int indexOf(Object object) {
            return this._list.indexOf(object);
        }

        public boolean isEmpty() {
            return this._list.isEmpty();
        }

        public Iterator iterator() {
            return this._list.iterator();
        }

        public int lastIndexOf(Object object) {
            return this._list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int n) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int n) {
            return this._list.remove(n);
        }

        public boolean remove(Object object) {
            return this._list.remove(object);
        }

        public boolean removeAll(Collection collection) {
            return this._list.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            return this._list.retainAll(collection);
        }

        public Object set(int n, Object object) {
            return this._list.set(n, object);
        }

        public int size() {
            return this._list.size();
        }

        public List subList(int n, int n2) {
            return this._list.subList(n, n2);
        }

        public Object[] toArray() {
            return this._list.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this._list.toArray(objectArray);
        }
    }

    private static class EL
    extends ListWrapper {
        private EL(List list) {
            super(list);
        }

        public boolean add(Object object) {
            this.checkAdd(object);
            return super.add(object);
        }

        public void add(int n, Object object) {
            this.checkAdd(object);
            super.add(n, object);
        }

        public boolean addAll(Collection collection) {
            this.checkAdd(collection);
            return super.addAll(collection);
        }

        public boolean addAll(int n, Collection collection) {
            this.checkAdd(collection);
            return super.addAll(n, collection);
        }

        public Object set(int n, Object object) {
            this.checkAdd(object);
            return super.set(n, object);
        }

        public List subList(int n, int n2) {
            return new EL(super.subList(n, n2));
        }

        private void checkAdd(Object object) {
            if (!(object instanceof Element)) {
                throw new IllegalArgumentException();
            }
        }

        private void checkAdd(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.checkAdd(iterator.next());
            }
        }

        EL(List list, 1 var2_2) {
            this(list);
        }

        public final class 1 {
        }
    }

    private static class SL
    extends ListWrapper {
        private SL(List list) {
            super(list);
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public List subList(int n, int n2) {
            return new SL(super.subList(n, n2));
        }

        SL(List list, 1 var2_2) {
            this(list);
        }

        public final class 1 {
        }
    }

    private static final class Impl
    extends ContentLevel {
        private final int _level;
        private final ContentAtom _atom;
        private final String _relPath;
        private final String _relPathDisplayPrefix;
        private final Icon _icon;
        private URL _dir;
        private URL[] _files;
        private URL[] _dirs;
        private List _cachedDirsList;

        private Impl(int n, ContentAtom contentAtom, String string, String string2) {
            super(null);
            this._level = n;
            this._atom = contentAtom;
            this._relPath = Impl.sanitizeRelPath(string);
            this._relPathDisplayPrefix = string2;
            this._icon = "".equals(this._relPath) && JarUtil.isJarURL(this._atom.getContentRoot()) && "".equals(JarUtil.getJarEntry(this._atom.getContentRoot())) ? ContentLevel.maS$getJarIcon() : Impl.getFolderIcon();
        }

        public URL getDirectoryURL() {
            return this._atom.getContentRoot();
        }

        public String getRelPath() {
            if ("".equals(this._relPathDisplayPrefix)) {
                return this._relPath;
            }
            return this._relPathDisplayPrefix + this._relPath;
        }

        void getContentSetKeys(ArrayList arrayList) {
            String string = this._atom._contentSetKey;
            if (string != null && !arrayList.contains(string)) {
                arrayList.add(string);
            }
        }

        public int getLevel() {
            return this._level;
        }

        Icon getIcon() {
            return this._icon;
        }

        boolean getDisplayFoldersAsPackages() {
            return this._atom.getDisplayFoldersAsPackages();
        }

        public List getFiles() {
            this.maybeGetFilesAndDirectories();
            return Collections.unmodifiableList(Arrays.asList(this._files));
        }

        List getDirectoriesImpl() {
            if (this._cachedDirsList == null) {
                this.maybeGetFilesAndDirectories();
                int n = this._dirs.length;
                String[] stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    URL uRL = this._dirs[n2];
                    stringArray[n2] = URLFileSystem.toRelativeSpec(uRL, this._dir, true);
                    ++n2;
                }
                this._cachedDirsList = Arrays.asList(stringArray);
            }
            return this._cachedDirsList;
        }

        void prepareRefresh() {
            this._files = null;
            this._dirs = null;
            this._cachedDirsList = null;
        }

        boolean containsFile() {
            this.maybeGetFilesAndDirectories();
            return this._files.length > 0;
        }

        public ContentLevel getContentLevel(String string) {
            List list = this.getDirectories();
            if (!list.contains(string)) {
                return null;
            }
            String string2 = this._relPath + string;
            return new Impl(this._level + 1, this._atom, string2, this._relPathDisplayPrefix);
        }

        private static String sanitizeRelPath(String string) {
            if (string == null || string.equals("")) {
                return "";
            }
            if (string.endsWith("/")) {
                return string;
            }
            return string + "/";
        }

        private void maybeGetFilesAndDirectories() {
            if (this._files == null) {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                this._dir = URLFactory.newDirURL(this._atom.getContentRoot(), this._relPath);
                URL[] uRLArray = URLFileSystem.list(this._dir);
                if (uRLArray != null) {
                    int n = uRLArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URL uRL = uRLArray[n2];
                        String string = URLFileSystem.toRelativeSpec(uRL, this._atom.getContentRoot(), true);
                        if (URLFileSystem.isDirectoryPath(uRL)) {
                            TriStateBoolean triStateBoolean = this._atom.getFilters().inferFromFilters(string);
                            if (triStateBoolean.isTrue() || triStateBoolean.isTriState()) {
                                arrayList2.add(uRL);
                            }
                        } else if (this._atom.getFilters().isIncluded(string)) {
                            arrayList.add(uRL);
                        }
                        ++n2;
                    }
                }
                this._files = Impl.toArray(arrayList);
                this._dirs = Impl.toArray(arrayList2);
            }
        }

        private static URL[] toArray(ArrayList arrayList) {
            return arrayList.toArray(new URL[arrayList.size()]);
        }

        Impl(int n, ContentAtom contentAtom, String string, String string2, 1 var5_5) {
            this(n, contentAtom, string, string2);
        }

        public final class 1 {
        }
    }

    private static final class Group
    extends ContentLevel {
        private final int _level;
        private final ContentLevel[] _levels;
        private final URLComparator _urlComparator;

        void $init$() {
            this._urlComparator = new URLComparator();
        }

        private Group(ContentAtom[] contentAtomArray) {
            super(null);
            this.$init$();
            this._level = 0;
            ArrayList<Impl> arrayList = new ArrayList<Impl>();
            if (contentAtomArray == null || contentAtomArray.length == 0) {
                if (ContentLevel.ra$debugLevel() >= 1) {
                    new IllegalArgumentException("no contents specified").printStackTrace();
                }
            } else {
                int n = contentAtomArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentAtom contentAtom = contentAtomArray[n2];
                    arrayList.add(new Impl(0, contentAtom, "", "", null));
                    ++n2;
                }
            }
            this._levels = arrayList.toArray(new ContentLevel[arrayList.size()]);
        }

        private Group(int n, ContentLevel[] contentLevelArray) {
            super(null);
            this.$init$();
            this._level = n;
            this._levels = contentLevelArray;
        }

        public URL getDirectoryURL() {
            return this._levels.length > 0 ? this._levels[0].getDirectoryURL() : null;
        }

        public URLPath getDirectoryURLPath() {
            URLPath uRLPath = new URLPath();
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                URL uRL = contentLevel.getDirectoryURL();
                if (uRL != null) {
                    uRLPath.add(uRL);
                } else {
                    uRLPath.add(contentLevel.getDirectoryURLPath());
                }
                ++n2;
            }
            return uRLPath;
        }

        public String getRelPath() {
            return this._levels.length > 0 ? this._levels[0].getRelPath() : "";
        }

        void getContentSetKeys(ArrayList arrayList) {
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                contentLevel.getContentSetKeys(arrayList);
                ++n2;
            }
        }

        public int getLevel() {
            return this._level;
        }

        boolean getDisplayFoldersAsPackages() {
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                if (contentLevel.getDisplayFoldersAsPackages()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public List getFiles() {
            ArrayList arrayList = new ArrayList();
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                arrayList.addAll(contentLevel.getFiles());
                ++n2;
            }
            Group.sortAndEliminateDuplicates(arrayList, this._urlComparator);
            return arrayList;
        }

        List getDirectoriesImpl() {
            ArrayList arrayList = new ArrayList();
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                arrayList.addAll(contentLevel.getDirectories());
                ++n2;
            }
            Group.sortAndEliminateDuplicates(arrayList, null);
            return arrayList;
        }

        void prepareRefresh() {
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                contentLevel.prepareRefresh();
                ++n2;
            }
        }

        boolean containsFile() {
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                if (contentLevel.containsFile()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public ContentLevel getContentLevel(String string) {
            ArrayList<ContentLevel> arrayList = new ArrayList<ContentLevel>();
            int n = this._levels.length;
            int n2 = 0;
            while (n2 < n) {
                ContentLevel contentLevel = this._levels[n2];
                ContentLevel contentLevel2 = contentLevel.getContentLevel(string);
                if (contentLevel2 != null) {
                    arrayList.add(contentLevel2);
                }
                ++n2;
            }
            int n3 = arrayList.size();
            if (n3 > 0) {
                ContentLevel[] contentLevelArray = arrayList.toArray(new ContentLevel[n3]);
                return new Group(this._level + 1, contentLevelArray);
            }
            return null;
        }

        private static void sortAndEliminateDuplicates(ArrayList arrayList, Comparator comparator) {
            if (comparator != null) {
                Collections.sort(arrayList, comparator);
            } else {
                Collections.sort(arrayList);
            }
            Iterator iterator = arrayList.iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2.equals(e)) {
                        iterator.remove();
                        continue;
                    }
                    e = e2;
                }
            }
        }

        Group(ContentAtom[] contentAtomArray, 1 var2_2) {
            this(contentAtomArray);
        }

        public final class 1 {
        }
    }
}

