/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.ContentElement;
import oracle.ide.model.ContentLevel;
import oracle.ide.net.URLPath;

final class ContentLevelFolder
extends ContentElement {
    private final ContentLevel _contentLevel;
    private final Context _context;

    ContentLevelFolder(ContentLevel contentLevel, Context context) {
        super(contentLevel.getShortLabel(context), contentLevel.getIcon(context));
        this._contentLevel = contentLevel;
        this._context = context;
        this.getContentSetKeys();
    }

    public final URLPath getRootDirectories() {
        return this._contentLevel.getDirectoryURLPath();
    }

    public final String getRelativePath() {
        String string = this._contentLevel.getRelPath();
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public List getContentSetKeys() {
        ArrayList arrayList = new ArrayList();
        this._contentLevel.getContentSetKeys(arrayList);
        return arrayList;
    }

    final List getChildrenList() {
        ArrayList arrayList = new ArrayList();
        this._contentLevel.addFlatDirs(this._context, arrayList);
        return arrayList;
    }

    final ContentLevel getContentLevel() {
        return this._contentLevel;
    }

    final void prepareRefresh() {
        this._contentLevel.prepareRefresh();
    }
}

