/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ContentSet
extends HashStructureAdapter {
    public static final String URL_PATH_KEY = "url-path";
    private static final String CONTENT_FOLDER_URL_KEY = "content-folder-url";
    private static final String CONSTITUENT_SETS_KEY = "constituent-sets";
    private static final String MISC_URLS_KEY = "misc-urls";
    private static PatternFilters _excludeJprJwsFilters;
    private final URLPath _urlPath;
    private final PatternFilters _patternFilters;
    private final IntersectedFilters _intersectedFilters;
    private ListStructure _miscList;
    private URLComparator _urlComparator;
    private final ArrayList _constituentSets;
    private final boolean _persistentComposite;

    void $init$() {
        this._constituentSets = new ArrayList();
    }

    public ContentSet(HashStructure hashStructure) {
        this(hashStructure, true);
    }

    public ContentSet(HashStructure hashStructure, boolean bl) {
        super(hashStructure);
        this.$init$();
        this._urlPath = new URLPath(this._hash.getOrCreateListStructure(URL_PATH_KEY));
        this._patternFilters = PatternFilters.getInstance(this._hash);
        PatternFilters patternFilters = ContentSet.getExcludeJprJwsFilters();
        PatternFilters patternFilters2 = GlobalIgnoreList.getPatternFilters();
        this._intersectedFilters = new IntersectedFilters(this._patternFilters, patternFilters, patternFilters2);
        ListStructure listStructure = this._hash.getListStructure(CONSTITUENT_SETS_KEY);
        if (listStructure != null) {
            for (Object e : listStructure) {
                if (!(e instanceof HashStructure)) continue;
                HashStructure hashStructure2 = (HashStructure)e;
                ContentSet contentSet = new ContentSet(hashStructure2);
                this._constituentSets.add(contentSet);
            }
        }
        this._persistentComposite = bl;
    }

    public static PatternFilters getExcludeJprJwsFilters() {
        if (_excludeJprJwsFilters == null) {
            _excludeJprJwsFilters = PatternFilters.getInstance(HashStructure.newInstance());
            _excludeJprJwsFilters.addInclude("**");
            _excludeJprJwsFilters.addExclude("**/*.jpr");
            _excludeJprJwsFilters.addExclude("**/*.jws");
        }
        return _excludeJprJwsFilters;
    }

    public static ContentSet getInstance(PropertyStorage propertyStorage, String string) {
        return new ContentSet(ContentSet.findOrCreate((PropertyStorage)propertyStorage, (String)string));
    }

    public String getContentSetName() {
        return this._hash.getFullName();
    }

    public URLPath getURLPath() {
        return this._urlPath;
    }

    public URL getContentFolderURL() {
        return this._hash.getURL(CONTENT_FOLDER_URL_KEY);
    }

    public void setContentFolderURL(URL uRL) {
        this._hash.putURL(CONTENT_FOLDER_URL_KEY, uRL, true);
    }

    public URLPath getAllRootDirs() {
        URLPath uRLPath = new URLPath();
        ContentSet.copyContentSetURLPathToURLPath(this, uRLPath);
        return uRLPath;
    }

    private static void copyContentSetURLPathToURLPath(ContentSet contentSet, URLPath uRLPath) {
        uRLPath.add(contentSet.getURLPath());
        int n = contentSet.countContentSets();
        int n2 = 0;
        while (n2 < n) {
            ContentSet contentSet2 = contentSet.getContentSet(n2);
            ContentSet.copyContentSetURLPathToURLPath(contentSet2, uRLPath);
            ++n2;
        }
    }

    public PatternFilters getPatternFilters() {
        return this._patternFilters;
    }

    public boolean canHaveMember(URL uRL) {
        URL[] uRLArray = this._urlPath.getEntries();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL uRL2 = uRLArray[n2];
            String string = URLFileSystem.toRelativeSpec(uRL, uRL2, true);
            if (string != null && this._intersectedFilters.isIncluded(string)) {
                return true;
            }
            ++n2;
        }
        for (ContentSet contentSet : this._constituentSets) {
            if (!contentSet.canHaveMember(uRL)) continue;
            return true;
        }
        ListStructure listStructure = this.getMiscList();
        return listStructure != null && listStructure.contains((Object)uRL);
    }

    public void addMiscellaneousFile(URL uRL) {
        ListStructure listStructure;
        if (uRL != null && !(listStructure = this.getOrCreateMiscList()).contains((Object)uRL)) {
            listStructure.add((Object)uRL);
        }
    }

    public boolean removeMiscellaneousFile(URL uRL) {
        ListStructure listStructure;
        boolean bl = false;
        if (uRL != null && (listStructure = this.getMiscList()) != null) {
            bl = listStructure.remove((Object)uRL);
            this.maybeClearMiscList();
        }
        return bl;
    }

    public void addContentSet(ContentSet contentSet) {
        if (this._persistentComposite) {
            ListStructure listStructure = this._hash.getOrCreateListStructure(CONSTITUENT_SETS_KEY);
            listStructure.add((Object)contentSet._hash);
        }
        this._constituentSets.add(contentSet);
    }

    public int countContentSets() {
        return this._constituentSets.size();
    }

    public ContentSet getContentSet(int n) {
        return (ContentSet)((Object)this._constituentSets.get(n));
    }

    public ContentSet setContentSet(int n, ContentSet contentSet) {
        if (contentSet == null) {
            throw new IllegalArgumentException();
        }
        return this._constituentSets.set(n, contentSet);
    }

    public void removeAllContentSets() {
        ListStructure listStructure;
        if (this._persistentComposite && (listStructure = this._hash.getListStructure(CONSTITUENT_SETS_KEY)) != null) {
            listStructure.clear();
        }
        this._constituentSets.clear();
    }

    public void removeContentSet(int n) {
        ListStructure listStructure;
        if (this._persistentComposite && (listStructure = this._hash.getListStructure(CONSTITUENT_SETS_KEY)) != null) {
            listStructure.remove(n);
        }
        this._constituentSets.remove(n);
    }

    List flatten() {
        ArrayList arrayList = new ArrayList();
        this.flattenImpl(arrayList);
        return arrayList;
    }

    private void flattenImpl(ArrayList arrayList) {
        URLPath uRLPath = this.getURLPath();
        Iterator iterator = uRLPath.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            ContentSet contentSet = new ContentSet(HashStructure.newInstance());
            contentSet.getURLPath().add(uRL);
            this.getPatternFilters().copyTo((Object)contentSet.getPatternFilters());
            arrayList.add(contentSet);
        }
        int n = this.countContentSets();
        int n2 = 0;
        while (n2 < n) {
            ContentSet contentSet = this.getContentSet(n2);
            contentSet.flattenImpl(arrayList);
            ++n2;
        }
    }

    public List getDirectories(String string) {
        return this.getDirectories0(string, null, null);
    }

    public List getDirectories(String string, IntersectedFilters intersectedFilters) {
        return this.getDirectories0(string, intersectedFilters, null);
    }

    public List getDirectories(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        return this.getDirectories0(string, intersectedFilters, uRLFilter);
    }

    public List getFiles(String string) {
        return this.getFiles0(string, null, null);
    }

    public List getFiles(String string, IntersectedFilters intersectedFilters) {
        return this.getFiles0(string, intersectedFilters, null);
    }

    public List getFiles(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        return this.getFiles0(string, intersectedFilters, uRLFilter);
    }

    public List getFilesAndDirectories(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        return this.getFilesAndDirectories0(string, intersectedFilters, uRLFilter);
    }

    public List getNodes(String string) {
        return this.getNodes0(string, null, null);
    }

    public List getNodes(String string, IntersectedFilters intersectedFilters) {
        return this.getNodes0(string, intersectedFilters, null);
    }

    public List getNodes(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        return this.getNodes0(string, intersectedFilters, uRLFilter);
    }

    public URL toQualifiedURL(String string) {
        URL uRL;
        if (this._intersectedFilters.isIncluded(string) && (uRL = this._urlPath.toQualifiedURL(string)) != null) {
            return uRL;
        }
        for (ContentSet contentSet : this._constituentSets) {
            URL uRL2 = contentSet.toQualifiedURL(string);
            if (uRL2 == null) continue;
            return uRL2;
        }
        return null;
    }

    public String toRelativePath(URL uRL) {
        String string = this._urlPath.toRelativePath(uRL);
        if (string != null && this._intersectedFilters.isIncluded(string)) {
            return string;
        }
        for (ContentSet contentSet : this._constituentSets) {
            String string2 = contentSet.toRelativePath(uRL);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public Iterator urlIterator(String string) {
        return this.urlIterator(string, null);
    }

    public Iterator urlIterator(String string, IntersectedFilters intersectedFilters) {
        return this.urlIterator(string, intersectedFilters, null);
    }

    public Iterator urlIterator(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        ContentLevel contentLevel;
        ContentLevel contentLevel2 = ContentLevel.newInstance(this, intersectedFilters);
        if (string == null || string.equals("")) {
            contentLevel = contentLevel2;
        } else {
            ContentLevel contentLevel3 = contentLevel2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken() + "/";
                if (!"".equals(string2) && (contentLevel3 = contentLevel3.getContentLevel(string2)) == null) break;
            }
            contentLevel = contentLevel3;
        }
        return new 2Itr(this, contentLevel, uRLFilter);
    }

    public Iterator nodeIterator(String string) {
        return this.nodeIterator(string, null);
    }

    public Iterator nodeIterator(String string, IntersectedFilters intersectedFilters) {
        return this.nodeIterator(string, intersectedFilters, null);
    }

    public Iterator nodeIterator(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        Iterator iterator = this.urlIterator(string, intersectedFilters, uRLFilter);
        return new 1Itr(this, iterator);
    }

    static void sortListAndEliminateDuplicates(List list, Comparator comparator) {
        if (comparator != null) {
            Collections.sort(list, comparator);
        } else {
            Collections.sort(list);
        }
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2.equals(e)) {
                    iterator.remove();
                    continue;
                }
                e = e2;
            }
        }
    }

    private ListStructure getOrCreateMiscList() {
        if (this._miscList == null) {
            this._miscList = this._hash.getOrCreateListStructure(MISC_URLS_KEY);
        }
        return this._miscList;
    }

    private ListStructure getMiscList() {
        if (this._miscList == null) {
            this._miscList = this._hash.getListStructure(MISC_URLS_KEY);
        }
        return this._miscList;
    }

    private void maybeClearMiscList() {
        if (this._miscList != null && this._miscList.size() <= 0) {
            this._hash.remove(MISC_URLS_KEY);
        }
    }

    private URLComparator getURLComparator() {
        if (this._urlComparator == null) {
            this._urlComparator = new URLComparator();
        }
        return this._urlComparator;
    }

    private IntersectedFilters combineWithFilters(IntersectedFilters intersectedFilters) {
        return intersectedFilters != null ? new IntersectedFilters(this._intersectedFilters, intersectedFilters) : this._intersectedFilters;
    }

    private List getDirectories0(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        List list = this.getDirectoriesImpl(string, intersectedFilters, uRLFilter);
        ContentSet.sortListAndEliminateDuplicates(list, null);
        return list;
    }

    private List getDirectoriesImpl(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        ArrayList arrayList;
        IntersectedFilters intersectedFilters2 = this.combineWithFilters(intersectedFilters);
        TriStateBoolean triStateBoolean = intersectedFilters2.inferFromFilters(string);
        if (triStateBoolean.isTrue() || triStateBoolean.isTriState()) {
            arrayList = this._urlPath.getDirectories(string, uRLFilter);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                TriStateBoolean triStateBoolean2 = intersectedFilters2.inferFromFilters(string2);
                if (!triStateBoolean2.isFalse()) continue;
                iterator.remove();
            }
        } else {
            arrayList = new ArrayList();
        }
        for (ContentSet contentSet : this._constituentSets) {
            arrayList.addAll(contentSet.getDirectoriesImpl(string, intersectedFilters, uRLFilter));
        }
        return arrayList;
    }

    private List getFiles0(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        List list = this.getFilesImpl(string, intersectedFilters, uRLFilter);
        ContentSet.sortListAndEliminateDuplicates(list, this.getURLComparator());
        return list;
    }

    private List getFilesImpl(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        ArrayList arrayList;
        IntersectedFilters intersectedFilters2 = this.combineWithFilters(intersectedFilters);
        TriStateBoolean triStateBoolean = intersectedFilters2.inferFromFilters(string);
        if (triStateBoolean.isTrue() || triStateBoolean.isTriState()) {
            arrayList = this._urlPath.getFiles(string, uRLFilter);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                URL uRL = (URL)iterator.next();
                String string2 = this._urlPath.toRelativePath(uRL);
                if (intersectedFilters2.isIncluded(string2)) continue;
                iterator.remove();
            }
        } else {
            arrayList = new ArrayList();
        }
        for (ContentSet contentSet : this._constituentSets) {
            arrayList.addAll(contentSet.getFilesImpl(string, intersectedFilters, uRLFilter));
        }
        return arrayList;
    }

    private List getFilesAndDirectories0(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        List list = this.getFilesAndDirectoriesImpl(string, intersectedFilters, uRLFilter);
        ContentSet.sortListAndEliminateDuplicates(list, this.getURLComparator());
        return list;
    }

    private List getFilesAndDirectoriesImpl(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        List list = this._urlPath.getFilesAndDirectories(string, false, uRLFilter);
        IntersectedFilters intersectedFilters2 = this.combineWithFilters(intersectedFilters);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            String string2 = this._urlPath.toRelativePath(uRL);
            if (string2.endsWith("/")) {
                TriStateBoolean triStateBoolean = intersectedFilters2.inferFromFilters(string2);
                if (!triStateBoolean.isFalse()) continue;
                iterator.remove();
                continue;
            }
            if (intersectedFilters2.isIncluded(string2)) continue;
            iterator.remove();
        }
        for (ContentSet contentSet : this._constituentSets) {
            list.addAll(contentSet.getFilesAndDirectoriesImpl(string, intersectedFilters, uRLFilter));
        }
        return list;
    }

    private List getNodes0(String string, IntersectedFilters intersectedFilters, URLFilter uRLFilter) {
        List list = this.getFiles(string, intersectedFilters, uRLFilter);
        Iterator iterator = list.iterator();
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        while (iterator.hasNext()) {
            try {
                arrayList.add(NodeFactory.findOrCreate((URL)iterator.next()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    static ListStructure mav$getMiscList(ContentSet contentSet) {
        return contentSet.getMiscList();
    }

    public class 2Itr
    implements Iterator {
        private final LinkedList _levelQueue;
        private Iterator _filesIter;
        private boolean _miscFilesChecked;
        private final /* synthetic */ ContentLevel v$initialLevel;
        private final /* synthetic */ URLFilter v$urlFilter;
        final /* synthetic */ ContentSet this$0;

        void $init$() {
            this._levelQueue = new LinkedList();
        }

        2Itr(ContentSet contentSet, ContentLevel contentLevel, URLFilter uRLFilter) {
            this.v$urlFilter = uRLFilter;
            this.v$initialLevel = contentLevel;
            this.this$0 = contentSet;
            this.$init$();
            if (contentLevel != null) {
                this._levelQueue.add(contentLevel);
            }
        }

        public boolean hasNext() {
            this.ensurePrepared();
            return this._filesIter.hasNext();
        }

        public Object next() {
            this.ensurePrepared();
            return this._filesIter.next();
        }

        public void remove() {
            new UnsupportedOperationException().printStackTrace();
        }

        private void ensurePrepared() {
            if (this._filesIter == null || !this._filesIter.hasNext()) {
                while (this._levelQueue.size() > 0) {
                    ContentLevel contentLevel = (ContentLevel)this._levelQueue.removeFirst();
                    List list = contentLevel.getDirectories();
                    Iterator iterator = list.iterator();
                    ArrayList<ContentLevel> arrayList = new ArrayList<ContentLevel>();
                    while (iterator.hasNext()) {
                        String string = iterator.next().toString();
                        ContentLevel contentLevel2 = contentLevel.getContentLevel(string);
                        if (contentLevel2 == null) continue;
                        arrayList.add(contentLevel2);
                    }
                    this._levelQueue.addAll(0, arrayList);
                    ArrayList arrayList2 = new ArrayList(contentLevel.getFiles());
                    if (this.v$urlFilter != null) {
                        Iterator iterator2 = arrayList2.iterator();
                        while (iterator2.hasNext()) {
                            URL uRL = (URL)iterator2.next();
                            if (this.v$urlFilter.accept(uRL)) continue;
                            iterator2.remove();
                        }
                    }
                    this._filesIter = arrayList2.iterator();
                    if (!this._filesIter.hasNext()) continue;
                    return;
                }
                if (!this._miscFilesChecked) {
                    this._miscFilesChecked = true;
                    ListStructure listStructure = ContentSet.mav$getMiscList(this.this$0);
                    if (listStructure != null) {
                        this._filesIter = listStructure.iterator();
                        return;
                    }
                }
                this._filesIter = Collections.EMPTY_LIST.iterator();
            }
        }
    }

    public class 1Itr
    implements Iterator {
        private final /* synthetic */ Iterator v$urlIter;
        final /* synthetic */ ContentSet this$0;

        public boolean hasNext() {
            return this.v$urlIter.hasNext();
        }

        public Object next() {
            URL uRL = (URL)this.v$urlIter.next();
            try {
                Node node = NodeFactory.findOrCreate(uRL);
                return node;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var4_4 = null;
                return var4_4;
            }
        }

        public void remove() {
            new UnsupportedOperationException().printStackTrace();
        }

        1Itr(ContentSet contentSet, Iterator iterator) {
            this.v$urlIter = iterator;
            this.this$0 = contentSet;
        }
    }
}

