/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.ContentElement;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.net.URLPath;

final class ContentSetFolder
extends ContentElement {
    private final ContentSet _contentSet;
    private final String _shortLabel;
    private final Context _context;

    ContentSetFolder(ContentSet contentSet, String string, Context context) {
        super(string, ContentLevel.getFolderIcon());
        this._contentSet = contentSet;
        this._shortLabel = string;
        this._context = context;
        this.getContentSetKeys();
    }

    public URLPath getRootDirectories() {
        return this._contentSet.getAllRootDirs();
    }

    public String getRelativePath() {
        return "";
    }

    public List getContentSetKeys() {
        ArrayList arrayList = new ArrayList();
        ContentSetFolder.getContentSetKeysImpl(arrayList, this._contentSet);
        return arrayList;
    }

    private static void getContentSetKeysImpl(ArrayList arrayList, ContentSet contentSet) {
        String string = contentSet.getContentSetName();
        if (string != null) {
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            return;
        }
        int n = contentSet.countContentSets();
        int n2 = 0;
        while (n2 < n) {
            ContentSet contentSet2 = contentSet.getContentSet(n2);
            ContentSetFolder.getContentSetKeysImpl(arrayList, contentSet2);
            ++n2;
        }
    }

    List getChildrenList() {
        ArrayList arrayList = new ArrayList();
        if (this._context.getBoolean("show-root-dirs")) {
            ContentLevel.initSourceRootFolders(this._contentSet, this._context, arrayList);
        } else {
            ContentLevel.initMergedChildren(this._contentSet, this._context, arrayList);
        }
        return arrayList;
    }
}

