/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;

public class ContentSetHelper {
    private String _key;
    protected ProjectContent _projectContent;

    public ContentSetHelper(String string) {
        this._key = string;
    }

    public boolean canAddContent(URL uRL, ProjectContent projectContent) {
        this._projectContent = projectContent;
        return uRL != null && projectContent != null;
    }

    public final void addContent(URL uRL, ProjectContent projectContent, boolean bl, ProgressBar progressBar) {
        this._projectContent = projectContent;
        if (this.restoreContent(uRL, projectContent)) {
            return;
        }
        ContentSet contentSet = this.getBaseContentSet(projectContent);
        if (contentSet.getAllRootDirs().size() == 0) {
            this.addContentImpl(uRL, contentSet, bl, progressBar);
        } else {
            ContentSet contentSet2 = this.newContentSet();
            this.addContentImpl(uRL, contentSet2, bl, progressBar);
            this.postProcess(contentSet);
        }
    }

    protected void addContentImpl(URL uRL, ContentSet contentSet, boolean bl, ProgressBar progressBar) {
        if (URLFileSystem.isDirectory(uRL)) {
            URL[] uRLArray = new URL[]{uRL};
            contentSet.getURLPath().setEntries(uRLArray);
            if (!bl) {
                contentSet.getPatternFilters().addInclude("*");
            }
        } else {
            URL uRL2 = URLFileSystem.getParent(uRL);
            URL[] uRLArray = new URL[]{uRL2};
            contentSet.getURLPath().setEntries(uRLArray);
            String string = contentSet.getURLPath().toRelativePath(uRL);
            contentSet.getPatternFilters().addInclude(string);
        }
    }

    public final boolean restoreContent(URL uRL, ProjectContent projectContent) {
        this._projectContent = projectContent;
        ContentSet contentSet = this.getBaseContentSet(projectContent);
        if (contentSet.getAllRootDirs().toRelativePath(uRL) != null) {
            return this.restoreContentImpl(uRL, contentSet);
        }
        return false;
    }

    protected boolean restoreContentImpl(URL uRL, ContentSet contentSet) {
        String string;
        URLPath uRLPath = contentSet.getURLPath();
        if (uRLPath != null && uRLPath.size() > 0 && (string = contentSet.getURLPath().toRelativePath(uRL)) != null && this.unExclude(string, contentSet)) {
            return true;
        }
        int n = 0;
        while (n < contentSet.countContentSets()) {
            if (this.restoreContentImpl(uRL, contentSet.getContentSet(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected final boolean unExclude(String string, ContentSet contentSet) {
        PatternFilter[] patternFilterArray = contentSet.getPatternFilters().getFilters();
        if (patternFilterArray == null) {
            return true;
        }
        List<PatternFilter> list = Arrays.asList(patternFilterArray);
        ArrayList<PatternFilter> arrayList = new ArrayList<PatternFilter>(list);
        int n = arrayList.size();
        if (n == 0) {
            arrayList.add(PatternFilter.newInclude(string));
        } else {
            boolean bl = false;
            PatternFilter patternFilter = PatternFilter.newExclude(string);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                PatternFilter patternFilter2 = (PatternFilter)iterator.next();
                if (patternFilter.equals(patternFilter2)) {
                    iterator.remove();
                    continue;
                }
                if (!patternFilter2.isInclude() || patternFilter2.containsWildcard()) continue;
                bl = true;
            }
            if (bl && arrayList.size() == n) {
                arrayList.add(0, PatternFilter.newInclude(string));
            }
        }
        if (n != arrayList.size()) {
            PatternFilter[] patternFilterArray2 = new PatternFilter[arrayList.size()];
            arrayList.toArray(patternFilterArray2);
            contentSet.getPatternFilters().setFilters(patternFilterArray2);
            return true;
        }
        return false;
    }

    public final void removeContent(URL uRL, ProjectContent projectContent) {
        this._projectContent = projectContent;
        ContentSet contentSet = this.getBaseContentSet(projectContent);
        if (contentSet.canHaveMember(uRL)) {
            this.removeContentImpl(uRL, contentSet);
        }
    }

    protected void removeContentImpl(URL uRL, ContentSet contentSet) {
        String string = contentSet.getURLPath().toRelativePath(uRL);
        if (string != null) {
            PatternFilters patternFilters = contentSet.getPatternFilters();
            if (patternFilters.getFilters() != null) {
                patternFilters.addExclude(string);
            } else {
                PatternFilter[] patternFilterArray = new PatternFilter[]{PatternFilter.newExclude(string), PatternFilter.newInclude("**")};
                contentSet.getPatternFilters().setFilters(patternFilterArray);
            }
        }
        int n = contentSet.countContentSets();
        int n2 = 0;
        while (n2 < n) {
            this.removeContentImpl(uRL, contentSet.getContentSet(n2));
            ++n2;
        }
    }

    protected final ContentSet newContentSet() {
        ContentSet contentSet = this._projectContent.getContentSet(this._key);
        ContentSet contentSet2 = new ContentSet(HashStructure.newInstance());
        contentSet.addContentSet(contentSet2);
        return contentSet2;
    }

    protected final ContentSet getBaseContentSet(ProjectContent projectContent) {
        return projectContent.getContentSet(this._key);
    }

    private void postProcess(ContentSet contentSet) {
        URL[] uRLArray;
        int n = contentSet.countContentSets();
        if (n > 0 && (uRLArray = contentSet.getURLPath().getEntries()).length > 0) {
            URL uRL = contentSet.getContentFolderURL();
            int n2 = 0;
            while (n2 < uRLArray.length) {
                ContentSet contentSet2 = new ContentSet(HashStructure.newInstance());
                contentSet2.getURLPath().setEntries(new URL[]{uRLArray[n2]});
                if (uRL != null) {
                    contentSet2.setContentFolderURL(uRL);
                }
                contentSet2.getPatternFilters().setFilters(contentSet.getPatternFilters().getFilters());
                contentSet.addContentSet(contentSet2);
                ++n2;
            }
            contentSet.getURLPath().setEntries(null);
            contentSet.getPatternFilters().setFilters(null);
        }
    }
}

