/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.model.DataList;
import oracle.ide.model.DataNode;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Reference;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.FilePath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;

public class DataContainer
extends DataNode
implements Observer,
Folder,
PropertyStorage {
    final HashStructure _hash;
    final DirtyTracker _hashDirtyTracker;
    private final transient HashMap _transientProperties;
    private final ArrayList _children;
    private static final String URL = "URL";
    private static final String NODE_CLASS = "nodeClass";
    private static final String LIST_OF_CHILDREN = "listOfChildren";

    void $init$() {
        this._hash = HashStructure.newInstance();
        this._hashDirtyTracker = new HashDirtyTracker();
        this._transientProperties = new HashMap();
        this._children = new ArrayList();
    }

    public DataContainer() {
        this.$init$();
        this.init();
    }

    public DataContainer(URL uRL) {
        super(uRL);
        this.$init$();
        this.init();
    }

    private void init() {
        this.getAttributes().set(ElementAttributes.HIDE_FILE_EXTENSION);
    }

    public HashStructure getProperties() {
        return this.getSharedPropertiesOnly();
    }

    public HashStructure getUserPropertiesOnly() {
        return this.getSharedPropertiesOnly();
    }

    public final HashStructure getSharedPropertiesOnly() {
        HashStructure[] hashStructureArray = new HashStructure[1];
        2 var2_2 = new 2(this, hashStructureArray);
        this.runWhileSynchronized(var2_2);
        return hashStructureArray[0];
    }

    public final String getProperty(String string) {
        return this.getProperties().getString(string);
    }

    public final String getProperty(String string, String string2) {
        return this.getProperties().getString(string, string2);
    }

    public final void setProperty(String string, String string2) {
        this.getProperties().putString(string, string2);
    }

    public final Map getTransientProperties() {
        HashMap[] hashMapArray = new HashMap[1];
        1 var2_2 = new 1(this, hashMapArray);
        this.runWhileSynchronized(var2_2);
        return hashMapArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListOfChildren() throws TransientMarker {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            DataList dataList = new DataList(this._children);
            return dataList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListOfChildren(List list) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this.detachFromAll(this._children);
            this._children.clear();
            this.getListOfChildrenListStructure().clear();
        }
        if (list != null) {
            for (Object e : list) {
                if (e instanceof Reference) {
                    Reference reference = (Reference)e;
                    this.add(reference.getData());
                    continue;
                }
                if (!(e instanceof Element)) continue;
                this.add((Element)e);
            }
        }
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        return this.getChildrenImpl(true);
    }

    final Iterator getChildrenImpl(boolean bl) {
        try {
            if (this.ensureOpen()) {
                ArrayList arrayList = new ArrayList();
                this.copyChildrenTo(arrayList, bl);
                Iterator iterator = arrayList.iterator();
                return iterator;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChildrenTo(List list, boolean bl) {
        if (this._children.size() > 0) {
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                list.addAll(this._children);
            }
        }
    }

    public boolean canAdd(Element element) {
        return element != null;
    }

    public boolean add(Element element) {
        return this.add(element, false);
    }

    public boolean canRemove(Element element) {
        return element != null;
    }

    public boolean remove(Element element) {
        return this.remove(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChild(Element element) {
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                boolean bl = this._children.contains(element);
                return bl;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                int n = this._children.size();
                return n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public void removeAll() {
        this.removeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element, boolean bl) {
        boolean bl2 = false;
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                if (element != null && !this._children.contains(element)) {
                    bl2 = this._children.add(element);
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        HashStructure hashStructure = HashStructure.newInstance();
                        hashStructure.putURL(URL, locatable.getURL());
                        hashStructure.putString(NODE_CLASS, element.getClass().getName());
                        this.getListOfChildrenListStructure().add((Object)hashStructure);
                        this.attachTo(element);
                    }
                    if (bl2) {
                        this.setSubDirtyableOwner(element, this);
                        this.markDirty(true);
                    }
                }
            }
            if (bl && bl2) {
                UpdateMessage.fireChildAdded(this, element);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element, boolean bl) {
        boolean bl2 = false;
        try {
            this.open();
            ArrayList arrayList = this._children;
            synchronized (arrayList) {
                if (element != null && this._children.contains(element)) {
                    bl2 = this._children.remove(element);
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        URL uRL = locatable.getURL();
                        ListStructure listStructure = this.getListOfChildrenListStructure();
                        Iterator iterator = listStructure.iterator();
                        while (iterator.hasNext()) {
                            HashStructure hashStructure = (HashStructure)iterator.next();
                            if (!ModelUtil.areEqual((Object)uRL, (Object)hashStructure.getURL(URL))) continue;
                            iterator.remove();
                            this.detachFrom(element);
                            break;
                        }
                    }
                    this.setSubDirtyableOwner(element, null);
                    this.markDirty(true);
                }
            }
            if (bl && bl2) {
                UpdateMessage.fireChildRemoved(this, element);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean bl) {
        try {
            this.open();
            ArrayList arrayList = null;
            ArrayList arrayList2 = this._children;
            synchronized (arrayList2) {
                this.resetSubDirtyableOwners(this._children);
                if (bl && !this._children.isEmpty()) {
                    arrayList = new ArrayList(this._children);
                    this.detachFromAll(arrayList);
                }
                this._children.clear();
                this.getListOfChildrenListStructure().clear();
            }
            if (arrayList != null) {
                UpdateMessage.fireChildrenRemoved(this, arrayList);
            }
            this.markDirty(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final String getBaseDirectory() {
        URL uRL = this.getURL();
        String string = uRL.getPath();
        String string2 = FilePath.getParent(string);
        return string2;
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        this._hash.setParentDirtyable((oracle.javatools.data.Dirtyable)this._hashDirtyTracker);
        this.initListOfChildren();
        this.initTransientProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
        }
        super.closeImpl();
        this._hash.setParentDirtyable(null);
    }

    protected void postCloseImpl() {
        this._hash.clear();
        this._transientProperties.clear();
    }

    void initListOfChildren() {
        ListStructure listStructure = this.getListOfChildrenListStructure();
        Iterator iterator = listStructure.iterator();
        while (iterator.hasNext()) {
            try {
                HashStructure hashStructure = (HashStructure)iterator.next();
                URL uRL = hashStructure.getURL(URL);
                String string = hashStructure.getString(NODE_CLASS);
                Class<?> clazz = null;
                if (string != null) {
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = null;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                Node node = clazz != null ? NodeFactory.findOrCreate(clazz, uRL) : NodeFactory.findOrCreate(uRL);
                this._children.add(node);
                this.attachTo(node);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED && object instanceof Locatable) {
            Locatable locatable = (Locatable)object;
            ListStructure listStructure = this.getListOfChildrenListStructure();
            block0: for (URL uRL : updateMessage.getModifyObjects()) {
                for (HashStructure hashStructure : listStructure) {
                    if (!hashStructure.getURL(URL).equals(uRL)) continue;
                    hashStructure.putURL(URL, locatable.getURL());
                    continue block0;
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DataContainer)object);
    }

    protected final boolean equalsImpl(DataContainer dataContainer) {
        boolean bl = super.equalsImpl(dataContainer);
        if (this.isOpen() && dataContainer.isOpen()) {
            return bl && ModelUtil.areEqual((Object)this._hash, (Object)dataContainer._hash);
        }
        return bl && dataContainer == this;
    }

    public boolean add(Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element && this.add((Element)e, false)) continue;
            bl2 = false;
        }
        if (bl && bl2) {
            UpdateMessage.fireChildrenAdded(this, collection);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetSubDirtyableOwners(List list) {
        List list2 = list;
        synchronized (list2) {
            for (Element element : list) {
                this.setSubDirtyableOwner(element, null);
            }
        }
    }

    protected void setSubDirtyableOwner(Element element, Dirtyable dirtyable) {
        if (element instanceof SubDirtyable) {
            ((SubDirtyable)((Object)element)).setOwner(dirtyable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void copyToImpl(DataContainer dataContainer) {
        ArrayList arrayList;
        super.copyToImpl(dataContainer);
        this.ensureOpen();
        dataContainer.ensureOpen();
        dataContainer.initTransientProperties();
        this._hash.copyTo(dataContainer._hash);
        ArrayList arrayList2 = this._children;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this._children);
        }
        ArrayList arrayList3 = dataContainer._children;
        synchronized (arrayList3) {
            dataContainer._children.clear();
            dataContainer._children.addAll(arrayList);
        }
    }

    private ListStructure getListOfChildrenListStructure() {
        return this.getSharedPropertiesOnly().getOrCreateListStructure(LIST_OF_CHILDREN);
    }

    private void attachTo(Element element) {
        if (element instanceof Subject && element instanceof Locatable) {
            ((Subject)((Object)element)).attach(this);
        }
    }

    private void detachFrom(Element element) {
        if (element instanceof Subject && element instanceof Locatable) {
            ((Subject)((Object)element)).detach(this);
        }
    }

    private void detachFromAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.detachFrom((Element)iterator.next());
        }
    }

    private void initTransientProperties() {
        this._transientProperties.put(new Object(), null);
        if (this._transientProperties.size() == 0) {
            this._transientProperties.put(new Object(), null);
        }
    }

    static HashMap ra$_transientProperties(DataContainer dataContainer) {
        return dataContainer._transientProperties;
    }

    public final class HashDirtyTracker
    extends DirtyTracker {
        HashDirtyTracker() {
        }
    }

    public class DirtyTracker
    implements Dirtyable {
        private boolean _dirty;

        public boolean isDirty() {
            return this._dirty;
        }

        public void markDirty(boolean bl) {
            this._dirty = bl;
            this.propagate(bl);
        }

        void propagate(boolean bl) {
            DataContainer.this.markDirty(bl);
        }

        void clearDirty() {
            this._dirty = false;
        }

        DirtyTracker() {
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ HashStructure[] v$results;
        final /* synthetic */ DataContainer this$0;

        public void run() {
            this.this$0.ensureOpen();
            this.v$results[0] = this.this$0._hash;
        }

        public 2(DataContainer dataContainer, HashStructure[] hashStructureArray) {
            this.v$results = hashStructureArray;
            this.this$0 = dataContainer;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ HashMap[] v$results;
        final /* synthetic */ DataContainer this$0;

        public void run() {
            if (DataContainer.ra$_transientProperties(this.this$0).size() == 0) {
                this.this$0.ensureOpen();
            }
            this.v$results[0] = DataContainer.ra$_transientProperties(this.this$0);
        }

        public 1(DataContainer dataContainer, HashMap[] hashMapArray) {
            this.v$results = hashMapArray;
            this.this$0 = dataContainer;
        }
    }
}

