/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.ide.model.Attributes;

public abstract class DefaultAttributes
implements Attributes {
    public static final Attributes EMPTY_ATTRIBUTES = new 1();
    public static final int NONE = DefaultAttributes.noneAttr();
    private int _attributes;

    public DefaultAttributes() {
    }

    public DefaultAttributes(int n) {
        this.set(n);
    }

    public DefaultAttributes(DefaultAttributes defaultAttributes) {
        this._attributes = defaultAttributes._attributes;
    }

    public boolean isSet(int n) {
        return (this._attributes & n) == n;
    }

    public void set(int n) {
        this._attributes |= n;
    }

    public void unset(int n) {
        this._attributes &= ~n;
    }

    public void clear() {
        this._attributes = DefaultAttributes.noneAttr();
    }

    protected static final int noneAttr() {
        return 0;
    }

    protected static final int minAttr() {
        return 1;
    }

    protected static final int maxAttr() {
        return Integer.MIN_VALUE;
    }

    protected static final int incAttr(int n) {
        return n << 1;
    }

    protected static final int decAttr(int n) {
        return n >>> 1;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DefaultAttributes)object);
    }

    protected final boolean equalsImpl(DefaultAttributes defaultAttributes) {
        return this._attributes == defaultAttributes._attributes;
    }

    public static final class 1
    implements Attributes {
        public boolean isSet(int n) {
            return false;
        }

        public void set(int n) {
        }

        public void unset(int n) {
        }

        public void clear() {
        }

        public Attributes duplicate() {
            return this;
        }
    }
}

