/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.text.Collator;
import java.util.Comparator;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.util.BitField;

public class DefaultFilter
extends ChildFilter {
    public static final Comparator folderFirstComparator = new SortedFolderFirstComparator(false);
    private static final Comparator folderFirstComparator2 = new SortedFolderFirstComparator(true);

    public Comparator getComparator() {
        return this.checkElementAttributes() ? folderFirstComparator2 : folderFirstComparator;
    }

    protected void refreshExplorerNode(TNode tNode) {
        TreeExplorer treeExplorer;
        if (tNode != null && (treeExplorer = tNode.getOwner()) != null) {
            treeExplorer.refresh(tNode);
        }
    }

    private boolean checkElementAttributes() {
        TreeExplorer treeExplorer;
        if (this.getOwner() != null && (treeExplorer = this.getOwner().getOwner()) != null) {
            return treeExplorer.getCellRendererAttributes().isSet(CellRendererAttributes.HIDE_CHILDREN);
        }
        return false;
    }

    private static class SortedComparator
    implements Comparator {
        public static final int SORT_ALPHA = 1;
        public static final int SORT_BY_TYPE = 2;
        private int _options;
        protected static final Collator collator = Collator.getInstance();

        void $init$() {
            this._options = 1;
        }

        public int getOptions() {
            return this._options;
        }

        public void setOptions(int n) {
            this._options = n;
        }

        public final int compare(Object object, Object object2) {
            return this.compareTNodes((TNode)object, (TNode)object2);
        }

        public boolean equals(Object object) {
            return this.getClass() == object.getClass();
        }

        protected int compareTNodes(TNode tNode, TNode tNode2) {
            return this.compareElements(tNode.getData(), tNode2.getData());
        }

        protected int compareElements(Element element, Element element2) {
            return this.compareElementToElement(element, element2);
        }

        protected int compareElementToElement(Element element, Element element2) {
            if (BitField.isSet(2, this.getOptions())) {
                return this.sortByType(element, element2);
            }
            int n = this.compareStrings(element.getShortLabel(), element2.getShortLabel());
            if (n != 0) {
                return n;
            }
            return this.compareStrings(element.getLongLabel(), element2.getLongLabel());
        }

        protected int compareStrings(String string, String string2) {
            if (string == null) {
                return string2 == null ? 0 : 1;
            }
            if (string2 == null) {
                return -1;
            }
            return collator.compare(string, string2);
        }

        private String getPrefix(Element element) {
            if (element.getIcon() != null) {
                return element.getIcon().toString();
            }
            return "";
        }

        private int sortByType(Element element, Element element2) {
            String string = this.getPrefix(element);
            String string2 = this.getPrefix(element2);
            int n = this.compareStrings(string + element.getShortLabel(), string2 + element2.getShortLabel());
            if (n != 0) {
                return n;
            }
            return this.compareStrings(string + element.getLongLabel(), string2 + element2.getLongLabel());
        }

        private SortedComparator() {
            this.$init$();
        }

        SortedComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SortedFolderFirstComparator
    extends SortedComparator {
        private boolean _checkAttributes;

        public SortedFolderFirstComparator() {
            super(null);
        }

        protected SortedFolderFirstComparator(boolean bl) {
            super(null);
            this._checkAttributes = bl;
        }

        public boolean equals(Object object) {
            return this.getClass() == object.getClass() && this._checkAttributes == ((SortedFolderFirstComparator)object)._checkAttributes;
        }

        protected int compareElements(Element element, Element element2) {
            if (this.isFolder(element) != this.isFolder(element2)) {
                return this.isFolder(element) ? this.compareUnlikeElementToElement(element, element2) : -this.compareUnlikeElementToElement(element2, element);
            }
            return super.compareElements(element, element2);
        }

        protected int compareUnlikeElementToElement(Element element, Element element2) {
            return -1;
        }

        protected boolean isFolder(Element element) {
            if (element == null || !element.mayHaveChildren()) {
                return false;
            }
            if (this._checkAttributes) {
                return element.getAttributes().isSet(ElementAttributes.HIDE_CHILDREN) ^ true;
            }
            return true;
        }
    }
}

