/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.javatools.data.HashStructure;

public class DependableFactory {
    private final List _factories;
    private final WeakHashMap _cache;

    void $init$() {
        this._factories = new ArrayList();
        this._cache = new WeakHashMap();
    }

    public DependableFactory() {
        this.$init$();
    }

    public synchronized void registerFactory(DependableRecognizer dependableRecognizer) {
        this._factories.add(dependableRecognizer);
    }

    public synchronized void removeFactory(DependableRecognizer dependableRecognizer) {
        this._factories.remove(dependableRecognizer);
    }

    public synchronized boolean hasFactory(Element element) {
        int n = 0;
        while (n < this._factories.size()) {
            DependableRecognizer dependableRecognizer = (DependableRecognizer)this._factories.get(n);
            if (dependableRecognizer.recognize(element)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Dependable findOrCreate(Element element, Folder folder) throws IllegalAccessException, InstantiationException {
        if (element == null) {
            return null;
        }
        List list = this.findList(element);
        Dependable dependable = this.findOwnedBy(folder, list);
        if (dependable != null) {
            return dependable;
        }
        int n = 0;
        while (n < this._factories.size()) {
            DependableRecognizer dependableRecognizer = (DependableRecognizer)this._factories.get(n);
            if (dependableRecognizer.recognize(element)) {
                dependable = dependableRecognizer.create(element, folder);
                this.cache(dependable, list);
                break;
            }
            ++n;
        }
        return dependable;
    }

    public synchronized Dependable find(Element element) {
        if (element != null) {
            return this.find(element, null);
        }
        return null;
    }

    public synchronized Dependable find(Element element, Folder folder) {
        return this.findOwnedBy(folder, this.findList(element));
    }

    public synchronized Dependable[] findAll(Element element) {
        List list = this.findList(element);
        if (list == null || list.size() == 0) {
            return null;
        }
        Dependable[] dependableArray = new Dependable[list.size()];
        return list.toArray(dependableArray);
    }

    public synchronized void cache(Dependable dependable) {
        if (this.find(dependable.getSource(), dependable.getSourceOwner()) != null) {
            return;
        }
        this.cache(dependable, this.findList(dependable.getSource()));
    }

    public synchronized void uncache(Dependable dependable) {
        List list = this.findList(dependable.getSource());
        if (list == null) {
            return;
        }
        int n = this.findOwnedByIndex(dependable.getSourceOwner(), list);
        if (n >= 0) {
            list.remove(n);
        }
    }

    static HashStructure toHashStructure(Dependable dependable) throws Exception {
        Class<?> clazz = dependable.getClass();
        Method method = clazz.getMethod("getSourceOwnerURL", null);
        URL uRL = (URL)method.invoke((Object)dependable, null);
        Method method2 = clazz.getMethod("getSourceURL", null);
        URL uRL2 = (URL)method2.invoke((Object)dependable, null);
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString("class", clazz.getName());
        hashStructure.putURL("sourceOwnerURL", uRL);
        hashStructure.putURL("sourceURL", uRL2);
        return hashStructure;
    }

    static Dependable toDependable(HashStructure hashStructure) throws Exception {
        Node node;
        String string = hashStructure.getString("class");
        Object obj = Class.forName(string).newInstance();
        Class<?> clazz = obj.getClass();
        Method method = clazz.getMethod("setSourceOwnerURL", URL.class);
        URL uRL = hashStructure.getURL("sourceOwnerURL");
        method.invoke(obj, uRL);
        Method method2 = clazz.getMethod("setSourceURL", URL.class);
        URL uRL2 = hashStructure.getURL("sourceURL");
        method2.invoke(obj, uRL2);
        Dependable dependable = (Dependable)obj;
        Element element = dependable.getSource();
        if (element instanceof Node && !(node = (Node)element).isOpen() && node.isNew()) {
            return null;
        }
        return dependable;
    }

    private List findList(Element element) {
        return (List)this._cache.get(element);
    }

    private Dependable findOwnedBy(Folder folder, List list) {
        int n = this.findOwnedByIndex(folder, list);
        if (n >= 0) {
            return (Dependable)list.get(n);
        }
        return null;
    }

    private int findOwnedByIndex(Folder folder, List list) {
        if (list != null && list.size() > 0) {
            if (folder == null) {
                return 0;
            }
            int n = 0;
            while (n < list.size()) {
                Dependable dependable = (Dependable)list.get(n);
                if (dependable.getSourceOwner() == folder) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private void cache(Dependable dependable, List arrayList) {
        if (dependable == null) {
            return;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<Dependable>();
            arrayList.add(dependable);
            this._cache.put(dependable.getSource(), arrayList);
        } else {
            arrayList.add(dependable);
        }
    }
}

