/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactory;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class DependencyConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = DependencyConfiguration.class.getName();
    private final Project _project;
    public static final String DEPENDENCY_LIST = "dependencyList";

    private DependencyConfiguration(HashStructure hashStructure, Project project) {
        super(hashStructure);
        this._project = project;
    }

    public static DependencyConfiguration getInstance(Project project) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)project, (String)DATA_KEY), project);
    }

    public static DependencyConfiguration getInstance(PropertyStorage propertyStorage) {
        return new DependencyConfiguration(DependencyConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY), null);
    }

    private ListStructure getDependenciesListStructure() {
        return this._hash.getListStructure(DEPENDENCY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencyList() {
        ListStructure listStructure = this.getDependenciesListStructure();
        if (listStructure != null) {
            ArrayList<Dependable> arrayList = new ArrayList<Dependable>();
            ListStructure listStructure2 = listStructure;
            synchronized (listStructure2) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    HashStructure hashStructure = (HashStructure)iterator.next();
                    try {
                        Dependable dependable = DependableFactory.toDependable(hashStructure);
                        if (dependable != null) {
                            arrayList.add(dependable);
                            continue;
                        }
                        iterator.remove();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return arrayList;
        }
        return null;
    }

    public void setDependencyList(List list) {
        ArrayList<HashStructure> arrayList = new ArrayList<HashStructure>();
        if (list != null) {
            for (Object e : list) {
                try {
                    HashStructure hashStructure = DependableFactory.toHashStructure((Dependable)e);
                    if (hashStructure == null) continue;
                    arrayList.add(hashStructure);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        ListStructure listStructure = this.getDependencyListStructure();
        listStructure.mirror(arrayList);
    }

    private ListStructure getDependencyListStructure() {
        return this._hash.getOrCreateListStructure(DEPENDENCY_LIST);
    }

    public void addDependency(Dependable dependable) {
        if (dependable != null) {
            ListStructure listStructure = this.getDependencyListStructure();
            try {
                HashStructure hashStructure = DependableFactory.toHashStructure(dependable);
                if (!listStructure.contains((Object)hashStructure)) {
                    listStructure.add((Object)hashStructure);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void removeDependency(Dependable dependable) {
        ListStructure listStructure;
        if (dependable != null && (listStructure = this.getDependencyListStructure()) != null) {
            try {
                HashStructure hashStructure = DependableFactory.toHashStructure(dependable);
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e == null || !e.equals(hashStructure)) continue;
                    iterator.remove();
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Iterator getDependencies() {
        List list = this.getDependencyList();
        if (list != null) {
            return list.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List getAllDependenciesList() {
        ArrayList arrayList = new ArrayList();
        ArrayList<Project> arrayList2 = new ArrayList<Project>();
        if (this._project != null) {
            arrayList2.add(this._project);
        } else {
            new Exception("*** Warning: Project not specified to DependencyConfiguration.  Cycles will not be detected properly.").printStackTrace();
        }
        this.collectDependencies(this.getDependencies(), arrayList, arrayList2);
        return arrayList;
    }

    private void collectDependencies(Iterator iterator, List list, List list2) {
        while (iterator.hasNext()) {
            Dependable dependable = (Dependable)iterator.next();
            if (DependencyConfiguration.wasSourceSeen(dependable.getSource(), list2)) continue;
            list2.add(dependable.getSource());
            this.collectDependencies(dependable.getDependencies(), list, list2);
            list.add(dependable);
        }
    }

    private static boolean wasSourceSeen(Element element, List list) {
        int n = 0;
        while (n < list.size()) {
            Element element2 = (Element)list.get(n);
            if (element2 == element) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

