/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.model.Element;
import oracle.ide.model.ElementRecognizer;
import oracle.ide.model.Project;

public final class ElementFactory {
    private static final ArrayList _recognizers = new ArrayList();

    public static Element findOrCreate(URL uRL, Project project) throws IllegalAccessException, InstantiationException {
        ElementRecognizer elementRecognizer;
        if (uRL != null && (elementRecognizer = ElementFactory.findElementRecognizer(uRL)) != null) {
            return elementRecognizer.create(uRL, project);
        }
        return null;
    }

    public static void addRecognizer(ElementRecognizer elementRecognizer) {
        if (elementRecognizer != null && !_recognizers.contains(elementRecognizer)) {
            _recognizers.add(elementRecognizer);
        }
    }

    public static void removeRecognizer(ElementRecognizer elementRecognizer) {
        if (elementRecognizer != null) {
            _recognizers.remove(elementRecognizer);
        }
    }

    private static ElementRecognizer findElementRecognizer(URL uRL) {
        if (uRL != null) {
            for (ElementRecognizer elementRecognizer : _recognizers) {
                Class clazz = elementRecognizer.recognize(uRL);
                if (clazz == null) continue;
                return elementRecognizer;
            }
        }
        return null;
    }
}

