/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Version;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.VersionNumber;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

abstract class HashStructureNodeMigrator
extends NodeMigrator {
    HashStructureNodeMigrator() {
        this.addHelper(new 1());
    }

    public MigrationInfo getMigrationInfo(Node node) {
        return new HSNodeMigrationInfo(node, this.getHelpers(), this.getRootQname());
    }

    abstract String getRootQname();

    protected NodeMigratorHelper[] getHelpers(MigrationInfo migrationInfo) {
        ArrayList arrayList = new ArrayList();
        if (migrationInfo instanceof HSNodeMigrationInfo) {
            HSNodeMigrationInfo hSNodeMigrationInfo = (HSNodeMigrationInfo)migrationInfo;
            arrayList.addAll(hSNodeMigrationInfo.getActiveHelpers());
        }
        return arrayList.toArray(new NodeMigratorHelper[arrayList.size()]);
    }

    final class 1
    extends NodeMigratorHelper {
        public void migrate(MigrationInfo[] migrationInfoArray, TraversableContext traversableContext) {
        }

        public String getNodeMigratorHelperKey() {
            return "oracle.ide.model.Project";
        }
    }

    private static class HSNodeMigrationInfo
    extends MigrationInfo {
        private final ArrayList _helpers;
        private final String _rootQname;

        void $init$() {
            this._helpers = new ArrayList();
        }

        HSNodeMigrationInfo(Node node, NodeMigratorHelper[] nodeMigratorHelperArray, String string) {
            super(node);
            this.$init$();
            if (nodeMigratorHelperArray != null) {
                this._helpers.addAll(Arrays.asList(nodeMigratorHelperArray));
            }
            this._rootQname = string;
        }

        protected void ensureVersionInfo() {
            if (this.getVersionDirectly() == null) {
                this.ensureVersionInfoImpl();
            }
        }

        private void ensureVersionInfoImpl() {
            this.setVersionStatusDirectly(MigrationInfo.VERSION_UNKNOWN);
            this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_POSSIBLE);
            this.setVersionDirectly("");
            try {
                Node node = this.getNode();
                URL uRL = node.getURL();
                StartElementPacket startElementPacket = XMLUtil.getXMLRootElement(uRL);
                if (startElementPacket != null && startElementPacket.namespaceURI != null && startElementPacket.namespaceURI.length() > 0) {
                    String string = HSNodeMigrationInfo.getVersionFromNamespaceURI(startElementPacket.namespaceURI);
                    if (string != null) {
                        if (string.equals("10130") || !string.matches("^\\d+$")) {
                            HashStructureIO hashStructureIO = new HashStructureIO("http://xmlns.oracle.com/ide/project", this._rootQname);
                            HashStructure hashStructure = (HashStructure)hashStructureIO.load(uRL);
                            ProjectVersion projectVersion = new ProjectVersion(hashStructure);
                            Iterator iterator = this._helpers.iterator();
                            while (iterator.hasNext()) {
                                String string2;
                                VersionNumber versionNumber;
                                NodeMigratorHelper nodeMigratorHelper = (NodeMigratorHelper)iterator.next();
                                VersionNumber versionNumber2 = new VersionNumber(nodeMigratorHelper.getNodeMigratorHelperVersion());
                                int n = versionNumber2.compareTo(versionNumber = (string2 = nodeMigratorHelper.getNodeMigratorHelperKey()) != null ? projectVersion.getCurrentVersion(string2) : projectVersion.getCurrentVersion());
                                if (n > 0) continue;
                                if (n == 0) {
                                    iterator.remove();
                                    continue;
                                }
                                iterator.remove();
                            }
                            if (node instanceof Project && ProjectContent.getInstance(hashStructure).isMissingAnyContentSet()) {
                                this._helpers.add(new ProjectContentHelper(null));
                            }
                            if (this._helpers.size() > 0) {
                                this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                                this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                                this.setVersionDirectly("900");
                            } else if (node instanceof Workspace) {
                                boolean bl = false;
                                ListStructure listStructure = hashStructure.getListStructure("listOfChildren");
                                if (listStructure != null) {
                                    block4: for (Object e : listStructure) {
                                        URL uRL2;
                                        NodeMigratorHelper[] nodeMigratorHelperArray;
                                        NodeMigrator nodeMigrator;
                                        HashStructure hashStructure2;
                                        String string3;
                                        if (!(e instanceof HashStructure) || (string3 = (hashStructure2 = (HashStructure)e).getString("nodeClass")) == null || (nodeMigrator = NodeMigrator.getNodeMigrator(string3)) == null || (nodeMigratorHelperArray = nodeMigrator.getHelpers()).length <= 0 || (uRL2 = hashStructure2.getURL("URL")) == null) continue;
                                        HashStructureIO hashStructureIO2 = new HashStructureIO("http://xmlns.oracle.com/ide/project", "jpr:project");
                                        HashStructure hashStructure3 = (HashStructure)hashStructureIO2.load(uRL2);
                                        ProjectVersion projectVersion2 = new ProjectVersion(hashStructure3);
                                        int n = 0;
                                        while (n < nodeMigratorHelperArray.length) {
                                            String string4;
                                            VersionNumber versionNumber;
                                            NodeMigratorHelper nodeMigratorHelper = nodeMigratorHelperArray[n];
                                            VersionNumber versionNumber3 = new VersionNumber(nodeMigratorHelper.getNodeMigratorHelperVersion());
                                            int n2 = versionNumber3.compareTo(versionNumber = (string4 = nodeMigratorHelper.getNodeMigratorHelperKey()) != null ? projectVersion2.getCurrentVersion(string4) : projectVersion2.getCurrentVersion());
                                            if (n2 > 0) {
                                                bl = true;
                                                break block4;
                                            }
                                            ++n;
                                        }
                                    }
                                }
                                if (bl) {
                                    this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                                    this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                                    this.setVersionDirectly("900");
                                } else {
                                    this.setVersionStatusDirectly(MigrationInfo.VERSION_CURRENT);
                                    this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_NEEDED);
                                    this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                                }
                            } else {
                                this.setVersionStatusDirectly(MigrationInfo.VERSION_CURRENT);
                                this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_NEEDED);
                                this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
                            }
                        } else {
                            this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                            this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                            this.setVersionDirectly(string);
                            if (node instanceof Project) {
                                this._helpers.add(new ProjectContentHelper(null));
                            }
                        }
                    }
                } else {
                    this.setMigrationStatus(MigrationInfo.MIGRATION_PENDING);
                    this.setVersionStatusDirectly(MigrationInfo.VERSION_OLDER);
                    this.setVersionDirectly("900");
                    if (node instanceof Project) {
                        this._helpers.add(new ProjectContentHelper(null));
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setVersionStatusDirectly(MigrationInfo.VERSION_CURRENT);
                this.setMigrationStatus(MigrationInfo.MIGRATION_NOT_NEEDED);
                this.setVersionDirectly(Version.BASE_NAMESPACE_URI);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        List getActiveHelpers() {
            return this._helpers;
        }
    }

    private static class ProjectContentHelper
    extends NodeMigratorHelper {
        public void migrate(MigrationInfo[] migrationInfoArray, TraversableContext traversableContext) {
            int n = migrationInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                MigrationInfo migrationInfo = migrationInfoArray[n2];
                Node node = migrationInfo.getNode();
                if (node instanceof Project) {
                    ProjectContent.initializeContentSets((Project)node);
                }
                ++n2;
            }
        }

        public String getNodeMigratorHelperKey() {
            return null;
        }

        private ProjectContentHelper() {
        }

        ProjectContentHelper(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

