/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.util.Map;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;

public final class IdeSystemMigrator
extends XMLMigrator {
    private static final String DEFAULT_WORKSPACE_DIR = "DefaultWorkspace";
    private static final String DEFAULT_WORKSPACE_NAME = "DefaultWorkspace.jws";
    private static final String DEFAULT_PROJECT_NAME = "Project1.jpr";
    public static final int SYSTEM_SETTINGS = 0;
    public static final int DEFAULT_PROJECT = 1;
    public static final int DEFAULT_WORKSPACE = 2;

    public IdeSystemMigrator() {
        super(new int[]{0, 1});
    }

    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return ModelArb.getString(49);
            }
            case 1: {
                return ModelArb.getString(50);
            }
            case 2: {
                return ModelArb.getString(51);
            }
        }
        return null;
    }

    protected String getFileName() {
        return "System.sys";
    }

    protected String getNamespaceURI() {
        return IdeSystem.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "system";
    }

    protected void prepareToMigrate() {
        Class<IdeSystem> clazz = IdeSystem.class;
    }

    protected Object adjustObject(File file, File file2, Object object) throws Exception {
        URL uRL;
        File file3 = new File(file2, DEFAULT_WORKSPACE_DIR);
        if (!file3.exists()) {
            file3.mkdirs();
        }
        IdeSystem ideSystem = (IdeSystem)object;
        Preferences preferences = ideSystem.getPreferences();
        Map map = preferences.getPreferencesMap();
        IdeSystem ideSystem2 = this.isSelected(0) ? ideSystem : this.getSettings(file2);
        Preferences preferences2 = ideSystem2.getPreferences();
        if (preferences2 == null) {
            preferences2 = (Preferences)ideSystem2.getChild(Preferences.class);
        }
        Map map2 = preferences2.getPreferencesMap();
        File file4 = new File(file3, DEFAULT_PROJECT_NAME);
        if (this.isSelected(1)) {
            uRL = (URL)map.get("DefaultProject");
            URLFileSystem.copy(uRL, file4);
        }
        map2.put("DefaultProject", URLFactory.newFileURL(file4));
        file4 = new File(file3, DEFAULT_WORKSPACE_NAME);
        if (this.isSelected(2)) {
            uRL = (URL)map.get(DEFAULT_WORKSPACE_DIR);
            URLFileSystem.copy(uRL, file4);
        }
        map2.put(DEFAULT_WORKSPACE_DIR, URLFactory.newFileURL(file4));
        preferences2.setPreferencesMap(map2);
        return super.adjustObject(file, file2, ideSystem2);
    }

    private IdeSystem getSettings(File file) throws Exception {
        File file2 = this.getDestFile(null, file);
        URL uRL = URLFactory.newFileURL(file2);
        return (IdeSystem)this.getObjectStore().toObject(uRL);
    }

    public String[] migrate(File file, File file2) {
        this.getLogger().logInformation(ModelArb.getString(52));
        return super.migrate(file, file2);
    }
}

