/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.ModelArb;

public class ImageNode
extends Node {
    public static final String GIF_EXT = ".gif";
    public static final String JPG_EXT = ".jpg";
    public static final String JPEG_EXT = ".jpeg";
    public static final String PNG_EXT = ".png";
    private Image image;

    public ImageNode() {
        this.getAttributes().clear();
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.CLOSEABLE | ElementAttributes.BUILDABLE | ElementAttributes.DEPLOYABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.EDITOR_SAVEABLE_AS);
    }

    public ImageNode(URL uRL) {
        this();
        this.setURL(uRL);
    }

    public Icon getIcon() {
        return IdeIcons.getIcon(3);
    }

    protected void openImpl() throws IOException {
        URL uRL = this.getURL();
        if (uRL != null) {
            this.image = Toolkit.getDefaultToolkit().createImage(uRL);
        }
        super.openImpl();
    }

    protected void closeImpl() throws IOException {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        super.closeImpl();
    }

    public Image getImage() {
        this.ensureOpen();
        return this.image;
    }

    public static URLFilter getImageURLFilter() {
        String string = ModelArb.getString(40);
        String[] stringArray = new String[]{GIF_EXT, JPG_EXT, JPEG_EXT, PNG_EXT};
        return new DefaultURLFilter(string, stringArray);
    }

    public static void init() {
        Class<ImageNode> clazz = ImageNode.class;
        Recognizer.mapExtensionToClass(GIF_EXT, clazz);
        Recognizer.mapExtensionToClass(JPG_EXT, clazz);
        Recognizer.mapExtensionToClass(JPEG_EXT, clazz);
        Recognizer.mapExtensionToClass(PNG_EXT, clazz);
        Recognizer.registerDocumentInfo(clazz, new DocumentInfo(ModelArb.getString(40)));
        Recognizer.mapExtensionToContentType(GIF_EXT, ContentType.BINARY);
        Recognizer.mapExtensionToContentType(JPG_EXT, ContentType.BINARY);
        Recognizer.mapExtensionToContentType(JPEG_EXT, ContentType.BINARY);
        Recognizer.mapExtensionToContentType(PNG_EXT, ContentType.BINARY);
    }
}

