/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.ModelArb;
import oracle.ide.xml.XMLUtil;

public class MiscellaneousFolder
extends DataContainer {
    public static final String BASENAME = "MiscellaneousFiles";
    public static final String EXT = ".misc";
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI("misc-folder");
    public static final String ROOT_TAG = "Miscellaneous-folder";

    static {
        Object2Dom.registerNamespaceElem(MiscellaneousFolder.class, NAMESPACE_URI, ROOT_TAG);
    }

    public MiscellaneousFolder() {
        this.getAttributes().clear();
        this.getAttributes().set(ElementAttributes.CLOSEABLE | ElementAttributes.OPEN_AS_TEXT | ElementAttributes.DELETEABLE);
    }

    public void checkAddToSystem() {
        if (!Ide.getSystem().containsChild(Ide.getMiscellaneousFolder())) {
            Ide.getSystem().add(Ide.getMiscellaneousFolder());
            UpdateMessage.fireChildAdded(Ide.getSystem(), Ide.getMiscellaneousFolder());
        }
    }

    public void checkRemoveFromSystem() {
        if (this.size() == 0) {
            Ide.getSystem().remove(Ide.getMiscellaneousFolder());
            UpdateMessage.fireChildRemoved(Ide.getSystem(), Ide.getMiscellaneousFolder());
        }
    }

    public String getShortLabel() {
        return ModelArb.getString(21);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return IdeIcons.getIcon(12);
    }

    public boolean remove(Element element) {
        boolean bl = super.remove(element);
        if (bl) {
            this.checkRemoveFromSystem();
        }
        return bl;
    }

    public boolean canAdd(Element element) {
        return element instanceof Folder ^ true;
    }

    protected void closeImpl() throws IOException {
        this.save();
        super.closeImpl();
    }
}

