/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.util.CopyOnWriteList;

public class Node
implements LazyLoadable,
Dirtyable,
Subject,
Element,
Locatable {
    private final Attributes _attributes;
    private URL _url;
    private Subject _subjectDelegate;
    private volatile transient boolean _isOpen;
    private transient long _timestamp;
    private transient String _shortLabel;
    private transient String _longLabel;
    private transient boolean _dirty;
    private static final HashMap _listenersForType = new HashMap();
    private static final HashMap _listenersForTypeHierarchy = new HashMap();
    private CopyOnWriteList _listeners;
    private ReadWriteLock _rwLock;
    private boolean _isOpening;
    private boolean _isClosing;

    void $init$() {
        this._attributes = new ElementAttributes(ElementAttributes.DELETEABLE);
        this._rwLock = new ReadWriteLock();
    }

    static {
        Node.addDeleteRenameInterceptor("file");
        Node.addDeleteRenameInterceptor("http");
        Node.addDeleteRenameInterceptor("https");
        Node.addNodeListenerForTypeHierarchy(Node.class, new 1());
    }

    public Node() {
        this.$init$();
    }

    public Node(URL uRL) {
        this.$init$();
        this.setURL(uRL);
    }

    public static final void addNodeListenerForType(Class clazz, NodeListener nodeListener) {
        Node.mapTypeToListener(_listenersForType, nodeListener, clazz);
    }

    public static final void removeNodeListenerForType(Class clazz, NodeListener nodeListener) {
        Node.unmapListenerFromType(_listenersForType, nodeListener, clazz);
    }

    public static final void addNodeListenerForTypeHierarchy(Class clazz, NodeListener nodeListener) {
        Node.mapTypeToListener(_listenersForTypeHierarchy, nodeListener, clazz);
    }

    public static final void removeNodeListenerForTypeHierarchy(Class clazz, NodeListener nodeListener) {
        Node.unmapListenerFromType(_listenersForTypeHierarchy, nodeListener, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapTypeToListener(HashMap hashMap, NodeListener nodeListener, Class clazz) {
        if (nodeListener != null && clazz != null && Node.class.isAssignableFrom(clazz)) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                CopyOnWriteList copyOnWriteList;
                Object v = hashMap.get(clazz);
                if (v == null) {
                    copyOnWriteList = new CopyOnWriteList();
                    hashMap.put(clazz, copyOnWriteList);
                } else {
                    copyOnWriteList = (CopyOnWriteList)v;
                }
                copyOnWriteList.addIfAbsent((Object)nodeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unmapListenerFromType(HashMap hashMap, NodeListener nodeListener, Class clazz) {
        if (nodeListener != null && clazz != null) {
            HashMap hashMap2 = hashMap;
            synchronized (hashMap2) {
                CopyOnWriteList copyOnWriteList = (CopyOnWriteList)hashMap.get(clazz);
                if (copyOnWriteList != null && copyOnWriteList.remove((Object)nodeListener) && copyOnWriteList.isEmpty()) {
                    hashMap.remove(clazz);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addNodeListener(NodeListener nodeListener) {
        Node node = this;
        synchronized (node) {
            if (this._listeners == null) {
                this._listeners = new CopyOnWriteList();
            }
            this._listeners.addIfAbsent((Object)nodeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeNodeListener(NodeListener nodeListener) {
        Node node = this;
        synchronized (node) {
            if (this._listeners != null && this._listeners.remove((Object)nodeListener) && this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL uRL) {
        if (this.isTrackedInNodeCache()) {
            URL uRL2 = this._url;
            this._url = uRL;
            NodeFactory.recache(uRL2, uRL, this);
        } else {
            this._url = uRL;
        }
        this._shortLabel = null;
        this._longLabel = null;
    }

    protected boolean isTrackedInNodeCache() {
        return true;
    }

    public boolean isDirty() {
        this._rwLock.readLock();
        try {
            boolean bl = this._dirty;
            this._rwLock.readUnlock();
            return bl;
        }
        catch (Throwable throwable) {
            this._rwLock.readUnlock();
            throw throwable;
        }
    }

    public void markDirty(boolean bl) {
        this._rwLock.writeLock();
        try {
            Attributes attributes = this.getAttributes();
            if (bl != attributes.isSet(ElementAttributes.DIRTY)) {
                this._dirty = bl;
                Attributes attributes2 = attributes.duplicate();
                if (bl) {
                    attributes.set(ElementAttributes.DIRTY);
                } else {
                    attributes.unset(ElementAttributes.DIRTY);
                }
                this.fireNodeDirtyStateChanged(bl, attributes2);
            }
        }
        finally {
            this._rwLock.writeUnlock();
        }
    }

    public String getShortLabel() {
        if (this._shortLabel == null) {
            URL uRL = this.getURL();
            this._shortLabel = uRL == null ? "<null>" : URLFileSystem.getFileName(uRL);
        }
        return this._shortLabel;
    }

    public String getLongLabel() {
        if (this._longLabel == null) {
            URL uRL = this.getURL();
            this._longLabel = uRL == null ? "<null>" : URLFileSystem.getPlatformPathName(uRL);
        }
        return this._longLabel;
    }

    public Icon getIcon() {
        return ModelArb.getIcon(15);
    }

    public String getToolTipText() {
        URL uRL = this.getURL();
        return URLFileSystem.toDisplayString(uRL);
    }

    public final void attach(Observer observer) {
        this.getSubject().attach(observer);
    }

    public final void detach(Observer observer) {
        this.getSubject().detach(observer);
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.getSubject().notifyObservers(object, updateMessage);
    }

    protected final Subject getSubject() {
        if (this._subjectDelegate == null) {
            this._subjectDelegate = this.createSubject();
        }
        return this._subjectDelegate;
    }

    protected Subject createSubject() {
        return new IdeSubject();
    }

    public Object getData() {
        return this;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public final void open() throws IOException {
        block7: {
            this._rwLock.writeLock();
            try {
                if (this.isOpen()) break block7;
                if (this._isClosing) {
                    new IOException("Node is being opened while it's in the process of closing: " + this.getLongLabel()).printStackTrace();
                }
                if (this._isOpening) break block7;
                try {
                    this.fireNodeWillOpen();
                    this._isOpening = true;
                    this.openImpl();
                    this.setOpen(true);
                }
                finally {
                    this._isOpening = false;
                }
                this.refreshTimestamp();
                this.fireNodeOpened();
            }
            finally {
                this._rwLock.writeUnlock();
            }
        }
    }

    public final void close() throws IOException {
        block8: {
            this._rwLock.writeLock();
            try {
                if (!this.isOpen() || this._isClosing) break block8;
                try {
                    this.fireNodeWillClose();
                    this._isClosing = true;
                    this.closeImpl();
                    this.markDirty(false);
                    this.setOpen(false);
                    this.fireNodeClosed();
                    try {
                        this.postCloseImpl();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                finally {
                    this._isClosing = false;
                }
            }
            finally {
                this._rwLock.writeUnlock();
            }
        }
    }

    public final void save() throws IOException {
        this._rwLock.writeLock();
        try {
            if (this.isOpen() && (this.isDirty() || this.isNew())) {
                this.saveImpl();
                this.markDirty(false);
                this.refreshTimestamp();
                this.fireNodeSaved();
            }
        }
        finally {
            this._rwLock.writeUnlock();
        }
    }

    public final void revert() throws IOException {
        this._rwLock.writeLock();
        try {
            if (this.isOpen()) {
                this.revertImpl();
                this.markDirty(false);
                this.setOpen(true);
                this.fireNodeReverted();
            }
        }
        finally {
            this._rwLock.writeUnlock();
        }
    }

    public final void delete() throws IOException {
        URLFileSystem.delete(this.getURL());
    }

    public final Node rename(URL uRL) throws IOException {
        URLFileSystem.renameEx(this.getURL(), uRL);
        return NodeFactory.find(uRL);
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public boolean isReadOnly() {
        URL uRL = this.getURL();
        return URLFileSystem.isReadOnly(uRL);
    }

    public long getTimestamp() {
        if (this._timestamp <= 0L) {
            this.refreshTimestamp();
        }
        return this._timestamp;
    }

    public InputStream getInputStream() throws IOException {
        try {
            URL uRL = this.getURL();
            InputStream inputStream = URLFileSystem.openInputStream(uRL);
            return inputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            return byteArrayInputStream;
        }
    }

    public final boolean isNew() {
        URL uRL = this.getURL();
        return URLFileSystem.exists(uRL) ^ true;
    }

    public String toString() {
        return this.getShortLabel();
    }

    protected final void runWhileSynchronized(Runnable runnable) {
        this._rwLock.writeLock();
        try {
            runnable.run();
        }
        finally {
            this._rwLock.writeUnlock();
        }
    }

    protected final ReadWriteLock _getReadWriteLockInternal() {
        return this._rwLock;
    }

    protected void openImpl() throws IOException {
    }

    protected void closeImpl() throws IOException {
    }

    protected void postCloseImpl() {
    }

    protected void saveImpl() throws IOException {
    }

    protected void revertImpl() throws IOException {
        this.closeImpl();
        this.openImpl();
    }

    protected void deleteImpl() throws IOException {
    }

    protected void renameImpl(URL uRL, URL uRL2) throws IOException {
    }

    protected final boolean equalsImpl(Node node) {
        return ModelUtil.areEqual((Object)this._url, (Object)node._url);
    }

    protected final void setOpen(boolean bl) {
        this._isOpen = bl;
    }

    protected final long refreshTimestamp() {
        URL uRL = this.getURL();
        this._timestamp = URLFileSystem.lastModified(uRL);
        return this._timestamp;
    }

    protected final void setTimestampDirectly(long l) {
        this._timestamp = l;
    }

    public final boolean ensureOpen() {
        try {
            this.open();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.reportOpenException(exception);
            boolean bl = false;
            return bl;
        }
    }

    protected void reportOpenException(Exception exception) {
        exception.printStackTrace();
    }

    final void copyToImpl(Node node) {
        node._url = this._url;
        node._isOpen = this._isOpen;
    }

    private void deleteInternal(URLFileSystemHelper uRLFileSystemHelper) throws IOException {
        this._rwLock.writeLock();
        try {
            this.close();
            this.deleteImpl();
            URL uRL = this.getURL();
            uRLFileSystemHelper.delete(uRL);
            this.fireNodeDeleted();
            NodeFactory.uncache(uRL);
        }
        finally {
            this._rwLock.writeUnlock();
        }
    }

    private void renameInternal(URL uRL, URLFileSystemHelper uRLFileSystemHelper) throws IOException {
        this._rwLock.writeLock();
        try {
            URL uRL2 = this.getURL();
            this.renameImpl(uRL2, uRL);
            uRLFileSystemHelper.rename(uRL2, uRL);
            Node node = NodeFactory.find(uRL);
            if (node != null) {
                NodeFactory.uncache(uRL);
            }
            Class<?> clazz = this.getClass();
            Class clazz2 = Recognizer.recognizeURL(uRL);
            Node node2 = null;
            if (clazz == clazz2) {
                this.setURL(uRL);
            } else {
                try {
                    node2 = NodeFactory.findOrCreate(uRL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.fireNodeRenamed(uRL2, uRL);
            if (clazz != clazz2) {
                NodeFactory.uncache(uRL2);
            }
        }
        finally {
            this._rwLock.writeUnlock();
        }
    }

    private void fireNodeWillOpen() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeWillOpen(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeOpened() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeOpened(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeDirtyStateChanged(boolean bl, Attributes attributes) {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeDirtyStateChanged(nodeEvent, bl);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        UpdateMessage.fireAttributeChanged(this, attributes);
    }

    private void fireNodeWillClose() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeWillClose(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeClosed() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeClosed(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeSaved() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeSaved(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeReverted() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeReverted(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeDeleted() {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeDeleted(nodeEvent);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void fireNodeRenamed(URL uRL, URL uRL2) {
        NodeListenerIterator nodeListenerIterator = new NodeListenerIterator(null);
        if (nodeListenerIterator.hasNext()) {
            NodeEvent nodeEvent = new NodeEvent(this);
            while (nodeListenerIterator.hasNext()) {
                NodeListener nodeListener = nodeListenerIterator.next();
                try {
                    nodeListener.nodeRenamed(nodeEvent, uRL, uRL2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static void addDeleteRenameInterceptor(String string) {
        URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper(string);
        DeleteRenameInterceptor deleteRenameInterceptor = new DeleteRenameInterceptor(uRLFileSystemHelper, null);
        URLFileSystem.registerHelper(string, deleteRenameInterceptor);
    }

    static CopyOnWriteList ra$_listeners(Node node) {
        return node._listeners;
    }

    static HashMap ra$_listenersForType() {
        return _listenersForType;
    }

    static HashMap ra$_listenersForTypeHierarchy() {
        return _listenersForTypeHierarchy;
    }

    static void mav$renameInternal(Node node, URL uRL, URLFileSystemHelper uRLFileSystemHelper) {
        node.renameInternal(uRL, uRLFileSystemHelper);
    }

    static void mav$deleteInternal(Node node, URLFileSystemHelper uRLFileSystemHelper) {
        node.deleteInternal(uRLFileSystemHelper);
    }

    private class NodeListenerIterator {
        private NodeListener _curListener;
        private Object[] _curListeners;
        private int _i;
        private int _n;
        private boolean _instanceListRead;
        private boolean _typeListRead;
        private boolean _typeHierarchyListRead;
        private Class _curType;

        boolean hasNext() {
            this.tryNext();
            return this._curListener != null;
        }

        NodeListener next() {
            this.tryNext();
            NodeListener nodeListener = this._curListener;
            this._curListener = null;
            return nodeListener;
        }

        private void tryNext() {
            if (this._curListener == null) {
                this._curListener = this.nextImpl();
            }
        }

        private void resetCurListeners(CopyOnWriteList copyOnWriteList) {
            if (copyOnWriteList != null) {
                this._curListeners = copyOnWriteList.getItems();
            }
            this._i = 0;
            this._n = this._curListeners != null ? this._curListeners.length : 0;
        }

        private NodeListener nextListenerImpl() {
            if (this._curListeners != null) {
                if (this._i < this._n) {
                    this._curListener = (NodeListener)this._curListeners[this._i++];
                    return this._curListener;
                }
                this._curListeners = null;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeListener nextImpl() {
            NodeListener nodeListener;
            NodeListener nodeListener2;
            if (!this._instanceListRead) {
                this._instanceListRead = true;
                if (this._curListeners == null) {
                    Node node = Node.this;
                    synchronized (node) {
                        this.resetCurListeners(Node.ra$_listeners(Node.this));
                    }
                }
            }
            if ((nodeListener2 = this.nextListenerImpl()) != null) {
                return nodeListener2;
            }
            if (!this._typeListRead) {
                this._typeListRead = true;
                if (this._curListeners == null) {
                    Class<?> clazz = Node.this.getClass();
                    HashMap hashMap = Node.ra$_listenersForType();
                    synchronized (hashMap) {
                        Object v = Node.ra$_listenersForType().get(clazz);
                        if (v != null) {
                            CopyOnWriteList copyOnWriteList = (CopyOnWriteList)v;
                            this.resetCurListeners(copyOnWriteList);
                        }
                    }
                }
            }
            if ((nodeListener = this.nextListenerImpl()) != null) {
                return nodeListener;
            }
            if (!this._typeHierarchyListRead) {
                this._typeHierarchyListRead = true;
                this._curType = Node.this.getClass();
            }
            while (this._curType != null) {
                NodeListener nodeListener3;
                if (this._curListeners == null) {
                    HashMap hashMap = Node.ra$_listenersForTypeHierarchy();
                    synchronized (hashMap) {
                        Object v = Node.ra$_listenersForTypeHierarchy().get(this._curType);
                        if (v != null) {
                            CopyOnWriteList copyOnWriteList = (CopyOnWriteList)v;
                            this.resetCurListeners(copyOnWriteList);
                        }
                    }
                    Class clazz = this._curType = this._curType == Node.class ? null : this._curType.getSuperclass();
                }
                if ((nodeListener3 = this.nextListenerImpl()) == null) continue;
                return nodeListener3;
            }
            return null;
        }

        private NodeListenerIterator() {
        }

        NodeListenerIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class DeleteRenameInterceptor
    extends URLFileSystemHelperDecorator {
        private DeleteRenameInterceptor(URLFileSystemHelper uRLFileSystemHelper) {
            super(uRLFileSystemHelper);
        }

        public void delete(URL uRL) throws IOException {
            Node node = this.tryGetNode(uRL);
            if (node != null) {
                Node.mav$deleteInternal(node, this._helper);
            } else {
                super.delete(uRL);
            }
        }

        public void rename(URL uRL, URL uRL2) throws IOException {
            Node node = this.tryGetNode(uRL);
            if (node != null) {
                Node.mav$renameInternal(node, uRL2, this._helper);
            } else {
                super.rename(uRL, uRL2);
            }
        }

        private Node tryGetNode(URL uRL) {
            try {
                Node node = NodeFactory.findOrCreate(uRL);
                return node;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Node node = null;
                return node;
            }
        }

        DeleteRenameInterceptor(URLFileSystemHelper uRLFileSystemHelper, 1 var2_2) {
            this(uRLFileSystemHelper);
        }

        public final class 1 {
        }
    }

    public static final class oracle.ide.model.Node$1
    extends NodeListener {
        public void nodeOpened(NodeEvent nodeEvent) {
            this.invokeLaterIfNeeded(new 4(this, nodeEvent));
        }

        public void nodeWillClose(NodeEvent nodeEvent) {
            this.invokeLaterIfNeeded(new 3(this, nodeEvent));
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.invokeLaterIfNeeded(new 2(this, nodeEvent));
        }

        public void nodeReverted(NodeEvent nodeEvent) {
            this.invokeLaterIfNeeded(new 1(this, nodeEvent));
        }

        private void invokeLaterIfNeeded(Runnable runnable) {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeLater(runnable);
            }
        }

        public final class 4
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ oracle.ide.model.Node$1 this$0;

            public void run() {
                Node node = this.v$e.getNode();
                String string = node.getClass().getName() + ".fireObjectOpened";
                UpdateMessage.fireObjectOpened(node);
            }

            public 4(oracle.ide.model.Node$1 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }

        public final class 3
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ oracle.ide.model.Node$1 this$0;

            public void run() {
                UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.OBJECT_CLOSING, null);
                Node node = this.v$e.getNode();
                node.notifyObservers(node, updateMessage);
            }

            public 3(oracle.ide.model.Node$1 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }

        public final class 2
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ oracle.ide.model.Node$1 this$0;

            public void run() {
                UpdateMessage.fireObjectClosed(this.v$e.getNode());
            }

            public 2(oracle.ide.model.Node$1 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ NodeEvent v$e;
            final /* synthetic */ oracle.ide.model.Node$1 this$0;

            public void run() {
                UpdateMessage.fireObjectReloaded(this.v$e.getNode());
            }

            public 1(oracle.ide.model.Node$1 var1_1, NodeEvent nodeEvent) {
                this.v$e = nodeEvent;
                this.this$0 = var1_1;
            }
        }
    }
}

