/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.FactoryMonitor;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Node2Dom;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLExistsTest;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.WeakCache;

public final class NodeFactory {
    public static final int NODE_CACHED = UpdateMessage.newMessageID("NodeFactory.NODE_CACHED");
    public static final int NODE_UNCACHED = UpdateMessage.newMessageID("NodeFactory.NODE_UNCACHED");
    private static WeakCache _cache = new WeakCache();
    private static final NodeTracker _nodeTracker = new NodeTracker(null);

    static {
        Node.addNodeListenerForTypeHierarchy(Node.class, _nodeTracker);
        Object2Dom.registerConverter(new Node2Dom());
        URLFileSystem.addExistsTest(new 1());
    }

    public static Node findOrCreate(URL uRL) throws IllegalAccessException, InstantiationException {
        return NodeFactory.findOrCreateUsingDefault(uRL, Recognizer.getDefaultNodeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node findOrCreate(Class clazz, URL uRL) throws IllegalAccessException, InstantiationException {
        Node node;
        WeakCache weakCache = _cache;
        synchronized (weakCache) {
            node = (Node)_cache.get((Object)uRL);
        }
        return node != null ? node : NodeFactory.createImpl(clazz, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node findOrCreateUsingDefault(URL uRL, Class clazz) throws IllegalAccessException, InstantiationException {
        if (uRL != null) {
            Node node;
            WeakCache weakCache = _cache;
            synchronized (weakCache) {
                node = (Node)_cache.get((Object)uRL);
            }
            if (node != null) {
                return node;
            }
            Iterator iterator = Recognizer.getRecognizerIterator(uRL);
            while (iterator.hasNext()) {
                Node node2;
                Recognizer recognizer = (Recognizer)iterator.next();
                Class clazz2 = recognizer.recognize(uRL);
                if (clazz2 == null || (node2 = recognizer.create(uRL, clazz2)) == null) continue;
                return node2;
            }
            if (clazz != null) {
                return NodeFactory.createImpl(clazz, uRL);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node find(URL uRL) {
        if (uRL != null) {
            WeakCache weakCache = _cache;
            synchronized (weakCache) {
                Node node = (Node)_cache.get((Object)uRL);
                return node;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Node findInFolder(Folder var0, URL var1_1) {
        if (var0 == null || var1_1 == null) {
            return null;
        }
        var2_2 = var0.getChildren();
        if (var2_2 != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.next();
            if (!(var3_3 instanceof Node) || !var1_1.equals((var4_4 = (Node)var3_3).getURL())) continue;
            return var4_4;
lbl9:
            // 2 sources

            ** while (var2_2.hasNext())
        }
lbl10:
        // 1 sources

        return null;
    }

    public static Node clone(Node node, URL uRL) {
        URL uRL2 = node.getURL();
        Class<?> clazz = node.getClass();
        try {
            Node node2 = (Node)clazz.newInstance();
            node2.setURL(uRL);
            URLFileSystem.copy(uRL2, uRL);
            Node node3 = node2;
            return node3;
        }
        catch (Exception exception) {
            Node node4 = null;
            return node4;
        }
    }

    public static Node uncache(URL uRL) {
        return NodeFactory.uncache(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node uncache(URL uRL, boolean bl) {
        Node node = NodeFactory.find(uRL);
        if (node != null) {
            WeakCache weakCache = _cache;
            synchronized (weakCache) {
                _cache.remove((Object)uRL);
            }
            if (bl) {
                FactoryMonitor.notify(node, NODE_UNCACHED);
            }
        }
        return node;
    }

    public static void recache(URL uRL, URL uRL2, Node node) {
        NodeFactory.recache(uRL, uRL2, node, true);
    }

    public static void recache(URL uRL, URL uRL2, Node node, boolean bl) {
        if (uRL != null) {
            Node node2 = NodeFactory.find(uRL);
            bl = bl && node2 != node;
            NodeFactory.uncache(uRL, bl);
        }
        if (uRL2 != null && node != null) {
            NodeFactory.cache(uRL2, node, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getCachedNodes() {
        WeakCache weakCache = _cache;
        synchronized (weakCache) {
            Iterator iterator = _cache.iterator();
            return iterator;
        }
    }

    public static Iterator getOpenNodes() {
        return _nodeTracker.getOpenNodes();
    }

    public static final void attach(Observer observer, Class clazz) {
        FactoryMonitor.attach(observer, clazz);
    }

    public static final void detach(Observer observer, Class clazz) {
        FactoryMonitor.detach(observer, clazz);
    }

    private NodeFactory() {
    }

    private static Node createImpl(Class clazz, URL uRL) throws IllegalAccessException, InstantiationException {
        Node node = (Node)clazz.newInstance();
        node.setURL(uRL);
        NodeFactory.cache(uRL, node, true);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cache(URL uRL, Node node, boolean bl) {
        Node node2 = NodeFactory.find(uRL);
        if (node2 == null || node2 != node) {
            WeakCache weakCache = _cache;
            synchronized (weakCache) {
                _cache.put((Object)uRL, (Object)node);
            }
            if (bl) {
                FactoryMonitor.notify(node, NODE_CACHED);
            }
        }
    }

    public static final class 1
    implements URLExistsTest {
        public boolean urlExists(URL uRL) {
            return NodeFactory.find(uRL) != null;
        }
    }

    private static class NodeTracker
    extends NodeListener {
        private final WeakCache _openNodes;
        private final ArrayList _dirtyNodes;

        void $init$() {
            this._openNodes = new WeakCache();
            this._dirtyNodes = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator getOpenNodes() {
            WeakCache weakCache = this._openNodes;
            synchronized (weakCache) {
                Iterator iterator = this._openNodes.iterator();
                return iterator;
            }
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            URL uRL = node.getURL();
            if (uRL != null) {
                this._openNodes.put((Object)uRL, (Object)node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeDirtyStateChanged(NodeEvent nodeEvent, boolean bl) {
            if (bl) {
                Node node = nodeEvent.getNode();
                ArrayList arrayList = this._dirtyNodes;
                synchronized (arrayList) {
                    Iterator iterator = this._dirtyNodes.iterator();
                    while (iterator.hasNext()) {
                        if (node != iterator.next()) continue;
                        return;
                    }
                    this._dirtyNodes.add(node);
                }
            }
            Node node = nodeEvent.getNode();
            ArrayList arrayList = this._dirtyNodes;
            synchronized (arrayList) {
                Iterator iterator = this._dirtyNodes.iterator();
                while (iterator.hasNext()) {
                    if (node != iterator.next()) continue;
                    iterator.remove();
                    return;
                }
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            URL uRL = node.getURL();
            Object object = this._openNodes.get((Object)uRL);
            if (object == node) {
                this._openNodes.remove((Object)uRL);
            }
        }

        private NodeTracker() {
            this.$init$();
        }

        NodeTracker(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

