/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.WeakDataHolder;
import oracle.javatools.util.SwingClosure;

public final class NodeUtil {
    public static final int RELOAD_PROMPTED = 1;
    public static final int RELOAD_PROMPTED_IF_DIRTY = 2;
    public static final int RELOAD_SILENTLY = 3;

    public static void storeAllTimestamps(Map map) {
        NodeUtil.storeTimestampsImpl(map, NodeFactory.getCachedNodes(), new OpenNodeFilter(null));
    }

    public static void storeAllTimestamps(Map map, NodeFilter nodeFilter) {
        NodeUtil.storeTimestampsImpl(map, NodeFactory.getCachedNodes(), nodeFilter);
    }

    public static void storeTimestamps(Map map, Collection collection) {
        NodeUtil.storeTimestampsImpl(map, collection.iterator(), new OpenNodeFilter(null));
    }

    public static void storeTimestamps(Map map, Collection collection, NodeFilter nodeFilter) {
        NodeUtil.storeTimestampsImpl(map, collection.iterator(), nodeFilter);
    }

    private static void storeTimestampsImpl(Map map, Iterator iterator, NodeFilter nodeFilter) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (nodeFilter.accept(node)) {
                long l = URLFileSystem.lastModified(node.getURL());
                map.put(node, new Long(l));
                continue;
            }
            map.remove(node);
        }
    }

    public static void reloadBuffers(Map map) {
        NodeUtil.reloadBuffers(map, true);
    }

    public static void reloadBuffers(Map map, boolean bl) {
        NodeUtil.reloadBuffers(map, bl, false);
    }

    public static void reloadBuffers(Map map, boolean bl, boolean bl2) {
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            NodeUtil.reloadBuffers(iterator, map, bl, bl2);
        }
    }

    public static void reloadBuffers(Collection collection, boolean bl) {
        if (collection != null) {
            NodeUtil.reloadBuffers(collection.iterator(), null, bl, false);
        }
    }

    public static void reloadBuffers(Collection collection, Map map, int n, boolean bl) {
        NodeUtil.reloadBuffers(collection.iterator(), map, n, bl);
    }

    private static void reloadBuffers(Iterator iterator, Map map, boolean bl, boolean bl2) {
        int n = bl ? 2 : 1;
        NodeUtil.reloadBuffers(iterator, map, n, bl2);
    }

    private static void reloadBuffers(Iterator iterator, Map map, int n, boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null || !node.isOpen()) continue;
            node.isReadOnly();
            if (node.getAttributes().isSet(ElementAttributes.NON_RELOADABLE)) continue;
            boolean bl2 = false;
            if (map != null) {
                long l;
                long l2 = URLFileSystem.lastModified(node.getURL());
                if (l2 != (l = ((Long)map.get(node)).longValue())) {
                    long l3 = node.getTimestamp();
                    bl2 = l2 >= 0L && (l2 > l3 || l2 < l3 && l2 < l);
                }
            } else {
                bl2 = true;
            }
            if (!bl2) continue;
            if (n == 3 || n == 2 && !node.isDirty()) {
                arrayList.add(node);
                continue;
            }
            arrayList2.add(node);
        }
        NodeUtil.performReload(arrayList, arrayList2, bl);
    }

    private static void performReload(ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        try {
            1 var3_3 = new 1(true, bl, arrayList2, arrayList);
            var3_3.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void autoReload(ArrayList arrayList) {
        for (Node node : arrayList) {
            NodeUtil.tryRevert(node);
        }
    }

    private static void promptedReload(ArrayList arrayList) {
        int n;
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        for (Node node : arrayList) {
            Icon icon = node.getIcon();
            String string = URLFileSystem.getPlatformPathName(node.getURL());
            checkBoxListModel.addElement(node, icon, true, true, string);
        }
        int n2 = checkBoxListModel.getSize();
        if (n2 > 0 && (n = SelectFilesPanel.showDialog(IdeArb.getString(254), IdeArb.format(219, checkBoxListModel.findTextForElement(0)), IdeArb.getString(222), checkBoxListModel, true, 0, "f1_idedexternallymodifiedfiles_html")) == 0) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                if (checkBoxListModel.isElementSelected(n3)) {
                    Node node = (Node)checkBoxListModel.getUserObjectAt(n3);
                    NodeUtil.tryRevert(node);
                }
                --n3;
            }
        }
    }

    private static void tryRevert(Node node) {
        try {
            RevertNodeCommand.reload(node);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private NodeUtil() {
    }

    static void maS$autoReload(ArrayList arrayList) {
        NodeUtil.autoReload(arrayList);
    }

    static void maS$promptedReload(ArrayList arrayList) {
        NodeUtil.promptedReload(arrayList);
    }

    public static final class 1
    extends SwingClosure {
        private final /* synthetic */ boolean v$manualReload;
        private final /* synthetic */ ArrayList v$promptedReloadNodes;
        private final /* synthetic */ ArrayList v$autoReloadNodes;

        protected void runImpl() throws Exception {
            if (this.v$manualReload && this.v$promptedReloadNodes.size() == 0) {
                String string = IdeArb.getString(254);
                String string2 = IdeArb.getString(255);
                IdeMainWindow ideMainWindow = Ide.getMainWindow();
                JOptionPane.showMessageDialog((Component)((Object)ideMainWindow), string2, string, 1);
            } else {
                NodeUtil.maS$autoReload(this.v$autoReloadNodes);
                NodeUtil.maS$promptedReload(this.v$promptedReloadNodes);
            }
        }

        public 1(boolean bl, boolean bl2, ArrayList arrayList, ArrayList arrayList2) {
            this.v$autoReloadNodes = arrayList2;
            this.v$promptedReloadNodes = arrayList;
            this.v$manualReload = bl2;
            super(bl);
        }
    }

    public static interface NodeFilter {
        public boolean accept(Node var1);
    }

    private static class OpenNodeFilter
    implements NodeFilter {
        public boolean accept(Node node) {
            return node != null && node.isOpen() && (!(node instanceof WeakDataHolder) || !((WeakDataHolder)((Object)node)).isExpired());
        }

        private OpenNodeFilter() {
        }

        OpenNodeFilter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

