/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.DataList;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Reference;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.Copyable;

public class ObservableFolder
extends DefaultFolder
implements Subject,
Dirtyable,
Copyable {
    private transient boolean _dirty;
    private final Subject _subject;

    void $init$() {
        this._dirty = false;
        this._subject = new IdeSubject();
    }

    public ObservableFolder() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        ObservableFolder observableFolder = object != null ? (ObservableFolder)object : new ObservableFolder();
        this.copyToImpl(observableFolder);
        return observableFolder;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markDirty(boolean bl) {
        this._dirty = bl;
    }

    public synchronized void attach(Observer observer) {
        this._subject.attach(observer);
    }

    public synchronized void detach(Observer observer) {
        this._subject.detach(observer);
    }

    public synchronized void notifyObservers(Object object, UpdateMessage updateMessage) {
        this._subject.notifyObservers(object, updateMessage);
    }

    public boolean add(Element element) {
        boolean bl = super.add(element);
        if (bl) {
            ObservableFolder.setOwner(element, this);
            this.markDirty(true);
        }
        return bl;
    }

    public boolean remove(Element element) {
        boolean bl = super.remove(element);
        if (bl) {
            ObservableFolder.setOwner(element, null);
            this.markDirty(true);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (Element element : this._children) {
                ObservableFolder.setOwner(element, null);
            }
        }
        super.removeAll();
        this.markDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListOfChildren() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            DataList dataList = new DataList(this._children);
            return dataList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListOfChildren(List list) {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
        }
        if (list != null) {
            for (Object e : list) {
                if (e instanceof Reference) {
                    Reference reference = (Reference)e;
                    this.add(reference.getData());
                    continue;
                }
                if (!(e instanceof Element)) continue;
                this.add((Element)e);
            }
        }
    }

    private static void setOwner(Element element, Dirtyable dirtyable) {
        if (element instanceof SubDirtyable) {
            ((SubDirtyable)((Object)element)).setOwner(dirtyable);
        }
    }
}

