/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class OwnerMap
extends HashStructureAdapter {
    static final String NODE_URL = "nodeURL";
    private static final String NODE_CLASS = "nodeClass";
    private static final String OWNER_URL = "ownerURL";
    private static final String OWNER_CLASS = "ownerClass";
    private final Project _project;
    private final HashMap _ownerMap;
    private HashMap _referenceMap;
    private List _ownedChildren;
    static final /* synthetic */ boolean $assertionsDisabled;
    static final String OWNER_MAP = "ownerMap";

    static {
        $assertionsDisabled = OwnerMap.class.desiredAssertionStatus() ^ true;
    }

    void $init$() {
        this._ownerMap = new HashMap();
    }

    private OwnerMap(Project project) {
        super(project._hash);
        this.$init$();
        this._project = project;
    }

    static OwnerMap getInstanceOnOpen(Project project) {
        OwnerMap ownerMap = new OwnerMap(project);
        project.getTransientProperties().put("owner-map", ownerMap);
        return ownerMap;
    }

    public static OwnerMap getInstance(Project project) {
        return (OwnerMap)((Object)project.getTransientProperties().get("owner-map"));
    }

    public static boolean addToOwnerMap(Project project, Node node, Node node2) {
        if (project.ensureOpen()) {
            if (OwnerMap.getInstance(project).add(node, node2)) {
                return true;
            }
            project.setSubDirtyableOwner(node, project);
            project.markDirty(true);
            node.attach(project);
            return true;
        }
        return false;
    }

    public List getOwnedNodes(URL uRL, URLPath uRLPath, String string) {
        boolean bl = "".equals(string);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ListStructure listStructure = this.getOwnerMapListStructure();
        for (HashStructure hashStructure : listStructure) {
            URL uRL2;
            String string2;
            URL uRL3 = hashStructure.getURL(NODE_URL);
            if (uRL3 == null || (string2 = uRLPath.toRelativePath(uRL3)) == null || (!bl || string2.indexOf(47) >= 0) && (string2.length() <= string.length() || !string2.startsWith(string) || string2.indexOf(47, string.length()) >= 0) || !URLFileSystem.equals(uRL2 = hashStructure.getURL(OWNER_URL), uRL)) continue;
            try {
                Node node = NodeFactory.findOrCreate(uRL3);
                arrayList.add(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(Node node, Node node2) {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            List list = this.getOwnedChildrenList();
            if (list.contains(node)) {
                boolean bl = true;
                return bl;
            }
            this.addToOwnerMap(new Reference(node), this.getOwnerReference(node2));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            this._ownerMap.clear();
            this._ownedChildren = null;
            this._referenceMap = null;
        }
    }

    void initOwnerMap() {
        if (!$assertionsDisabled && this._ownerMap.size() != 0) {
            throw new AssertionError();
        }
        ListStructure listStructure = this.getOwnerMapListStructure();
        Iterator iterator = listStructure.iterator();
        while (iterator.hasNext()) {
            try {
                HashStructure hashStructure = (HashStructure)iterator.next();
                Reference reference = OwnerMap.getReference(hashStructure, NODE_URL, NODE_CLASS);
                Reference reference2 = OwnerMap.getReference(hashStructure, OWNER_URL, OWNER_CLASS);
                this.addToOwnerMapDirectly(reference, reference2);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getMap() {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            if (this._ownerMap.size() == 0) {
                Map map = null;
                return map;
            }
            HashMap hashMap2 = new HashMap();
            for (Map.Entry entry : this._ownerMap.entrySet()) {
                Node node = NodeFactory.find((URL)entry.getKey());
                if (node == null) continue;
                hashMap2.put(new Reference(node), entry.getValue());
            }
            HashMap hashMap3 = hashMap2;
            return hashMap3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsOwnedChild(Element element) {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            if (this._ownerMap.size() == 0) {
                boolean bl = false;
                return bl;
            }
            if (element instanceof Node) {
                boolean bl = this._ownerMap.get(((Node)element).getURL()) != null;
                return bl;
            }
        }
        return false;
    }

    HashMap getReferenceMap() {
        if (this._referenceMap == null) {
            this._referenceMap = new HashMap();
            Map map = this.getMap();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    Reference reference = (Reference)entry.getValue();
                    Node node = reference.getData();
                    this._referenceMap.put(node, reference);
                    node.attach(this._project);
                }
            }
        }
        return this._referenceMap;
    }

    private ListStructure getOwnerMapListStructure() {
        return this._hash.getOrCreateListStructure(OWNER_MAP);
    }

    private static Reference getReference(HashStructure hashStructure, String string, String string2) throws ClassNotFoundException {
        URL uRL = hashStructure.getURL(string);
        String string3 = hashStructure.getString(string2);
        return new Reference(uRL, string3);
    }

    private static void putReference(HashStructure hashStructure, String string, String string2, Reference reference) {
        Node node = reference.getData();
        hashStructure.putURL(string, node != null ? node.getURL() : null);
        hashStructure.putString(string2, node != null ? node.getClass().getName() : null);
    }

    private void addToOwnerMap(Reference reference, Reference reference2) {
        this.addToOwnerMapDirectly(reference, reference2);
        URL uRL = reference.getURL();
        ListStructure listStructure = this.getOwnerMapListStructure();
        Iterator iterator = listStructure.iterator();
        HashStructure hashStructure = null;
        while (iterator.hasNext()) {
            HashStructure hashStructure2 = (HashStructure)iterator.next();
            URL uRL2 = hashStructure2.getURL(NODE_URL);
            if (!ModelUtil.areEqual((Object)uRL, (Object)uRL2)) continue;
            hashStructure = hashStructure2;
            break;
        }
        HashStructure hashStructure3 = hashStructure;
        this._hash.applyBatchChanges((Runnable)new 1(this, hashStructure3, listStructure, reference, reference2));
    }

    private void addToOwnerMapDirectly(Reference reference, Reference reference2) {
        Node node = reference.getData();
        this._ownerMap.put(node.getURL(), reference2);
        this.addOwnedChild(node);
    }

    private void removeFromOwnerMap(URL uRL) {
        this._ownerMap.remove(uRL);
        ListStructure listStructure = this.getOwnerMapListStructure();
        Iterator iterator = listStructure.iterator();
        while (iterator.hasNext()) {
            HashStructure hashStructure = (HashStructure)iterator.next();
            URL uRL2 = hashStructure.getURL(NODE_URL);
            if (!ModelUtil.areEqual((Object)uRL, (Object)uRL2)) continue;
            iterator.remove();
        }
    }

    private void addOwnedChild(Node node) {
        if (this._ownedChildren == null) {
            this._ownedChildren = new ArrayList();
        }
        if (!this._ownedChildren.contains(node)) {
            this._ownedChildren.add(node);
            node.attach(this._project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNodeRenamed(URL uRL, Node node, Node node2) {
        if (node2 != null) {
            HashMap hashMap = this._ownerMap;
            synchronized (hashMap) {
                this.removeFromOwnerMap(uRL);
                this.addToOwnerMap(new Reference(node), this.getOwnerReference(node2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyOwnedChildrenListTo(List list) {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            List list2 = this.getOwnedChildrenList();
            if (list2.size() > 0) {
                list.addAll(list2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node getContainerOwner(URL uRL) {
        if (uRL != null) {
            Reference reference;
            HashMap hashMap = this._ownerMap;
            synchronized (hashMap) {
                reference = (Reference)this._ownerMap.get(uRL);
            }
            if (reference != null) {
                return reference.getData();
            }
        }
        return null;
    }

    Node getContainerOwner(Element element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            return this.getContainerOwner(node.getURL());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getOwnedChildrenList() {
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            if (this._ownedChildren != null) {
                List list = this._ownedChildren;
                return list;
            }
            this._ownedChildren = new ArrayList();
            for (URL uRL : this._ownerMap.keySet()) {
                try {
                    this.addOwnedChild(NodeFactory.findOrCreate(uRL));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this._ownedChildren;
    }

    private Reference getOwnerReference(Node node) {
        HashMap hashMap = this.getReferenceMap();
        Reference reference = (Reference)hashMap.get(node);
        if (reference == null) {
            reference = new Reference(node);
            hashMap.put(node, reference);
            node.attach(this._project);
        }
        return reference;
    }

    private Reference findOwnerReference(Node node) {
        HashMap hashMap = this.getReferenceMap();
        return (Reference)hashMap.get(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Element element) {
        boolean bl = false;
        HashMap hashMap = this._ownerMap;
        synchronized (hashMap) {
            List list = this.getOwnedChildrenList();
            if (list.contains(element)) {
                bl = list.remove(element);
            }
        }
        if (bl) {
            this.detachOwnerObserver(element);
            if (element instanceof SubDirtyable) {
                ((SubDirtyable)((Object)element)).setOwner(null);
            }
            Node node = (Node)element;
            this.removeFromOwnerMap(node.getURL());
            node.detach(this._project);
        }
        if (element instanceof Folder) {
            this.removeOwnedChildren((Folder)element);
        }
    }

    private void detachOwnerObserver(Element element) {
        Node node;
        Reference reference;
        if (element instanceof Node && (reference = this.findOwnerReference(node = (Node)element)) != null) {
            node.detach(this._project);
        }
    }

    public void removeOwnedChildren(Folder folder) {
        ArrayList arrayList = new ArrayList();
        this.removeOwnedChildren(folder, arrayList);
        if (arrayList.size() > 0) {
            UpdateMessage.fireChildrenRemoved(this._project, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOwnedChildren(Folder folder, List list) {
        int n = list.size();
        Iterator iterator = folder.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!(element instanceof Folder)) continue;
                if (this.containsOwnedChild(element)) {
                    list.add(element);
                    continue;
                }
                this.removeOwnedChildren((Folder)element, list);
            }
        }
        if (!(folder instanceof Node)) {
            return;
        }
        Node node = (Node)((Object)folder);
        Reference reference = this.findOwnerReference(node);
        if (reference != null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            HashMap hashMap = this._ownerMap;
            synchronized (hashMap) {
                for (Map.Entry entry : this._ownerMap.entrySet()) {
                    if (entry.getValue() != reference) continue;
                    URL uRL = (URL)entry.getKey();
                    Node node2 = NodeFactory.find(uRL);
                    if (node2 != null) {
                        list.add(node2);
                        continue;
                    }
                    arrayList.add(uRL);
                }
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    this.removeFromOwnerMap((URL)arrayList.get(n2));
                    ++n2;
                }
            }
            if (this._referenceMap != null) {
                this._referenceMap.remove(node);
            }
        }
        int n3 = list.size();
        int n4 = n;
        while (n4 < n3) {
            Node node3 = (Node)list.get(n4);
            this.removeElement(node3);
            ++n4;
        }
    }

    static void maS$putReference(HashStructure hashStructure, String string, String string2, Reference reference) {
        OwnerMap.putReference(hashStructure, string, string2, reference);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ HashStructure v$finalHash;
        private final /* synthetic */ ListStructure v$list;
        private final /* synthetic */ Reference v$nodeRef;
        private final /* synthetic */ Reference v$ownerRef;
        final /* synthetic */ OwnerMap this$0;

        public void run() {
            HashStructure hashStructure = this.v$finalHash;
            if (hashStructure == null) {
                hashStructure = HashStructure.newInstance();
                this.v$list.add((Object)hashStructure);
            }
            OwnerMap.maS$putReference(hashStructure, OwnerMap.NODE_URL, OwnerMap.NODE_CLASS, this.v$nodeRef);
            OwnerMap.maS$putReference(hashStructure, OwnerMap.OWNER_URL, OwnerMap.OWNER_CLASS, this.v$ownerRef);
        }

        public 1(OwnerMap ownerMap, HashStructure hashStructure, ListStructure listStructure, Reference reference, Reference reference2) {
            this.v$ownerRef = reference2;
            this.v$nodeRef = reference;
            this.v$list = listStructure;
            this.v$finalHash = hashStructure;
            this.this$0 = ownerMap;
        }
    }
}

