/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.ContentSet;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeVetoableSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.OwnerMap;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Reference;
import oracle.ide.model.Subject;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.UserProperties;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.util.CopyOnWriteList;

public final class Project
extends DataContainer
implements VetoableSubject,
PropertyStorage {
    public static final String EXT = ".jpr";
    public static final String DATA_KEY = "Project";
    public static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/project";
    public static final String ROOT_QNAME = "jpr:project";
    private UserProperties _userProperties;
    private final transient StorageListener _storageListener;
    private static final IdentityHashMap _projectChangeListenersMap = new IdentityHashMap();
    private static final CopyOnWriteList _projectChangeListenersOrder = new CopyOnWriteList();
    private static final boolean ENABLE_USER_PROPERTIES;

    static {
        Node.addNodeListenerForType(Project.class, new NL(null));
        TechnologyScopeConfiguration.init();
        WorkingSets.init();
        ENABLE_USER_PROPERTIES = Boolean.valueOf(System.getProperty("ide.enable.user.properties", "true"));
        try {
            int n = Integer.getInteger("ProjectChangeListener.debug.level", 0);
            if (n > 0) {
                1 var1_1 = new 1(n);
                Project.addProjectChangeListener("", var1_1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void $init$() {
        this._storageListener = new StorageListener(null);
    }

    public Project() {
        this.$init$();
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.CLOSEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.BUILDABLE | ElementAttributes.SELECTION_CONTAINER | ElementAttributes.NON_HISTORIED);
    }

    public final HashStructure getProperties() {
        return this.getPropertiesImpl(true);
    }

    public final HashStructure getPropertiesForOverriding() {
        return this.getPropertiesImpl(false);
    }

    public final HashStructure getUserPropertiesOnly() {
        this.ensureOpen();
        return this._userProperties != null ? this._userProperties.getProperties() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addProjectChangeListener(String string, ProjectChangeListener projectChangeListener) {
        if (string != null && projectChangeListener != null) {
            string = string.intern();
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                CopyOnWriteList copyOnWriteList = (CopyOnWriteList)_projectChangeListenersMap.get(projectChangeListener);
                if (copyOnWriteList == null) {
                    copyOnWriteList = new CopyOnWriteList();
                    copyOnWriteList.addIfAbsent((Object)string);
                    _projectChangeListenersMap.put(projectChangeListener, copyOnWriteList);
                    _projectChangeListenersOrder.addIfAbsent((Object)projectChangeListener);
                } else {
                    copyOnWriteList.addIfAbsent((Object)string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeProjectChangeListener(String string, ProjectChangeListener projectChangeListener) {
        if (string != null && projectChangeListener != null) {
            string = string.intern();
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                CopyOnWriteList copyOnWriteList = (CopyOnWriteList)_projectChangeListenersMap.get(projectChangeListener);
                if (copyOnWriteList != null) {
                    copyOnWriteList.remove((Object)string);
                    if (copyOnWriteList.size() == 0) {
                        Project.removeProjectChangeListener(projectChangeListener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeProjectChangeListener(ProjectChangeListener projectChangeListener) {
        if (projectChangeListener != null) {
            IdentityHashMap identityHashMap = _projectChangeListenersMap;
            synchronized (identityHashMap) {
                _projectChangeListenersMap.remove(projectChangeListener);
                Object[] objectArray = _projectChangeListenersOrder.getItems();
                int n = 0;
                while (n < objectArray.length) {
                    if (projectChangeListener == objectArray[n]) {
                        _projectChangeListenersOrder.remove(objectArray[n]);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    public final void applyBatchChanges(Runnable runnable) {
        HashStructure hashStructure = this.getSharedPropertiesOnly();
        if (ENABLE_USER_PROPERTIES) {
            HashStructure hashStructure2 = this.getUserPropertiesOnly();
            hashStructure2.applyBatchChanges((Runnable)new 3(this, hashStructure, runnable));
        } else {
            hashStructure.applyBatchChanges(runnable);
        }
    }

    public final void setURL(URL uRL) {
        super.setURL(uRL);
        this.initUserProperties();
    }

    public final Icon getIcon() {
        return ModelArb.getIcon(11);
    }

    public final Iterator getChildren() {
        return ProjectContent.getInstance(this).getNodeIterator();
    }

    public final boolean canRemove(Element element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            Node node2 = OwnerMap.getInstance(this).getContainerOwner(node);
            if (node2 instanceof Folder) {
                return ((Folder)((Object)node2)).canRemove(node);
            }
        }
        return true;
    }

    public final boolean canAdd(Element element) {
        return (element instanceof Project || element instanceof Workspace) ^ true;
    }

    public final boolean containsChild(Element element) {
        if (element instanceof Locatable) {
            URL uRL = ((Locatable)((Object)element)).getURL();
            ContentSet contentSet = ProjectContent.getInstance(this).getAllContents();
            if (contentSet.canHaveMember(uRL)) {
                return URLFileSystem.exists(uRL);
            }
        }
        return false;
    }

    public final int size() {
        return super.size() + OwnerMap.getInstance(this).getOwnedChildrenList().size();
    }

    public final boolean remove(Element element, boolean bl) {
        OwnerMap.getInstance(this).removeElement(element);
        return true;
    }

    public final boolean add(Element element) {
        return true;
    }

    public final boolean add(Node node, String string) {
        return ProjectContent.getInstance(this).add(node, string);
    }

    public final boolean add(Node[] nodeArray, String string) {
        return ProjectContent.getInstance(this).add(nodeArray, string);
    }

    public final boolean add(Element element, boolean bl) {
        return true;
    }

    public final boolean isDefaultProject() {
        return this == Ide.getDefaultProject();
    }

    public final Iterator findChildren(Class clazz) {
        return ProjectContent.getInstance(this).findChildren(clazz);
    }

    public final Iterator findChildren(Class[] classArray) {
        return ProjectContent.getInstance(this).findChildren(classArray);
    }

    public final boolean containsOwnedChild(Element element) {
        if (this.ensureOpen()) {
            return OwnerMap.getInstance(this).containsOwnedChild(element);
        }
        return false;
    }

    public final Folder findOwner(Element element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            Node node2 = OwnerMap.getInstance(this).getContainerOwner(node);
            if (node2 instanceof Folder) {
                return (Folder)((Object)node2);
            }
        }
        if (this.containsChild(element)) {
            return this;
        }
        return null;
    }

    public final void add(Node node, Node node2) {
        if (node2 instanceof Folder) {
            OwnerMap.addToOwnerMap(this, node, node2);
        }
    }

    public final Iterator findMyChildren(Class clazz) {
        return new ProjectContent.ChildTypeIterator(this.getMyChildren(), clazz);
    }

    public final Iterator findMyChildren(Class[] classArray) {
        switch (classArray.length) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return this.findMyChildren(classArray[0]);
            }
        }
        return new ProjectContent.MultiChildTypeIterator(this.getMyChildren(), classArray);
    }

    final void copyChildrenTo(List list, boolean bl) {
        super.copyChildrenTo(list, bl);
        if (bl) {
            OwnerMap.getInstance(this).copyOwnedChildrenListTo(list);
        }
    }

    public final void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.OBJECT_RENAMED) {
            List list = updateMessage.getModifyObjects();
            URL uRL = (URL)list.get(0);
            Node node = (Node)object;
            OwnerMap ownerMap = OwnerMap.getInstance(this);
            Node node2 = ownerMap.getContainerOwner(uRL);
            ownerMap.handleNodeRenamed(uRL, node, node2);
        } else if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            OwnerMap ownerMap = OwnerMap.getInstance(this);
            int n = 0;
            while (n < list.size()) {
                Element element = (Element)list.get(n);
                Node node = ownerMap.getContainerOwner(element);
                if (node != null && this.remove(element, false)) {
                    arrayList.add(element);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                UpdateMessage.fireChildrenRemoved(this, arrayList);
            }
        }
    }

    public final void notifyVetoObservers(Object object, UpdateMessage updateMessage) throws ChangeVetoException {
        ((VetoableSubject)this.getSubject()).notifyVetoObservers(object, updateMessage);
    }

    public static final String getDefaultName() {
        return ModelArb.getString(3);
    }

    protected final void openImpl() throws IOException {
        super.openImpl();
        this.initUserProperties();
        this.maybeCallProjectMigratorHelpers();
        OwnerMap ownerMap = OwnerMap.getInstanceOnOpen(this);
        ownerMap.initOwnerMap();
        StorageListener.mav$attachStructureChangeListener(this._storageListener, this._hash);
    }

    protected final void closeImpl() throws IOException {
        OwnerMap ownerMap;
        if (ENABLE_USER_PROPERTIES) {
            try {
                this.saveUserProperties();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (this._userProperties != null) {
                this._userProperties.getProperties().setParentDirtyable(null);
            }
            this._userProperties = null;
            StorageListener.mav$handleCustomPropsClosed(this._storageListener);
        }
        if ((ownerMap = OwnerMap.getInstance(this)) != null) {
            ownerMap.close();
        }
        StorageListener.mav$detachStructureChangeListener(this._storageListener);
        super.closeImpl();
    }

    protected final void saveImpl() throws IOException {
        this.saveUserProperties();
        if (this._hashDirtyTracker.isDirty()) {
            super.saveImpl();
            this._hashDirtyTracker.clearDirty();
        }
    }

    public final void saveUserProperties() throws IOException {
        if (ENABLE_USER_PROPERTIES && this._userProperties != null) {
            this._userProperties.save();
        }
    }

    final void initListOfChildren() {
    }

    protected final ObjectStore newObjectStore() {
        return new HashStructureIO(NAMESPACE_URI, ROOT_QNAME);
    }

    protected final Object getObjectStoreTarget() {
        return this._hash;
    }

    protected final Subject createSubject() {
        return new IdeVetoableSubject();
    }

    public final boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Project project = (Project)object;
        return this.equalsImpl(project) && ModelUtil.areEqual((Object)this._userProperties, (Object)project._userProperties);
    }

    public final Object copyTo(Object object) {
        Project project;
        Project project2 = project = object != null ? (Project)object : new Project();
        if (this.ensureOpen()) {
            this.copyToImpl(project);
            if (ENABLE_USER_PROPERTIES) {
                if (this._userProperties != null) {
                    if (project._userProperties != null) {
                        this._userProperties.copyTo(project._userProperties);
                    } else {
                        project._userProperties = (UserProperties)this._userProperties.copyTo(null);
                    }
                } else {
                    project._userProperties = null;
                }
            }
        }
        StorageListener.mav$fireProjectCopied(this._storageListener, project);
        return project;
    }

    private void initUserProperties() {
        if (ENABLE_USER_PROPERTIES) {
            URL uRL = this.getURL();
            if (uRL != null) {
                StorageListener.mav$handleCustomPropsClosed(this._storageListener);
                this._userProperties = new UserProperties(uRL);
                StorageListener.mav$handleCustomPropsOpened(this._storageListener, this._userProperties.getProperties());
            } else {
                this._userProperties = null;
            }
        }
    }

    private Iterator getMyChildren() {
        Iterator iterator = this.getChildren();
        Map map = OwnerMap.getInstance(this).getMap();
        if (map != null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Reference reference : map.keySet()) {
                arrayList.add(reference.getData());
            }
            int n = arrayList.size();
            if (n > 0) {
                return new 2(this, iterator, n, arrayList);
            }
        }
        return iterator;
    }

    private void maybeCallProjectMigratorHelpers() {
    }

    private HashStructure getPropertiesImpl(boolean bl) {
        boolean bl2;
        HashStructure hashStructure = this.getSharedPropertiesOnly();
        boolean bl3 = bl2 = ENABLE_USER_PROPERTIES && !this.isDefaultProject() && this._userProperties != null;
        if (bl2) {
            HashStructure hashStructure2 = this.getUserPropertiesOnly();
            HashStructure[] hashStructureArray = new HashStructure[]{hashStructure2, hashStructure};
            if (bl) {
                return HashStructure.newChainForStatusQuo((HashStructure[])hashStructureArray);
            }
            return HashStructure.newChainForOverriding((HashStructure[])hashStructureArray);
        }
        return hashStructure;
    }

    private static boolean namesMatch(String string, String string2) {
        if (string2.startsWith(string)) {
            int n;
            int n2 = string2.length();
            return n2 == (n = string.length()) || string2.charAt(n) == '/' || n == 0;
        }
        return false;
    }

    static StorageListener ra$_storageListener(Project project) {
        return project._storageListener;
    }

    static CopyOnWriteList ra$_projectChangeListenersOrder() {
        return _projectChangeListenersOrder;
    }

    static IdentityHashMap ra$_projectChangeListenersMap() {
        return _projectChangeListenersMap;
    }

    static boolean maS$namesMatch(String string, String string2) {
        return Project.namesMatch(string, string2);
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ HashStructure v$projectHash;
        private final /* synthetic */ Runnable v$runnable;
        final /* synthetic */ Project this$0;

        public void run() {
            this.v$projectHash.applyBatchChanges(this.v$runnable);
        }

        public 3(Project project, HashStructure hashStructure, Runnable runnable) {
            this.v$runnable = runnable;
            this.v$projectHash = hashStructure;
            this.this$0 = project;
        }
    }

    public final class 2
    implements Iterator {
        private Object _next;
        private final /* synthetic */ Iterator v$nodeIter;
        private final /* synthetic */ int v$numOwnedNodes;
        private final /* synthetic */ ArrayList v$ownedNodes;
        final /* synthetic */ Project this$0;

        public boolean hasNext() {
            this.ensurePrepared();
            return this._next != null;
        }

        public Object next() {
            this.ensurePrepared();
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            Object object = this._next;
            this._next = null;
            return object;
        }

        public void remove() {
            new UnsupportedOperationException().printStackTrace();
        }

        private void ensurePrepared() {
            if (this._next == null) {
                while (this.v$nodeIter.hasNext()) {
                    Object e = this.v$nodeIter.next();
                    if (this.isOwnedNode(e)) continue;
                    this._next = e;
                    return;
                }
            }
        }

        private boolean isOwnedNode(Object object) {
            int n = 0;
            while (n < this.v$numOwnedNodes) {
                if (object == this.v$ownedNodes.get(n)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public 2(Project project, Iterator iterator, int n, ArrayList arrayList) {
            this.v$ownedNodes = arrayList;
            this.v$numOwnedNodes = n;
            this.v$nodeIter = iterator;
            this.this$0 = project;
        }
    }

    private static final class NL
    extends NodeListener {
        public void nodeOpened(NodeEvent nodeEvent) {
            StorageListener.mav$fireProjectOpened(Project.ra$_storageListener((Project)nodeEvent.getNode()));
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            StorageListener.mav$fireProjectClosed(Project.ra$_storageListener((Project)nodeEvent.getNode()));
        }

        private NL() {
        }

        NL(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class StorageListener
    extends StructureChangeListener {
        private HashStructure _projectProps;
        private HashStructure _customProps;

        private void attachStructureChangeListener(HashStructure hashStructure) {
            this._projectProps = hashStructure;
            hashStructure.addStructureChangeListener((StructureChangeListener)this);
        }

        private void fireProjectCopied(Project project) {
            Object[] objectArray = Project.ra$_projectChangeListenersOrder().getItems();
            int n = 0;
            while (n < objectArray.length) {
                ProjectChangeListener projectChangeListener = (ProjectChangeListener)objectArray[n];
                try {
                    projectChangeListener.projectCopied(Project.this, project);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }

        private void fireProjectOpened() {
            Object[] objectArray = Project.ra$_projectChangeListenersOrder().getItems();
            int n = 0;
            while (n < objectArray.length) {
                ProjectChangeListener projectChangeListener = (ProjectChangeListener)objectArray[n];
                try {
                    projectChangeListener.projectOpened(Project.this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }

        private void detachStructureChangeListener() {
            if (this._projectProps != null) {
                this._projectProps.removeStructureChangeListener((StructureChangeListener)this);
            }
        }

        private void fireProjectClosed() {
            Object[] objectArray = Project.ra$_projectChangeListenersOrder().getItems();
            int n = 0;
            while (n < objectArray.length) {
                ProjectChangeListener projectChangeListener = (ProjectChangeListener)objectArray[n];
                try {
                    projectChangeListener.projectClosed(Project.this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }

        private void handleCustomPropsOpened(HashStructure hashStructure) {
            this._customProps = hashStructure;
            hashStructure.addStructureChangeListener((StructureChangeListener)this);
        }

        private void handleCustomPropsClosed() {
            if (this._customProps != null) {
                this._customProps.removeStructureChangeListener((StructureChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
            int n = changeInfoArray.length;
            ArrayList<ChangeInfo> arrayList = new ArrayList<ChangeInfo>();
            Object[] objectArray = Project.ra$_projectChangeListenersOrder().getItems();
            int n2 = 0;
            while (n2 < objectArray.length) {
                CopyOnWriteList copyOnWriteList;
                Object object = objectArray[n2];
                IdentityHashMap identityHashMap = Project.ra$_projectChangeListenersMap();
                synchronized (identityHashMap) {
                    copyOnWriteList = (CopyOnWriteList)Project.ra$_projectChangeListenersMap().get(object);
                }
                Object[] objectArray2 = copyOnWriteList.getItems();
                int n3 = objectArray2.length;
                arrayList.clear();
                int n4 = 0;
                while (n4 < n3) {
                    String string = objectArray2[n4].toString();
                    int n5 = 0;
                    while (n5 < n) {
                        ChangeInfo changeInfo = changeInfoArray[n5];
                        String string2 = changeInfo.getPropertyName();
                        if (Project.maS$namesMatch(string, string2)) {
                            arrayList.add(changeInfo);
                        }
                        ++n5;
                    }
                    ++n4;
                }
                if (arrayList.size() > 0) {
                    ChangeInfo[] changeInfoArray2 = arrayList.toArray(new ChangeInfo[arrayList.size()]);
                    ProjectChangeEvent projectChangeEvent = new ProjectChangeEvent(structureChangeEvent.getSource(), Project.this, changeInfoArray2);
                    ProjectChangeListener projectChangeListener = (ProjectChangeListener)object;
                    try {
                        projectChangeListener.projectPropertiesChanged(projectChangeEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n2;
            }
        }

        private StorageListener() {
        }

        static void mav$handleCustomPropsClosed(StorageListener storageListener) {
            storageListener.handleCustomPropsClosed();
        }

        static void mav$handleCustomPropsOpened(StorageListener storageListener, HashStructure hashStructure) {
            storageListener.handleCustomPropsOpened(hashStructure);
        }

        static void mav$fireProjectCopied(StorageListener storageListener, Project project) {
            storageListener.fireProjectCopied(project);
        }

        static void mav$detachStructureChangeListener(StorageListener storageListener) {
            storageListener.detachStructureChangeListener();
        }

        static void mav$attachStructureChangeListener(StorageListener storageListener, HashStructure hashStructure) {
            storageListener.attachStructureChangeListener(hashStructure);
        }

        StorageListener(1 var2_2) {
            this();
        }

        static void mav$fireProjectClosed(StorageListener storageListener) {
            storageListener.fireProjectClosed();
        }

        static void mav$fireProjectOpened(StorageListener storageListener) {
            storageListener.fireProjectOpened();
        }

        public final class 1 {
        }
    }

    public static final class 1
    extends ProjectChangeListener {
        private int _eventCounter;
        private final /* synthetic */ int v$debugLevel;

        void $init$() {
            this._eventCounter = 0;
        }

        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            ChangeInfo[] changeInfoArray = projectChangeEvent.getChangeDetails();
            int n = changeInfoArray.length;
            boolean bl = false;
            if (this.v$debugLevel == 1) {
                int n2 = 0;
                while (n2 < n) {
                    ChangeInfo changeInfo = changeInfoArray[n2];
                    if (changeInfo.getChangeType() == 2) {
                        changeInfoArray[n2] = null;
                    } else {
                        bl = true;
                    }
                    ++n2;
                }
            }
            if (this.v$debugLevel > 1 || bl) {
                ++this._eventCounter;
                int n3 = 0;
                while (n3 < changeInfoArray.length) {
                    ChangeInfo changeInfo = changeInfoArray[n3];
                    if (changeInfo != null) {
                        Project project = projectChangeEvent.getProject();
                        if (projectChangeEvent.getSource() == project._hash) {
                            System.out.print("[" + this._eventCounter + "] shared ");
                        } else {
                            System.out.print("[" + this._eventCounter + "] user   ");
                        }
                        System.out.println(changeInfoArray[n3].toString());
                    }
                    ++n3;
                }
            }
        }

        public 1(int n) {
            this.v$debugLevel = n;
            this.$init$();
        }
    }
}

