/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CopyOnWriteList;

public final class ProjectContent
extends HashStructureAdapter {
    boolean _includeSubFolders;
    public static final String CONTENT_SETS_PROPERTY = "contentProvidersPath";
    private static final CopyOnWriteList _contentSetProviders = new CopyOnWriteList(ContentSetProvider.class);
    private static final L _projectChangeListener = new L(null);
    private static HashSet _contentSetKeysForDisplayFoldersAsPackages = new HashSet();

    void $init$() {
        this._includeSubFolders = false;
    }

    private ProjectContent(HashStructure hashStructure) {
        super(hashStructure);
        this.$init$();
    }

    public boolean isMissingAnyContentSet() {
        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
        ListStructure listStructure = this.getContentSetList();
        int n = contentSetProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentSetProvider contentSetProvider = contentSetProviderArray[n2];
            String string = contentSetProvider.getKey();
            if (string != null) {
                if (!listStructure.contains((Object)string)) {
                    return true;
                }
                int n3 = this._hash.keyStatus(string);
                if (n3 != 1) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static void initializeContentSets(Project project) {
        project.applyBatchChanges(new 1(project));
    }

    public static ProjectContent getInstance(PropertyStorage propertyStorage) {
        return new ProjectContent(propertyStorage.getProperties());
    }

    public static ProjectContent getInstance(HashStructure hashStructure) {
        return new ProjectContent(hashStructure);
    }

    public static final void registerContentSetProvider(ContentSetProvider contentSetProvider) {
        if (contentSetProvider != null) {
            String string = contentSetProvider.getKey();
            if (string != null) {
                if (contentSetProvider.getShortLabel() != null) {
                    Object[] objectArray = _contentSetProviders.getItems();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ContentSetProvider contentSetProvider2 = (ContentSetProvider)objectArray[n2];
                        if (string.equals(contentSetProvider2.getKey())) {
                            System.err.println("**** Warning: Replacing ContentSetProvider '" + string + "'");
                            _contentSetProviders.remove((Object)contentSetProvider2);
                            _contentSetKeysForDisplayFoldersAsPackages.remove(string);
                        }
                        ++n2;
                    }
                    boolean bl = _contentSetProviders.addIfAbsent((Object)contentSetProvider);
                    if (bl && contentSetProvider.displayFoldersAsPackages()) {
                        _contentSetKeysForDisplayFoldersAsPackages.add(string);
                    }
                    Project.addProjectChangeListener(string, _projectChangeListener);
                } else {
                    new IllegalArgumentException("Null ContentSet short label not allowed").printStackTrace();
                }
            } else {
                new IllegalArgumentException("Null ContentSet key not allowed.").printStackTrace();
            }
        }
    }

    public static final void unregisterContentSetProvider(ContentSetProvider contentSetProvider) {
        if (contentSetProvider != null) {
            _contentSetProviders.remove((Object)contentSetProvider);
            Project.removeProjectChangeListener(contentSetProvider.getKey(), _projectChangeListener);
        }
    }

    public static final ContentSetProvider[] getContentSetProviders() {
        return (ContentSetProvider[])_contentSetProviders.getItems();
    }

    public ContentSet getContentSet(String string) {
        return new ContentSet(this._hash.getOrCreateHashStructure(string));
    }

    public final ListStructure getContentSetList() {
        return this._hash.getOrCreateListStructure("contentSets");
    }

    public final ContentSet getAllContents() {
        ContentSet contentSet = new ContentSet(HashStructure.newInstance(), false);
        ListStructure listStructure = this.getContentSetList();
        for (Object e : listStructure) {
            if (e == null) continue;
            String string = e.toString();
            contentSet.addContentSet(this.getContentSet(string));
        }
        return contentSet;
    }

    public final URLPath getJavaRootDirs() {
        URLPath uRLPath = new URLPath();
        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
        if (contentSetProviderArray != null) {
            int n = contentSetProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentSetProvider contentSetProvider = contentSetProviderArray[n2];
                if (contentSetProvider.canContainJavaSources()) {
                    ContentSet contentSet = this.getContentSet(contentSetProvider.getKey());
                    uRLPath.add(contentSet.getAllRootDirs());
                }
                ++n2;
            }
        }
        return uRLPath;
    }

    public Iterator getNodeIterator() {
        return this.getAllContents().nodeIterator("");
    }

    public final Iterator findChildren(Class clazz) {
        return new ChildTypeIterator(this.getNodeIterator(), clazz);
    }

    public final Iterator findChildren(Class[] classArray) {
        switch (classArray.length) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return this.findChildren(classArray[0]);
            }
        }
        return new MultiChildTypeIterator(this.getNodeIterator(), classArray);
    }

    public final Iterator findChildren(Class clazz, String string) {
        ContentSet contentSet = this.getContentSet(string);
        return contentSet != null ? new ChildTypeIterator(contentSet.nodeIterator(null), clazz) : Collections.EMPTY_LIST.iterator();
    }

    public boolean add(Node node, String string) {
        return this.add(new Node[]{node}, string);
    }

    public boolean add(Node[] nodeArray, String string) {
        if (this.lookupProvider(string) == null) {
            throw new IllegalArgumentException("Unknown content set key: " + string);
        }
        if (nodeArray.length == 0) {
            return true;
        }
        boolean bl = true;
        ContentSet contentSet = this.getContentSet(string);
        int n = 0;
        while (n < nodeArray.length) {
            if (!contentSet.canHaveMember(nodeArray[n].getURL()) && !this.addImpl(nodeArray[n], string)) {
                bl = false;
                if (string.equals("oracle.ide.model.ResourcePaths/resourcesContentSet") || !this.addImpl(nodeArray[n], "oracle.ide.model.ResourcePaths/resourcesContentSet")) {
                    // empty if block
                }
            }
            ++n;
        }
        return bl;
    }

    private boolean addImpl(Node node, String string) {
        Node node2 = this.adjust(node);
        URL uRL = node2.getURL();
        ContentSetHelper contentSetHelper = this.lookupHelper(string);
        if (contentSetHelper.canAddContent(uRL, this)) {
            ProgressBar progressBar = SwingUtilities.isEventDispatchThread() ? new ProgressBar((Component)((Object)Ide.getMainWindow()), "Add Content", null, true) : null;
            contentSetHelper.addContent(uRL, this, this._includeSubFolders, progressBar);
            return true;
        }
        return false;
    }

    private Node adjust(Node node) {
        URLFilter uRLFilter = GlobalIgnoreList.getURLFilter();
        URL uRL = node.getURL();
        if (URLFileSystem.isDirectory(uRL)) {
            URL[] uRLArray = URLFileSystem.list(uRL, uRLFilter);
            if (uRLArray == null || uRLArray.length == 0) {
                this._includeSubFolders = true;
            }
        } else {
            URL uRL2 = URLFileSystem.getParent(uRL);
            URL[] uRLArray = URLFileSystem.list(uRL2, uRLFilter);
            if (uRLArray == null || uRLArray.length == 0 || uRLArray.length == 1) {
                try {
                    Node node2 = NodeFactory.findOrCreate(uRL2);
                    if (node2 != null) {
                        this._includeSubFolders = true;
                        Node node3 = node2;
                        return node3;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        return node;
    }

    private ContentSetHelper lookupHelper(String string) {
        ContentSetProvider contentSetProvider = this.lookupProvider(string);
        return contentSetProvider.getContentSetHelper();
    }

    private ContentSetProvider lookupProvider(String string) {
        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
        int n = 0;
        while (n < contentSetProviderArray.length) {
            if (contentSetProviderArray[n].getKey().equals(string)) {
                return contentSetProviderArray[n];
            }
            ++n;
        }
        return null;
    }

    static boolean isDisplayFoldersAsPackages(String string) {
        return _contentSetKeysForDisplayFoldersAsPackages.contains(string);
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Project v$project;

        public void run() {
            ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
            HashStructure hashStructure = this.v$project.getSharedPropertiesOnly();
            ListStructure listStructure = ProjectContent.getInstance(this.v$project).getContentSetList();
            URL uRL = URLFileSystem.getParent(this.v$project.getURL());
            Context context = new Context();
            context.setProject(this.v$project);
            int n = contentSetProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentSetProvider contentSetProvider = contentSetProviderArray[n2];
                String string = contentSetProvider.getKey();
                if (string != null) {
                    boolean bl;
                    int n3 = hashStructure.keyStatus(string);
                    boolean bl2 = bl = n3 == 0 || n3 == 2;
                    if (bl) {
                        HashStructure hashStructure2 = hashStructure.getOrCreateHashStructure(string);
                        ContentSet contentSet = new ContentSet(hashStructure2);
                        contentSetProvider.initContentSet(contentSet, uRL, context);
                    }
                    if (!listStructure.contains((Object)string)) {
                        listStructure.add((Object)string);
                    }
                }
                ++n2;
            }
        }

        public 1(Project project) {
            this.v$project = project;
        }
    }

    private static class L
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            if (project.isDefaultProject()) {
                ProjectContent.initializeContentSets(project);
                if (project.isDirty()) {
                    try {
                        project.save();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            if (!URLFileSystem.isLocalFileSystemCaseSensitive()) {
                try {
                    ContentSet contentSet = ProjectContent.getInstance(project).getAllContents();
                    this.canonicalizeContentSetRootDirs(contentSet);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            VFSListener vFSListener = new VFSListener(project, null);
            L.setVFSListener(project, vFSListener);
            this.refreshVFSWatches(project);
            Node.addNodeListenerForTypeHierarchy(Node.class, vFSListener);
            if (VCSManager.getVCSManager() != null) {
                VCSManager.getVCSManager().addVCSListener(vFSListener, null);
            }
        }

        private void canonicalizeContentSetRootDirs(ContentSet contentSet) {
            if (contentSet != null) {
                URL[] uRLArray;
                URLPath uRLPath = contentSet.getURLPath();
                if (uRLPath != null && (uRLArray = uRLPath.getEntries()) != null) {
                    boolean bl = false;
                    int n = uRLArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URL uRL;
                        URL uRL2 = uRLArray[n2];
                        if (uRL2 != null && !uRL2.equals(uRL = URLFileSystem.canonicalize(uRL2))) {
                            bl = true;
                            uRLArray[n2] = uRL;
                        }
                        ++n2;
                    }
                    if (bl) {
                        uRLPath.setEntries(uRLArray);
                    }
                }
                int n = contentSet.countContentSets();
                int n3 = 0;
                while (n3 < n) {
                    ContentSet contentSet2 = contentSet.getContentSet(n3);
                    this.canonicalizeContentSetRootDirs(contentSet2);
                    ++n3;
                }
            }
        }

        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            Project project = projectChangeEvent.getProject();
            this.refreshVFSWatches(project);
            URLPath uRLPath = ProjectContent.getInstance(project).getAllContents().getAllRootDirs();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(project, ProjectContent.CONTENT_SETS_PROPERTY, null, uRLPath);
            PropertyChangeEvent[] propertyChangeEventArray = new PropertyChangeEvent[]{propertyChangeEvent};
            UpdateMessage.firePropertiesChanged(project, propertyChangeEventArray, ProjectContent.class);
        }

        public void projectClosed(Project project) {
            VFSListener vFSListener = L.getVFSListener(project);
            if (vFSListener != null) {
                Collection collection = URLFileSystem.getURLsForListener(vFSListener);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    URLFileSystem.removeURLFileSystemListener((URL)iterator.next(), vFSListener);
                }
                Node.removeNodeListenerForTypeHierarchy(Node.class, vFSListener);
                if (VCSManager.getVCSManager() != null) {
                    VCSManager.getVCSManager().removeVCSListener(vFSListener);
                }
            }
        }

        private static VFSListener getVFSListener(Project project) {
            return (VFSListener)project.getTransientProperties().get("VFSListener");
        }

        private static void setVFSListener(Project project, VFSListener vFSListener) {
            project.getTransientProperties().put("VFSListener", vFSListener);
        }

        private void refreshVFSWatches(Project project) {
            VFSListener vFSListener = L.getVFSListener(project);
            if (vFSListener != null) {
                Collection collection = URLFileSystem.getURLsForListener(vFSListener);
                URLPath uRLPath = ProjectContent.getInstance(project).getAllContents().getAllRootDirs();
                Iterator iterator = uRLPath.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (collection.contains(e)) continue;
                    URL uRL = (URL)e;
                    URLFileSystem.addURLFileSystemListener(uRL, vFSListener);
                }
                for (URL uRL : collection) {
                    if (uRLPath.contains(uRL)) continue;
                    URLFileSystem.removeURLFileSystemListener(uRL, vFSListener);
                }
            }
        }

        private L() {
        }

        L(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class VFSListener
    extends NodeListener
    implements VCSListener,
    URLFileSystemListener {
        private final Project _project;
        private final ArrayList _addInProgress;
        private final ArrayList _removeInProgress;

        private VFSListener(Project project) {
            this.$init$();
            this._project = project;
        }

        public void nodeDeleted(NodeEvent nodeEvent) {
            URL uRL;
            ContentSet contentSet = ProjectContent.getInstance(this._project).getAllContents();
            if (contentSet.canHaveMember(uRL = nodeEvent.getNodeURL())) {
                this.startAssertTracking(null, uRL);
                try {
                    Node node = nodeEvent.getNode();
                    this.fireRemovedEvent(uRL, node);
                }
                finally {
                    this.stopAssertTracking(null, uRL);
                }
            }
        }

        public void nodeRenamed(NodeEvent nodeEvent, URL uRL, URL uRL2) {
            ContentSet contentSet = ProjectContent.getInstance(this._project).getAllContents();
            boolean bl = contentSet.canHaveMember(uRL);
            boolean bl2 = contentSet.canHaveMember(uRL2);
            if (bl || bl2) {
                this.startAssertTracking(uRL2, uRL);
                try {
                    if (bl && bl2) {
                        Node node = nodeEvent.getNode();
                        Node node2 = NodeFactory.find(uRL2);
                        this.fireRenamedEvents(uRL, node, node2);
                    } else if (bl) {
                        Node node = nodeEvent.getNode();
                        this.fireRemovedEvent(uRL, node);
                    } else {
                        Node node = NodeFactory.find(uRL2);
                        this.fireAddedEvent(node);
                    }
                }
                finally {
                    this.stopAssertTracking(uRL2, uRL);
                }
            }
        }

        public void notifyEvent(URLFileSystemEvent uRLFileSystemEvent) {
            int n = uRLFileSystemEvent.getEventType();
            switch (n) {
                case 1: {
                    ContentSet contentSet = ProjectContent.getInstance(this._project).getAllContents();
                    URL uRL = uRLFileSystemEvent.getURL();
                    if (!contentSet.canHaveMember(uRL)) break;
                    this.startAssertTracking(uRL, null);
                    try {
                        try {
                            Node node = NodeFactory.findOrCreate(uRL);
                            this.fireAddedEvent(node);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    finally {
                        this.stopAssertTracking(uRL, null);
                    }
                }
            }
        }

        void $init$() {
            this._addInProgress = new ArrayList();
            this._removeInProgress = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startAssertTracking(URL uRL, URL uRL2) {
            VFSListener vFSListener = this;
            synchronized (vFSListener) {
                if (uRL != null && this._removeInProgress.contains(uRL)) {
                    new RuntimeException("Assertion failure: FILE_ADDED event received while processing FILE_REMOVED for " + uRL).printStackTrace();
                }
                if (uRL2 != null && this._addInProgress.contains(uRL2)) {
                    new RuntimeException("Assertion failure: FILE_REMOVED event received while processing FILE_ADDED for " + uRL2).printStackTrace();
                }
                if (uRL != null) {
                    this._addInProgress.add(uRL);
                }
                if (uRL2 != null) {
                    this._removeInProgress.add(uRL2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAssertTracking(URL uRL, URL uRL2) {
            VFSListener vFSListener = this;
            synchronized (vFSListener) {
                if (uRL != null) {
                    this._addInProgress.remove(uRL);
                }
                if (uRL2 != null) {
                    this._removeInProgress.remove(uRL2);
                }
            }
        }

        private void fireAddedEvent(Node node) {
            UpdateMessage.fireChildAdded(this._project, node);
        }

        private void fireRemovedEvent(URL uRL, Node node) {
            1 var3_3 = new 1(this, uRL);
            try {
                node.attach(var3_3);
                UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, this);
                updateMessage.getRemoveObjects().add(node);
                this._project.notifyObservers(this._project, updateMessage);
            }
            finally {
                node.detach(var3_3);
            }
        }

        private void fireRenamedEvents(URL uRL, Node node, Node node2) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.OBJECT_RENAMED, node);
            RenameMessage.setRenamedNode(updateMessage, node);
            if (node2 != null) {
                updateMessage.getAddObjects().add(node2);
                updateMessage.getRemoveObjects().add(node);
            }
            updateMessage.getModifyObjects().add(uRL);
            node.notifyObservers(node, updateMessage);
            updateMessage = new UpdateMessage(UpdateMessage.CHILD_RENAMED, this._project);
            RenameMessage.setRenamedNode(updateMessage, node);
            if (node2 != null) {
                updateMessage.getAddObjects().add(node2);
                updateMessage.getRemoveObjects().add(node);
            }
            updateMessage.getModifyObjects().add(uRL);
            updateMessage.getModifyObjects().add(this._project);
            this._project.notifyObservers(this._project, updateMessage);
        }

        public void notifyEvent(VCSEvent vCSEvent) {
            int n = vCSEvent.getEventType();
            switch (n) {
                case 1: {
                    ContentSet contentSet = ProjectContent.getInstance(this._project).getAllContents();
                    URL[] uRLArray = vCSEvent.getURLs();
                    int n2 = 0;
                    while (n2 < uRLArray.length) {
                        if (contentSet.canHaveMember(uRLArray[n2])) {
                            try {
                                Node node = NodeFactory.findOrCreate(uRLArray[n2]);
                                this.fireAddedEvent(node);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    ContentSet contentSet = ProjectContent.getInstance(this._project).getAllContents();
                    URL[] uRLArray = vCSEvent.getURLs();
                    int n3 = 0;
                    while (n3 < uRLArray.length) {
                        Node node;
                        if (contentSet.canHaveMember(uRLArray[n3]) && (node = NodeFactory.find(uRLArray[n3])) != null) {
                            this.fireRemovedEvent(uRLArray[n3], node);
                        }
                        ++n3;
                    }
                    break;
                }
                case 4: {
                    ContentSet contentSet = ProjectContent.getInstance(this._project).getAllContents();
                    URL[] uRLArray = vCSEvent.getURLs();
                    URL uRL = URLFileSystem.getParent(this._project.getURL());
                    int n4 = 0;
                    while (n4 < uRLArray.length) {
                        if (contentSet.canHaveMember(uRLArray[n4])) {
                            this.fireStructureChangedEvent();
                        } else if (URLFileSystem.equals(uRLArray[n4], uRL)) {
                            this.fireStructureChangedEvent();
                        }
                        ++n4;
                    }
                    break;
                }
            }
        }

        private void fireStructureChangedEvent() {
            UpdateMessage.fireStructureChanged(this._project);
        }

        VFSListener(Project project, 1 var2_2) {
            this(project);
        }

        public final class 1
        implements Observer {
            private final /* synthetic */ URL v$removedURL;
            final /* synthetic */ VFSListener this$0;

            public void update(Object object, UpdateMessage updateMessage) {
                if (updateMessage.getOrigin() != this.this$0) {
                    new RuntimeException("Assertion failure: Observer update received on a node that has already been deleted from disk for " + this.v$removedURL).printStackTrace();
                }
            }

            public 1(VFSListener vFSListener, URL uRL) {
                this.v$removedURL = uRL;
                this.this$0 = vFSListener;
            }
        }
    }

    public static final class ChildTypeIterator
    implements Iterator {
        private Iterator _iter;
        private Object _next;
        private Class _type;

        ChildTypeIterator(Iterator iterator, Class clazz) {
            this._iter = iterator;
            this._type = clazz;
        }

        public boolean hasNext() {
            while (this._next == null && this._iter != null && this._iter.hasNext()) {
                Object e = this._iter.next();
                if (!this._type.isAssignableFrom(e.getClass())) continue;
                this._next = e;
            }
            return this._next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this._next;
            this._next = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static final class MultiChildTypeIterator
    implements Iterator {
        private Iterator _iter;
        private Object _next;
        private final Class[] _types;
        private final int _len;

        MultiChildTypeIterator(Iterator iterator, Class[] classArray) {
            this._iter = iterator;
            this._types = classArray;
            this._len = this._types.length;
        }

        public boolean hasNext() {
            block0: while (this._next == null && this._iter != null && this._iter.hasNext()) {
                Object e = this._iter.next();
                Class<?> clazz = e.getClass();
                int n = 0;
                while (n < this._len) {
                    if (this._types[n].isAssignableFrom(clazz)) {
                        this._next = e;
                        continue block0;
                    }
                    ++n;
                }
            }
            return this._next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this._next;
            this._next = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

