/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class ProjectVersion
extends HashStructureAdapter {
    public static final String PROJECT_KEY = "oracle.ide.model.Project";
    public static final String COMPONENT_VERSIONS_KEY = "component-versions";

    public ProjectVersion(PropertyStorage propertyStorage) {
        this(propertyStorage.getProperties());
    }

    public ProjectVersion(HashStructure hashStructure) {
        super(hashStructure.getOrCreateHashStructure(COMPONENT_VERSIONS_KEY));
    }

    public static void initializeVersions(PropertyStorage propertyStorage, String string) {
        NodeMigratorHelper[] nodeMigratorHelperArray;
        NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(string);
        if (nodeMigrator != null && (nodeMigratorHelperArray = nodeMigrator.getHelpers()) != null) {
            ProjectVersion projectVersion = new ProjectVersion(propertyStorage);
            int n = nodeMigratorHelperArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeMigratorHelper nodeMigratorHelper = nodeMigratorHelperArray[n2];
                String string2 = nodeMigratorHelper.getNodeMigratorHelperKey();
                if (string2 != null) {
                    String string3 = nodeMigratorHelper.getNodeMigratorHelperVersion();
                    projectVersion.addVersion(string2, new VersionNumber(string3));
                }
                ++n2;
            }
        }
    }

    public VersionNumber getCurrentVersion() {
        return this.getCurrentVersion(PROJECT_KEY);
    }

    public VersionNumber[] getVersionHistory() {
        return this.getVersionHistory(PROJECT_KEY);
    }

    public VersionNumber getCurrentVersion(String string) {
        VersionNumber[] versionNumberArray = this.getVersionHistory(string);
        int n = versionNumberArray.length;
        return n > 0 ? versionNumberArray[n - 1] : null;
    }

    public VersionNumber[] getVersionHistory(String string) {
        String string2 = this._hash.getString(string);
        Object[] objectArray = ProjectVersion.convertStringToVersionNumbers(string2);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void setVersionHistory(String string, VersionNumber[] versionNumberArray) {
        String string2 = ProjectVersion.convertVersionNumbersToString(versionNumberArray);
        this._hash.putString(string, string2);
    }

    public void addVersion(String string, VersionNumber versionNumber) {
        VersionNumber[] versionNumberArray;
        VersionNumber[] versionNumberArray2;
        if (versionNumber != null && (versionNumberArray2 = ProjectVersion.addVersionImpl(versionNumberArray = this.getVersionHistory(string), versionNumber)) != versionNumberArray) {
            this.setVersionHistory(string, versionNumberArray2);
        }
    }

    public void removeVersion(String string, VersionNumber versionNumber) {
        VersionNumber[] versionNumberArray;
        VersionNumber[] versionNumberArray2;
        if (versionNumber != null && (versionNumberArray2 = ProjectVersion.removeVersionImpl(versionNumberArray = this.getVersionHistory(string), versionNumber)) != versionNumberArray) {
            this.setVersionHistory(string, versionNumberArray2);
        }
    }

    static VersionNumber[] convertStringToVersionNumbers(String string) {
        ArrayList<VersionNumber> arrayList = new ArrayList<VersionNumber>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                VersionNumber versionNumber = new VersionNumber(string2);
                arrayList.add(versionNumber);
            }
        }
        return arrayList.toArray(new VersionNumber[arrayList.size()]);
    }

    static String convertVersionNumbersToString(VersionNumber[] versionNumberArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (versionNumberArray != null) {
            int n = versionNumberArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                String string;
                VersionNumber versionNumber = versionNumberArray[n3];
                if (versionNumber != null && (string = versionNumber.toString()).length() > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append(';');
                    ++n2;
                }
                ++n3;
            }
            if (n2 > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    static VersionNumber[] addVersionImpl(VersionNumber[] versionNumberArray, VersionNumber versionNumber) {
        if (versionNumberArray != null && versionNumberArray.length > 0) {
            int n = Arrays.binarySearch(versionNumberArray, versionNumber);
            if (n < 0) {
                int n2 = versionNumberArray.length;
                VersionNumber[] versionNumberArray2 = new VersionNumber[n2 + 1];
                int n3 = -n - 1;
                System.arraycopy(versionNumberArray, 0, versionNumberArray2, 0, n3);
                versionNumberArray2[n3] = versionNumber;
                System.arraycopy(versionNumberArray, n3, versionNumberArray2, n3 + 1, n2 - n3);
                return versionNumberArray2;
            }
            return versionNumberArray;
        }
        return new VersionNumber[]{versionNumber};
    }

    static VersionNumber[] removeVersionImpl(VersionNumber[] versionNumberArray, VersionNumber versionNumber) {
        if (versionNumberArray != null) {
            int n;
            int n2 = versionNumberArray.length;
            if (n2 > 0 && (n = Arrays.binarySearch(versionNumberArray, versionNumber)) >= 0) {
                VersionNumber[] versionNumberArray2 = new VersionNumber[n2 - 1];
                System.arraycopy(versionNumberArray, 0, versionNumberArray2, 0, n);
                System.arraycopy(versionNumberArray, n + 1, versionNumberArray2, n, n2 - n - 1);
                return versionNumberArray2;
            }
            return versionNumberArray;
        }
        return new VersionNumber[0];
    }
}

