/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Node;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLRecognizer;

public abstract class Recognizer {
    private static final HashSet _extensionsForXML = new HashSet();
    private static final HashMap _customRecognizerMap = new HashMap();
    private static final ArrayList _lowPriorityRecognizers = new ArrayList();
    private static Recognizer _defaultRecognizer = new 1();
    private static final HashMap _extensionToClassMap = new HashMap();
    private static final HashMap _extensionToContentTypeMap = new HashMap();
    private static final HashMap _documentInfoMap = new HashMap();
    private static final HashMap _validNodeClassConversionsMap = new HashMap();
    private static final ForURL _urlRecognizer = new ForURL(null);

    public abstract Class recognize(URL var1);

    public Node create(URL uRL, Class clazz) throws IllegalAccessException, InstantiationException {
        if (clazz != null) {
            Node node = (Node)clazz.newInstance();
            node.setURL(uRL);
            return node;
        }
        return null;
    }

    public URL validate(URL uRL, URL uRL2) throws RecognizerException {
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canConvert(URL uRL, URL uRL2) {
        if (uRL != null && uRL2 != null) {
            Class clazz = Recognizer.recognizeURL(uRL);
            Class clazz2 = this.recognize(uRL2);
            if (clazz != null && clazz2 != null) {
                HashSet hashSet;
                if (clazz == clazz2) {
                    return true;
                }
                HashMap hashMap = _validNodeClassConversionsMap;
                synchronized (hashMap) {
                    hashSet = (HashSet)_validNodeClassConversionsMap.get(clazz);
                }
                if (hashSet != null) {
                    return hashSet.contains(clazz2);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapExtensionToClass(String string, Class clazz) {
        if (string == null || clazz == null || string.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File file = Recognizer.sanitizeExtension(string);
        HashMap hashMap = _extensionToClassMap;
        synchronized (hashMap) {
            _extensionToClassMap.put(file, clazz);
        }
    }

    public static void mapExtensionToXML(String string) {
        if (string != null) {
            _extensionsForXML.add(Recognizer.sanitizeExtension(string));
        }
    }

    public static void registerRecognizer(String string, Recognizer recognizer) {
        if (recognizer != null && string != null && string.length() > 0) {
            Recognizer[] recognizerArray;
            File file = Recognizer.sanitizeExtension(string);
            Object v = _customRecognizerMap.get(file);
            if (v != null) {
                Recognizer[] recognizerArray2 = (Recognizer[])v;
                int n = recognizerArray2.length;
                recognizerArray = new Recognizer[n + 1];
                System.arraycopy(recognizerArray2, 0, recognizerArray, 0, n);
                recognizerArray[n] = recognizer;
            } else {
                recognizerArray = new Recognizer[]{recognizer};
            }
            _customRecognizerMap.put(file, recognizerArray);
        }
    }

    public static void registerRecognizer(String[] stringArray, Recognizer recognizer) {
        if (stringArray != null && recognizer != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Recognizer.registerRecognizer(stringArray[n2], recognizer);
                ++n2;
            }
        }
    }

    public static void registerLowPriorityRecognizer(Recognizer recognizer) {
        if (recognizer != null && !_lowPriorityRecognizers.contains(recognizer)) {
            _lowPriorityRecognizers.add(recognizer);
        }
    }

    public static Recognizer getDefaultRecognizer() {
        return _defaultRecognizer;
    }

    public static void setDefaultRecognizer(Recognizer recognizer) {
        if (recognizer != null) {
            _defaultRecognizer = recognizer;
        }
    }

    public static Class getDefaultNodeType() {
        return UnrecognizedTextNode.class;
    }

    protected static boolean isXmlExtension(String string) {
        if (string != null) {
            return _extensionsForXML.contains(Recognizer.sanitizeExtension(string));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerConversion(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            throw new IllegalArgumentException();
        }
        HashMap hashMap = _validNodeClassConversionsMap;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)_validNodeClassConversionsMap.get(clazz);
            if (hashSet != null) {
                hashSet.add(clazz2);
            } else {
                HashSet<Class> hashSet2 = new HashSet<Class>();
                hashSet2.add(clazz2);
                _validNodeClassConversionsMap.put(clazz, hashSet2);
            }
        }
    }

    public static Recognizer findRecognizer(URL uRL) {
        if (uRL != null) {
            Iterator iterator = Recognizer.getRecognizerIterator(uRL);
            while (iterator.hasNext()) {
                Recognizer recognizer = (Recognizer)iterator.next();
                Class clazz = recognizer.recognize(uRL);
                if (clazz == null) continue;
                return recognizer;
            }
        }
        return null;
    }

    public static Class recognizeURL(URL uRL) {
        return Recognizer.recognizeURL(uRL, Recognizer.getDefaultNodeType());
    }

    public static Class recognizeURL(URL uRL, Class clazz) {
        if (uRL != null) {
            Iterator iterator = Recognizer.getRecognizerIterator(uRL);
            while (iterator.hasNext()) {
                Recognizer recognizer = (Recognizer)iterator.next();
                Class clazz2 = recognizer.recognize(uRL);
                if (clazz2 == null) continue;
                return clazz2;
            }
        }
        return clazz;
    }

    public static final Map getExtensionToClassMap() {
        return _extensionToClassMap;
    }

    public static final Map getExtensionToContentTypeMap() {
        return _extensionToContentTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DocumentInfo getDocumentInfo(Class clazz) {
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            DocumentInfo documentInfo = (DocumentInfo)_documentInfoMap.get(clazz);
            return documentInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Class getClassForExtension(String string) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File file = Recognizer.sanitizeExtension(string);
        HashMap hashMap = _extensionToClassMap;
        synchronized (hashMap) {
            Class clazz = (Class)_extensionToClassMap.get(file);
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ContentType getContentTypeForExtension(String string) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File file = Recognizer.sanitizeExtension(string);
        HashMap hashMap = _extensionToContentTypeMap;
        synchronized (hashMap) {
            ContentType contentType = (ContentType)_extensionToContentTypeMap.get(file);
            return contentType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void mapExtensionToContentType(String string, ContentType contentType) {
        if (string == null || contentType == null || string.length() <= 0) {
            throw new IllegalArgumentException();
        }
        File file = Recognizer.sanitizeExtension(string);
        HashMap hashMap = _extensionToContentTypeMap;
        synchronized (hashMap) {
            _extensionToContentTypeMap.put(file, contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerDocumentInfo(Class clazz, DocumentInfo documentInfo) {
        HashMap hashMap = _documentInfoMap;
        synchronized (hashMap) {
            _documentInfoMap.put(clazz, documentInfo);
        }
    }

    public static final File sanitizeExtension(String string) {
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        return new File(string);
    }

    static Iterator getRecognizerIterator(URL uRL) {
        String string = URLFileSystem.getFileName(uRL);
        int n = string.indexOf(".");
        String string2 = n >= 0 ? string.substring(n) : "";
        return new 2(string2);
    }

    static HashMap ra$_customRecognizerMap() {
        return _customRecognizerMap;
    }

    static HashSet ra$_extensionsForXML() {
        return _extensionsForXML;
    }

    static HashMap ra$_extensionToClassMap() {
        return _extensionToClassMap;
    }

    static ForURL ra$_urlRecognizer() {
        return _urlRecognizer;
    }

    static ArrayList ra$_lowPriorityRecognizers() {
        return _lowPriorityRecognizers;
    }

    static Recognizer ra$_defaultRecognizer() {
        return _defaultRecognizer;
    }

    private static final class ForURL
    extends Recognizer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class recognize(URL uRL) {
            String string = URLFileSystem.getSuffix(uRL);
            File file = new File(string);
            if (string != null && string.length() > 0) {
                Object v;
                Map map;
                Map map2 = map = ForURL.getExtensionToClassMap();
                synchronized (map2) {
                    v = map.get(file);
                }
                if (v != null) {
                    return (Class)v;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL validate(URL uRL, URL uRL2) throws RecognizerException {
            Map map;
            String string = URLFileSystem.getSuffix(uRL);
            File file = new File(string);
            Map map2 = map = ForURL.getExtensionToClassMap();
            synchronized (map2) {
                if (map.containsKey(file)) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
            }
            if (this.recognize(uRL2) != null) {
                String string2 = URLFileSystem.getSuffix(uRL2);
                try {
                    String string3 = uRL.getPath() + string2;
                    URL uRL4 = URLFactory.replacePathPart(uRL, string3);
                    return uRL4;
                }
                catch (Exception exception) {
                    throw new RecognizerException("Internal exception: Unable to build new URL: " + exception.getLocalizedMessage());
                }
            }
            throw new RecognizerException("Internal exception: Old URL not recognized.");
        }

        private ForURL() {
        }

        ForURL(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class 2
    implements Iterator {
        private String _suffix;
        private LinkedList _cur;
        private boolean _triedLowPriorityRecognizers;
        private final /* synthetic */ String v$initialSuffix;

        void $init$() {
            this._suffix = this.v$initialSuffix;
            this._cur = new LinkedList();
            this._triedLowPriorityRecognizers = false;
        }

        public boolean hasNext() {
            this.maybePrepare();
            return this._cur != null;
        }

        public Object next() {
            this.maybePrepare();
            return this._cur.removeFirst();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void maybePrepare() {
            if (this._cur != null && this._cur.size() <= 0) {
                while (this._suffix.length() > 0) {
                    File file = Recognizer.sanitizeExtension(this._suffix);
                    int n = this._suffix.indexOf(".", 1);
                    this._suffix = n >= 1 ? this._suffix.substring(n) : "";
                    Object v = Recognizer.ra$_customRecognizerMap().get(file);
                    if (v != null) {
                        Object[] objectArray = (Object[])v;
                        int n2 = objectArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            this._cur.add(objectArray[n3]);
                            ++n3;
                        }
                    }
                    if (Recognizer.ra$_extensionsForXML().contains(file)) {
                        this._cur.add(XMLRecognizer.getInstance());
                    }
                    if (Recognizer.ra$_extensionToClassMap().containsKey(file)) {
                        this._cur.add(Recognizer.ra$_urlRecognizer());
                    }
                    if (this._cur.size() <= 0) continue;
                    return;
                }
                if (!this._triedLowPriorityRecognizers) {
                    this._triedLowPriorityRecognizers = true;
                    this._cur.addAll(Recognizer.ra$_lowPriorityRecognizers());
                    this._cur.add(Recognizer.ra$_defaultRecognizer());
                    return;
                }
                this._cur = null;
            }
        }

        public 2(String string) {
            this.v$initialSuffix = string;
            this.$init$();
        }
    }

    public static final class 1
    extends Recognizer {
        public Class recognize(URL uRL) {
            return null;
        }
    }
}

