/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;

public class ResourcePathsMigrator
extends NodeMigratorHelper {
    private static ResourcePathsMigrator migrator = new ResourcePathsMigrator();
    private static final String ORIGINAL_RESOURCES_DATA_KEY = "oracle.jdeveloper.resources.ResourcePaths";
    private static String ORIGINAL_CONTENT_SET_KEY = "oracle.jdeveloper.resources.ResourcePaths/resourcesContentSet";

    public static ResourcePathsMigrator getInstance() {
        return migrator;
    }

    private ResourcePathsMigrator() {
    }

    public void migrate(MigrationInfo[] migrationInfoArray, TraversableContext traversableContext) {
        int n = migrationInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = migrationInfoArray[n2].getNode();
            if (node instanceof Project) {
                Project project = (Project)node;
                HashStructure hashStructure = project.getProperties();
                HashStructure hashStructure2 = hashStructure.getHashStructure(ORIGINAL_CONTENT_SET_KEY);
                if (hashStructure2 != null) {
                    HashStructure hashStructure3 = hashStructure.getOrCreateHashStructure("oracle.ide.model.ResourcePaths/resourcesContentSet");
                    hashStructure2.copyTo(hashStructure3);
                }
                hashStructure.remove(ORIGINAL_RESOURCES_DATA_KEY);
                ProjectContent.getInstance(project).getContentSetList().remove((Object)ORIGINAL_CONTENT_SET_KEY);
            }
            ++n2;
        }
    }
}

