/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.model.PseudoTechnologyCallback;
import oracle.ide.model.TechnologyScope;

public final class TechId
implements Comparable {
    private Set _dependencies;
    private final PseudoTechnologyCallback _callback;
    private final String _name;
    private final String _description;
    private final String _key;
    private int _refCount;

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getKey() {
        return this._key;
    }

    public boolean addDependency(TechId techId) {
        if (techId == null || techId == this) {
            return false;
        }
        if (this._dependencies == null) {
            this._dependencies = new HashSet();
        }
        return this._dependencies.add(techId);
    }

    public boolean removeDependency(TechId techId) {
        return this._dependencies != null ? this._dependencies.remove(techId) : false;
    }

    public Set getDependencies() {
        if (this._dependencies == null || this._dependencies.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(this._dependencies);
    }

    public boolean isVisible() {
        return this._callback == null;
    }

    public boolean isInScope(TechnologyScope technologyScope) {
        if (technologyScope.contains(this)) {
            return true;
        }
        return this._callback != null && this._callback.isInScope(technologyScope);
    }

    public boolean dependsOn(TechId techId) {
        if (this._dependencies != null) {
            for (TechId techId2 : this._dependencies) {
                if (techId2 != techId && !techId2.dependsOn(techId)) continue;
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object object) {
        return Collator.getInstance().compare(this._name, ((TechId)object)._name);
    }

    public String toString() {
        return this.getName();
    }

    static TechId createTechId(String string, String string2, String string3) {
        return new TechId(string, string2, string3);
    }

    static TechId createPseudoTechId(String string, PseudoTechnologyCallback pseudoTechnologyCallback) {
        return new TechId(string, pseudoTechnologyCallback);
    }

    PseudoTechnologyCallback getCallback() {
        return this._callback;
    }

    void addRef() {
        ++this._refCount;
    }

    void release() {
        --this._refCount;
    }

    int refCount() {
        return this._refCount;
    }

    private TechId(String string, String string2, String string3) {
        this._key = string;
        this._name = string2;
        this._description = string3;
        this._dependencies = null;
        this._callback = null;
    }

    private TechId(String string, PseudoTechnologyCallback pseudoTechnologyCallback) {
        this._key = string;
        this._name = string;
        this._description = null;
        this._dependencies = null;
        this._callback = pseudoTechnologyCallback;
    }
}

