/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.ide.model.PseudoTechnologyCallback;
import oracle.ide.model.TechId;

public final class TechnologyRegistry {
    private static final TechnologyRegistry INSTANCE = new TechnologyRegistry();
    private static final TechId[] NO_DEPENDENCIES = new TechId[0];
    private Map _technologyMap;

    void $init$() {
        this._technologyMap = new HashMap();
    }

    private TechnologyRegistry() {
        this.$init$();
    }

    public static TechnologyRegistry getInstance() {
        return INSTANCE;
    }

    public void registerTechnology(String string, String string2, String string3) {
        this.registerTechnology(string, string2, string3, NO_DEPENDENCIES);
    }

    public void registerTechnology(String string, String string2, String string3, TechId techId) {
        TechId[] techIdArray;
        if (techId != null) {
            TechId[] techIdArray2 = new TechId[1];
            techIdArray = techIdArray2;
            techIdArray2[0] = techId;
        } else {
            techIdArray = NO_DEPENDENCIES;
        }
        TechId[] techIdArray3 = techIdArray;
        this.registerTechnology(string, string2, string3, techIdArray3);
    }

    public void registerTechnology(String string, String string2, String string3, TechId[] techIdArray) {
        TechId techId = this.getTechId(string);
        if (techId == null) {
            techId = TechId.createTechId(string, string2, string3);
            int n = 0;
            while (n < techIdArray.length) {
                TechId techId2 = techIdArray[n];
                techId.addDependency(techId2);
                ++n;
            }
            this._technologyMap.put(string, techId);
        }
        techId.addRef();
    }

    public void registerPseudoTechnology(String string, PseudoTechnologyCallback pseudoTechnologyCallback) {
        TechId techId = this.getTechId(string);
        if (techId == null) {
            techId = TechId.createPseudoTechId(string, pseudoTechnologyCallback);
            this._technologyMap.put(string, techId);
        }
        techId.addRef();
    }

    public void unregisterTechnology(String string) {
        TechId techId = this.getTechId(string);
        if (techId != null) {
            techId.release();
            if (techId.refCount() <= 0) {
                this._technologyMap.remove(string);
            }
        }
    }

    public TechId getTechId(String string) {
        return (TechId)this._technologyMap.get(string);
    }

    public TechId[] getAllTechIds() {
        Collection collection = this._technologyMap.values();
        return collection.toArray(new TechId[collection.size()]);
    }

    public TechId[] getVisibleTechIds() {
        ArrayList<TechId> arrayList = new ArrayList<TechId>();
        for (TechId techId : this._technologyMap.values()) {
            if (!techId.isVisible()) continue;
            arrayList.add(techId);
        }
        return arrayList.toArray(new TechId[arrayList.size()]);
    }

    public TechId[] getDependenciesFor(TechId techId) {
        if (techId == null) {
            return NO_DEPENDENCIES;
        }
        HashSet<TechId> hashSet = new HashSet<TechId>();
        for (TechId techId2 : this._technologyMap.values()) {
            if (!techId.dependsOn(techId2)) continue;
            hashSet.add(techId2);
        }
        return hashSet.toArray(new TechId[hashSet.size()]);
    }

    public TechId[] getDependentsFor(TechId techId) {
        if (techId == null) {
            return NO_DEPENDENCIES;
        }
        HashSet<TechId> hashSet = new HashSet<TechId>();
        for (TechId techId2 : this._technologyMap.values()) {
            if (!techId2.dependsOn(techId)) continue;
            hashSet.add(techId2);
        }
        return hashSet.toArray(new TechId[hashSet.size()]);
    }
}

