/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public final class TechnologyScope
implements Copyable {
    private final Set _technologySet;

    void $init$() {
        this._technologySet = new HashSet();
    }

    public TechnologyScope() {
        this.$init$();
    }

    public TechnologyScope(TechnologyScope technologyScope) {
        this();
        if (technologyScope != null) {
            technologyScope.copyToImpl(this);
        }
    }

    public boolean add(TechId techId) {
        TechId[] techIdArray = TechnologyRegistry.getInstance().getDependenciesFor(techId);
        boolean bl = false;
        int n = 0;
        while (n < techIdArray.length) {
            TechId techId2 = techIdArray[n];
            if (this._technologySet.add(techId2)) {
                bl = true;
            }
            ++n;
        }
        return this._technologySet.add(techId) || bl;
    }

    public boolean remove(TechId techId) {
        if (this._technologySet.remove(techId)) {
            while (this.pruneOrphanedTechnologies()) {
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._technologySet.clear();
    }

    public boolean contains(TechId techId) {
        return this._technologySet.contains(techId);
    }

    public boolean isEmpty() {
        return this._technologySet.isEmpty();
    }

    public TechId[] toArray() {
        return this._technologySet.toArray(new TechId[this._technologySet.size()]);
    }

    public String[] getTechnologyKeys() {
        String[] stringArray = new String[this._technologySet.size()];
        int n = 0;
        for (TechId techId : this._technologySet) {
            stringArray[n++] = techId.getKey();
        }
        return stringArray;
    }

    public void setTechnologyKeys(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.equalsImpl((TechnologyScope)object);
    }

    public Object copyTo(Object object) {
        TechnologyScope technologyScope = object != null ? (TechnologyScope)object : new TechnologyScope();
        this.copyToImpl(technologyScope);
        return technologyScope;
    }

    protected final boolean equalsImpl(TechnologyScope technologyScope) {
        return ModelUtil.areEqual((Object)this._technologySet, (Object)technologyScope._technologySet);
    }

    protected final void copyToImpl(TechnologyScope technologyScope) {
        technologyScope.setTechnologySet(this._technologySet);
    }

    private boolean pruneOrphanedTechnologies() {
        boolean bl = false;
        Iterator iterator = this._technologySet.iterator();
        block0: while (iterator.hasNext()) {
            TechId techId = (TechId)iterator.next();
            Set set = techId.getDependencies();
            if (set.isEmpty()) continue;
            TechId[] techIdArray = set.toArray(new TechId[set.size()]);
            int n = 0;
            while (n < techIdArray.length) {
                TechId techId2 = techIdArray[n];
                if (this._technologySet.contains(techId2)) continue block0;
                ++n;
            }
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    private void setTechnologySet(Set set) {
        this._technologySet.clear();
        this._technologySet.addAll(set);
    }

    private void add(String string) {
        TechId techId = TechnologyRegistry.getInstance().getTechId(string);
        if (techId != null) {
            this.add(techId);
        }
    }
}

