/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class TechnologyScopeConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = TechnologyScopeConfiguration.class.getName();
    public static final String TECHNOLOGY_SCOPE_PROPERTY = "technologyScope";
    public static final String TECHNOLOGY_SCOPE_KEY = DATA_KEY + "/" + "technologyScope";
    private static ProjectChangeListener _listener;

    private TechnologyScopeConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static TechnologyScopeConfiguration getInstance(PropertyStorage propertyStorage) {
        return new TechnologyScopeConfiguration(TechnologyScopeConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public static void init() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener(DATA_KEY + "/" + TECHNOLOGY_SCOPE_PROPERTY, _listener);
        }
    }

    private ListStructure getTechnologies() {
        return this._hash.getOrCreateListStructure(TECHNOLOGY_SCOPE_PROPERTY);
    }

    private static TechnologyScope getTechnologyScope(ListStructure listStructure) {
        TechnologyScope technologyScope = new TechnologyScope();
        if (listStructure != null) {
            technologyScope.setTechnologyKeys((String[])listStructure.toArray((Object[])new String[listStructure.size()]));
        }
        return technologyScope;
    }

    public TechnologyScope getTechnologyScope() {
        return TechnologyScopeConfiguration.getTechnologyScope(this.getTechnologies());
    }

    public boolean setTechnologyScope(TechnologyScope technologyScope) {
        boolean bl = false;
        TechnologyScope technologyScope2 = this.getTechnologyScope();
        if (ModelUtil.areDifferent((Object)technologyScope2, (Object)technologyScope)) {
            String[] stringArray = technologyScope != null ? technologyScope.getTechnologyKeys() : null;
            ListStructure listStructure = this.getTechnologies();
            if (stringArray != null && stringArray.length > 0) {
                List<String> list = Arrays.asList(stringArray);
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    if (list.contains(iterator.next())) continue;
                    iterator.remove();
                    bl = true;
                }
                for (String string : list) {
                    if (string == null || listStructure.contains((Object)string)) continue;
                    listStructure.add((Object)string);
                    bl = true;
                }
            } else if (listStructure.size() > 0) {
                listStructure.clear();
                bl = true;
            }
        }
        return bl;
    }

    public final boolean updateTechnologyScope(String[] stringArray) {
        boolean bl = false;
        TechnologyScope technologyScope = this.getTechnologyScope();
        if (technologyScope != null && !technologyScope.isEmpty() && stringArray != null) {
            TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
            int n = 0;
            while (n < stringArray.length) {
                TechId techId = technologyRegistry.getTechId(stringArray[n]);
                if (techId != null && !technologyScope.contains(techId)) {
                    technologyScope.add(techId);
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            this.setTechnologyScope(technologyScope);
        }
        return bl;
    }

    static TechnologyScope maS$getTechnologyScope(ListStructure listStructure) {
        return TechnologyScopeConfiguration.getTechnologyScope(listStructure);
    }

    public static final class 1
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            ChangeInfo changeInfo = projectChangeEvent.getChangeDetails()[0];
            String string = changeInfo.getPropertyName();
            if (changeInfo.isEventForList(TECHNOLOGY_SCOPE_KEY)) {
                ListStructure listStructure = changeInfo.getParentAsListStructure();
                TechnologyScope technologyScope = TechnologyScopeConfiguration.maS$getTechnologyScope(listStructure);
                TechnologyScope technologyScope2 = new TechnologyScope();
                technologyScope.copyTo(technologyScope2);
                String string2 = changeInfo.getOldValueAsString();
                String string3 = changeInfo.getNewValueAsString();
                switch (changeInfo.getChangeType()) {
                    case 1: 
                    case 2: {
                        technologyScope2.remove(TechnologyRegistry.getInstance().getTechId(string3));
                        break;
                    }
                    case 3: {
                        technologyScope2.add(TechnologyRegistry.getInstance().getTechId(string2));
                        break;
                    }
                    case 0: {
                        technologyScope2.remove(TechnologyRegistry.getInstance().getTechId(string3));
                        technologyScope2.add(TechnologyRegistry.getInstance().getTechId(string2));
                    }
                }
                Project project = projectChangeEvent.getProject();
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(project, TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_PROPERTY, technologyScope2, technologyScope);
                PropertyChangeEvent[] propertyChangeEventArray = new PropertyChangeEvent[]{propertyChangeEvent};
                UpdateMessage.firePropertiesChanged(project, propertyChangeEventArray, TechnologyScopeConfiguration.class);
            }
        }
    }
}

