/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.chararray.CharArrayCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.util.Log;

public class TextBufferTracker
extends NodeListener
implements TextBufferListener {
    private static Map instances;
    private static Edit[] NO_EDITS;
    private TextNode node;
    private int initialId;
    private int initialLength;
    private boolean reloading;
    private int removedOffset;
    private char[] removedText;
    private int version;
    private Edit[] edits;
    private static final Log LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = TextBufferTracker.class.desiredAssertionStatus() ^ true;
        instances = new HashMap();
        NO_EDITS = new Edit[0];
        LOG = new Log("tracker");
    }

    void $init$() {
        this.initialId = -1;
        this.initialLength = -1;
        this.reloading = false;
        this.version = 0;
        this.edits = NO_EDITS;
    }

    public static synchronized TextBufferTracker getTracker(TextNode textNode) {
        TextBufferTracker textBufferTracker;
        if (!$assertionsDisabled && !LOG.trace("getting tracker for {0}", (Object)textNode)) {
            throw new AssertionError();
        }
        WeakReference weakReference = (WeakReference)instances.get(textNode);
        if (weakReference != null && (textBufferTracker = (TextBufferTracker)weakReference.get()) != null) {
            return textBufferTracker;
        }
        TextBufferTracker textBufferTracker2 = new TextBufferTracker(textNode);
        instances.put(textNode, new WeakReference<TextBufferTracker>(textBufferTracker2));
        return textBufferTracker2;
    }

    private TextBufferTracker(TextNode textNode) {
        this.$init$();
        boolean bl = textNode.isOpen();
        if (!$assertionsDisabled && !LOG.trace("creating tracker for {1}, open {0}", bl, (Object)textNode)) {
            throw new AssertionError();
        }
        this.node = textNode;
        textNode.addNodeListener(this);
        if (bl) {
            this.nodeOpened(null);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public boolean adjustOffsetLength(int n, int n2, int n3, int[] nArray) {
        boolean bl = false;
        int n4 = n3;
        while (n4 < this.version) {
            Edit edit = this.edits[n4];
            if (edit.offset <= n + n2) {
                if (edit.delta >= 0) {
                    if (edit.offset <= n) {
                        n += edit.delta;
                    } else {
                        n2 += edit.delta;
                        bl = true;
                    }
                } else {
                    int n5 = edit.delta;
                    int n6 = edit.offset - n5;
                    if (edit.offset <= n) {
                        if (n6 <= n) {
                            n += n5;
                        } else {
                            int n7 = n6 - n;
                            n += n5 + n7;
                            if ((n2 -= n7) < 0) {
                                n2 = 0;
                            }
                            bl = true;
                        }
                    } else {
                        int n8 = n + n2;
                        if (n6 <= n8) {
                            n2 += n5;
                        } else {
                            int n9 = n6 - n8;
                            if ((n2 -= n9) < 0) {
                                n2 = 0;
                            }
                        }
                        bl = true;
                    }
                }
            }
            ++n4;
        }
        nArray[0] = n;
        nArray[1] = n2;
        return bl;
    }

    public boolean isModified(int n) {
        return this.id(n) != this.id(this.version);
    }

    public boolean isModified(int n, int n2, int n3) {
        return this.adjustOffsetLength(n, n2, n3, new int[]{n, n2});
    }

    public String toString() {
        return "tracker " + this.node + ", version " + this.version + ", id " + this.id(this.version) + ", length " + this.length(this.version);
    }

    public void nodeOpened(NodeEvent nodeEvent) {
        if (!$assertionsDisabled && !LOG.trace("tracked node opened {0}", (Object)this.node)) {
            throw new AssertionError();
        }
        TextBuffer textBuffer = this.node.acquireTextBuffer();
        if (this.version == 0) {
            this.initialId = textBuffer.getChangeId();
            this.initialLength = textBuffer.getLength();
        }
        textBuffer.addTextBufferListener((TextBufferListener)this);
        if (!$assertionsDisabled && !LOG.trace("started tracking {0}", (Object)this)) {
            throw new AssertionError();
        }
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        LOG.trace("tracked node closed {0}", (Object)this.node);
        this.node.removeTextBufferListener(this);
        this.reloading = false;
        this.removedText = null;
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
        switch (n) {
            case 1: {
                if (!$assertionsDisabled && !LOG.trace("buffer EOL changed in {1} ({0})", textBuffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                break;
            }
            case 5: {
                if (!$assertionsDisabled && !LOG.trace("buffer modified changed in {1} ({0}) to {2}", textBuffer.getChangeId(), (Object)this, (Object)textBuffer.isModified())) {
                    throw new AssertionError();
                }
                break;
            }
            case 2: {
                if (!$assertionsDisabled && !LOG.trace("buffer read-only changed in {1} ({0}) to {2}", textBuffer.getChangeId(), (Object)this, (Object)textBuffer.isReadOnly())) {
                    throw new AssertionError();
                }
                break;
            }
            case 3: {
                if (!$assertionsDisabled && !LOG.trace("buffer reload start in {1} ({0})", textBuffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                this.reloading = true;
                break;
            }
            case 4: {
                if (!$assertionsDisabled && !LOG.trace("buffer reload end in {1} ({1})", textBuffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                if (this.removedText != null) {
                    this.textEdited(textBuffer, this.removedOffset, -this.removedText.length);
                }
                this.reloading = false;
                this.removedText = null;
                break;
            }
            default: {
                LOG.trace("changed {0} in {1}", n, (Object)this);
            }
        }
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        if (this.reloading) {
            this.reloading = false;
            if (this.removedText != null) {
                if (!$assertionsDisabled && !LOG.trace("normal reload: inserting {0} at {1} in {3} ({2})", n2, n, textBuffer.getChangeId(), (Object)this)) {
                    throw new AssertionError();
                }
                this.replaceText(textBuffer, this.removedText, 0, this.removedText.length, cArray);
                this.removedText = null;
            } else {
                int n3 = this.length(this.version);
                if (n3 > 0) {
                    if (!$assertionsDisabled && !LOG.trace("gc reload: inserting {0} at {1} in {3} ({2})", n2, n, textBuffer.getChangeId(), (Object)this)) {
                        throw new AssertionError();
                    }
                    int n4 = textBuffer.getLength() - n3;
                    if (n4 != 0) {
                        this.textEdited(textBuffer, 0, n4);
                    }
                } else {
                    if (!$assertionsDisabled && !LOG.trace("normal load: inserting {0} at {1} in {3} ({2})", n2, n, textBuffer.getChangeId(), (Object)this)) {
                        throw new AssertionError();
                    }
                    this.textEdited(textBuffer, n, n2);
                }
            }
        } else {
            this.textEdited(textBuffer, n, n2);
            if (!$assertionsDisabled && textBuffer.getLength() != this.derivedLength()) {
                throw new AssertionError();
            }
        }
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        if (!$assertionsDisabled && !LOG.trace("removing {0} at {1} in {3} ({2})", n2, n, textBuffer.getChangeId(), (Object)this.node)) {
            throw new AssertionError();
        }
        if (this.reloading) {
            this.removedText = cArray;
            this.removedOffset = n;
        } else {
            this.textEdited(textBuffer, n, -n2);
            if (!$assertionsDisabled && textBuffer.getLength() != this.derivedLength()) {
                throw new AssertionError();
            }
        }
    }

    private void textEdited(TextBuffer textBuffer, int n, int n2) {
        if (this.version == this.edits.length) {
            this.edits = new Edit[this.version * 2 + 4];
            System.arraycopy(this.edits, 0, this.edits, 0, this.version);
        }
        this.edits[this.version++] = new Edit(n, n2, textBuffer.getChangeId(), textBuffer.getLength());
    }

    private int derivedLength() {
        int[] nArray = new int[2];
        this.adjustOffsetLength(this.initialLength, 0, 0, nArray);
        return nArray[0];
    }

    private int id(int n) {
        if (n == 0) {
            return this.initialId;
        }
        return this.edits[n - 1].id;
    }

    private int length(int n) {
        if (n == 0) {
            return this.initialLength;
        }
        return this.edits[n - 1].length;
    }

    public void replaceText(TextBuffer textBuffer, char[] cArray, int n, int n2, char[] cArray2) {
        SequenceCompareModel sequenceCompareModel;
        if (n2 > 0 && cArray2.length > 0 && (sequenceCompareModel = CharArrayCompareAlgorithm.compare((char[])cArray, (char[])cArray2)) != null) {
            DifferenceBlock[] differenceBlockArray = sequenceCompareModel.getDifferenceBlocks();
            int n3 = differenceBlockArray.length;
            if (n3 > 0) {
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    DifferenceBlock differenceBlock = differenceBlockArray[n4];
                    int n5 = differenceBlock.getStart(ContributorKind.FIRST);
                    int n6 = differenceBlock.getLength(ContributorKind.FIRST);
                    int n7 = differenceBlock.getLength(ContributorKind.SECOND);
                    if (n6 > 0) {
                        this.textEdited(textBuffer, n5 + n, -n6);
                    }
                    if (n7 > 0) {
                        this.textEdited(textBuffer, n5 + n, n7);
                    }
                    --n4;
                }
            }
            return;
        }
        if (n2 > 0) {
            this.textEdited(textBuffer, n, -n2);
        }
        if (cArray2.length > 0) {
            this.textEdited(textBuffer, n, cArray2.length);
        }
    }

    private static class Edit {
        public int offset;
        public int delta;
        public int id;
        public int length;

        public Edit(int n, int n2, int n3, int n4) {
            this.offset = n;
            this.delta = n2;
            this.id = n3;
            this.length = n4;
        }

        public String toString() {
            return "{" + this.delta + " at " + this.offset + " (length " + this.length + ", id" + this.id + ")}";
        }
    }
}

