/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.ide.util.WeakDataHolder;
import oracle.ide.util.WeakDataReference;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.Utilities;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Log;

public class TextNode
extends Node {
    private String _loadEncoding;
    private String _saveEncoding;
    private WeakDataReference _wrapperReference;
    private static final Log LOG;
    private TextBuffer _realTextBuffer;
    private TextBufferListener _forwarder;
    private Object _undoState;
    private Object _bufferLock;
    private boolean _isLoading;
    private TextBuffer _pinnedWrapper;
    private int _pinnedCount;
    static final /* synthetic */ boolean $assertionsDisabled;
    private boolean _isReadOnly;
    private WeakDataHolder _weakHolder;
    private CopyOnWriteList _listeners;
    private List _offsetMarks;

    public TextNode() {
        this(null);
    }

    public TextNode(URL uRL) {
        super(uRL);
        this.$init$();
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.PRINTABLE);
    }

    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            return textBuffer.isModified();
        }
        return false;
    }

    public void markDirty(boolean bl) {
        TextBuffer textBuffer;
        super.markDirty(bl);
        if (!bl && (textBuffer = this.getTextBufferDirectly()) != null) {
            textBuffer.clearModified();
        }
    }

    protected void openImpl() throws IOException {
        this.openTextBuffer();
    }

    protected void reportOpenException(Exception exception) {
        super.reportOpenException(exception);
        String string = ModelArb.format(48, this.getURL());
        if (!Ide.getIdeArgs().getCreateUI()) {
            System.err.println(string);
            exception.printStackTrace();
            return;
        }
        4 var3_3 = new 4(this, exception, string);
        if (SwingUtilities.isEventDispatchThread()) {
            var3_3.run();
        } else {
            SwingUtilities.invokeLater(var3_3);
        }
    }

    protected void closeImpl() throws IOException {
        this.closeTextBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImpl() throws IOException {
        boolean bl = this.isNew();
        if (this.isDirty() || bl) {
            TextBuffer textBuffer;
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            URL[] uRLArray = new URL[]{this.getURL()};
            if (historyManager != null && !bl) {
                try {
                    historyManager.persistInitialState(uRLArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Object object = this._bufferLock;
            synchronized (object) {
                textBuffer = this.lookupTextBuffer();
                if (textBuffer == null) {
                    throw new IllegalStateException("on save, no buffer available");
                }
            }
            OutputStream outputStream = null;
            Writer writer = null;
            try {
                URL uRL = this.getURL();
                outputStream = URLFileSystem.openOutputStream(uRL);
                writer = this.createOutputStreamWriter(outputStream);
                textBuffer.write(writer);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    } else if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (historyManager != null) {
                try {
                    String string = bl ? IdeArb.getString(24) : IdeArb.getString(59);
                    historyManager.persist(uRLArray, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void revertImpl() throws IOException {
        this.revertTextBuffer();
    }

    static {
        $assertionsDisabled = TextNode.class.desiredAssertionStatus() ^ true;
        LOG = new Log("tracker");
        3 var0 = new 3();
    }

    void $init$() {
        this._bufferLock = new Object();
        this._isLoading = false;
        this._pinnedWrapper = null;
        this._pinnedCount = 0;
        this._isReadOnly = false;
        this._weakHolder = new 1();
        this._listeners = new CopyOnWriteList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer lookupTextBuffer() {
        Object object = this._bufferLock;
        synchronized (object) {
            if (this._wrapperReference != null) {
                TextBuffer textBuffer = (TextBuffer)this._wrapperReference.get();
                return textBuffer;
            }
        }
        return null;
    }

    private boolean isTextBufferExpired() {
        return this.isOpen() && this.lookupTextBuffer() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoading() {
        Object object = this._bufferLock;
        synchronized (object) {
            boolean bl = this._isLoading;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLoading(boolean bl) {
        Object object = this._bufferLock;
        synchronized (object) {
            this._isLoading = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pin() {
        Object object = this._bufferLock;
        synchronized (object) {
            ++this._pinnedCount;
            this._pinnedWrapper = this.lookupTextBuffer();
        }
    }

    private boolean pinRequested() {
        return this._pinnedCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpin() {
        Object object = this._bufferLock;
        synchronized (object) {
            --this._pinnedCount;
            if (this._pinnedCount == 0) {
                this._pinnedWrapper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer setupTextBuffer() {
        Object object = this._bufferLock;
        synchronized (object) {
            ReadWriteLock readWriteLock = this._getReadWriteLockInternal();
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer((ReadWriteLock)readWriteLock);
            this.setDefaultLineTerminator(textBuffer);
            this._realTextBuffer = textBuffer;
            TextBufferWrapper textBufferWrapper = this.setupTextBufferWrapper();
            if (this._forwarder == null) {
                this._forwarder = new TextBufferForwarder(this);
            }
            textBuffer.addTextBufferListener(this._forwarder);
            TextBufferWrapper textBufferWrapper2 = textBufferWrapper;
            return textBufferWrapper2;
        }
    }

    private TextBufferWrapper setupTextBufferWrapper() {
        TextBufferWrapper textBufferWrapper = new TextBufferWrapper(this, this._realTextBuffer);
        this._wrapperReference = new WeakDataReference(this._weakHolder, textBufferWrapper);
        if (!$assertionsDisabled && !LOG.trace("created buffer wrapper for {2}, id {0}, length {1}", textBufferWrapper.getChangeId(), textBufferWrapper.getLength(), (Object)this)) {
            throw new AssertionError();
        }
        if (this.pinRequested()) {
            this._pinnedWrapper = textBufferWrapper;
        }
        return textBufferWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTextBuffer() {
        Object object = this._bufferLock;
        synchronized (object) {
            TextBuffer textBuffer = this.lookupTextBuffer();
            if (this._forwarder != null && textBuffer instanceof TextBufferWrapper) {
                TextBuffer textBuffer2 = TextBufferWrapper.mav$getRealTextBuffer((TextBufferWrapper)textBuffer);
                textBuffer2.removeTextBufferListener(this._forwarder);
            }
            if (this._wrapperReference != null) {
                this._wrapperReference.clear();
            }
            this._wrapperReference = null;
            this._listeners.clear();
            if (this._offsetMarks != null) {
                this._offsetMarks.clear();
                this._offsetMarks = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTextBuffer() {
        Object object = this._bufferLock;
        synchronized (object) {
            this.detachUndoState();
            this.clearTextBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openTextBuffer() throws IOException {
        Object object = this._bufferLock;
        synchronized (object) {
            TextBuffer textBuffer = this.lookupTextBuffer();
            if (textBuffer != null) {
                // empty if block
            }
            textBuffer = this.setupTextBuffer();
            this.loadTextBuffer(textBuffer);
            this.attachUndoState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revertTextBuffer() throws IOException {
        TextBuffer textBuffer;
        Object object = this._bufferLock;
        synchronized (object) {
            textBuffer = this.lookupTextBuffer();
            if (textBuffer == null) {
                if (!$assertionsDisabled && !LOG.trace("reverting gc'd text buffer for {0}, undo {1}", (Object)this, this._undoState)) {
                    throw new AssertionError();
                }
                textBuffer = this.setupTextBuffer();
                this.loadTextBuffer(textBuffer);
                return;
            }
        }
        if (!$assertionsDisabled && !LOG.trace("reverting buffer {0} for {1}", System.identityHashCode(textBuffer), (Object)this)) {
            throw new AssertionError();
        }
        this.loadTextBuffer(textBuffer);
        this._undoState = null;
    }

    private void loadTextBuffer(TextBuffer textBuffer) throws IOException {
        this.setLoading(true);
        try {
            this.refreshTimestamp();
            try {
                this.loadTextBufferData(textBuffer);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                if (!textBuffer.isReadOnly()) {
                    textBuffer.removeToEnd(0);
                }
                throw iOException;
            }
            if (textBuffer.isReadOnly() != super.isReadOnly()) {
                textBuffer.setReadOnly(super.isReadOnly());
            }
        }
        finally {
            textBuffer.clearModified();
            this.setLoading(false);
        }
    }

    private void loadTextBufferData(TextBuffer textBuffer) throws IOException {
        URL uRL = this.getURL();
        if (uRL == null) {
            throw new NullPointerException("null URL, cannot load data");
        }
        Reader reader = null;
        try {
            reader = this.createReader(uRL);
            textBuffer.read(reader);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachUndoState() {
        Object object = this._bufferLock;
        synchronized (object) {
            if (this._realTextBuffer != null) {
                this._undoState = Utilities.detachUndoState((TextBuffer)this._realTextBuffer);
                LOG.trace("detaching undo state for {0}: {1}", (Object)this, this._undoState);
                this._realTextBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachUndoState() {
        Object object = this._bufferLock;
        synchronized (object) {
            if (this._undoState != null && this._realTextBuffer != null) {
                boolean bl = Utilities.attachUndoState((TextBuffer)this._realTextBuffer, (Object)this._undoState);
                if (!$assertionsDisabled && !LOG.trace("attaching undo state {0} for {1}, success {2}", this._undoState, (Object)this, (Object)bl)) {
                    throw new AssertionError();
                }
                this._undoState = null;
                boolean bl2 = bl;
                return bl2;
            }
        }
        return false;
    }

    private void purgeTextBuffer() {
        if (!$assertionsDisabled && !LOG.trace("purging buffer reference {0} for {1}", (Object)this._wrapperReference, (Object)this)) {
            throw new AssertionError();
        }
        this.detachUndoState();
        if (this._wrapperReference != null) {
            this._wrapperReference.clear();
        }
    }

    private void restoreTextBuffer() {
        this.pin();
        try {
            try {
                if (this._realTextBuffer != null) {
                    this.setupTextBufferWrapper();
                    this.unpin();
                    return;
                }
                TextBuffer textBuffer = this.setupTextBuffer();
                this.loadTextBuffer(textBuffer);
                boolean bl = this.attachUndoState();
                if (!bl) {
                    this.revert();
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            this.unpin();
        }
    }

    protected void setDefaultLineTerminator(TextBuffer textBuffer) {
        int n;
        try {
            EnvironOptions environOptions = Ide.getEnvironOptions();
            n = environOptions.getLineTerminator();
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        switch (n) {
            case 1: {
                textBuffer.setEOLType("\r\n");
                break;
            }
            case 2: {
                textBuffer.setEOLType("\n");
                break;
            }
            case 3: {
                textBuffer.setEOLType("\r");
                break;
            }
        }
    }

    protected OutputStreamWriter createOutputStreamWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return new OutputStreamWriter(outputStream, this.getSaveEncoding());
    }

    public boolean setReadOnly(boolean bl) {
        URL uRL = this.getURL();
        if (uRL != null) {
            return URLFileSystem.setReadOnly(uRL, bl);
        }
        return false;
    }

    public boolean isReadOnly() {
        boolean bl = super.isReadOnly();
        if (this.isOpen()) {
            this.updateReadOnlyFlag(bl);
        }
        if (bl != this._isReadOnly) {
            this._isReadOnly = bl;
            Attributes attributes = this.getAttributes();
            if (bl) {
                attributes.set(ElementAttributes.READ_ONLY);
            } else {
                attributes.unset(ElementAttributes.READ_ONLY);
            }
            Attributes attributes2 = attributes.duplicate();
            2 var4_4 = new 2(this, attributes2);
            if (SwingUtilities.isEventDispatchThread()) {
                var4_4.run();
            } else {
                SwingUtilities.invokeLater(var4_4);
            }
        }
        return bl;
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(true);
    }

    public InputStream getInputStream(boolean bl) throws IOException {
        TextBuffer textBuffer;
        if (bl) {
            // empty if block
        }
        if ((textBuffer = this.acquireTextBuffer()) != null) {
            return TextBufferStreamFactory.getInputStream(textBuffer, this.getSaveEncoding());
        }
        throw new IllegalStateException("getInputStream(): null text buffer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer getTextBufferImpl() {
        TextBuffer textBuffer = this.lookupTextBuffer();
        if (textBuffer != null) {
            return textBuffer;
        }
        try {
            this.pin();
            this.ensureOpen();
            textBuffer = this.lookupTextBuffer();
            if (textBuffer != null) {
                TextBuffer textBuffer2 = textBuffer;
                this.unpin();
                return textBuffer2;
            }
            ReadWriteLock readWriteLock = this._getReadWriteLockInternal();
            readWriteLock.writeLock();
            try {
                textBuffer = this.lookupTextBuffer();
                if (textBuffer != null) {
                    TextBuffer textBuffer3 = textBuffer;
                    readWriteLock.writeUnlock();
                    this.unpin();
                    return textBuffer3;
                }
                Object object = this._bufferLock;
                synchronized (object) {
                    this.restoreTextBuffer();
                }
                TextBuffer textBuffer4 = this.lookupTextBuffer();
                readWriteLock.writeUnlock();
                this.unpin();
                return textBuffer4;
            }
            catch (Throwable throwable) {
                readWriteLock.writeUnlock();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.unpin();
            throw throwable;
        }
    }

    public final TextBuffer acquireTextBuffer() {
        TextBuffer textBuffer = this.getTextBufferDirectly();
        return textBuffer != null ? textBuffer : this.getTextBufferImpl();
    }

    public final void releaseTextBuffer() {
    }

    protected TextBuffer getTextBufferDirectly() {
        TextBuffer textBuffer;
        if (this.isOpen() && (textBuffer = this.lookupTextBuffer()) != null) {
            return textBuffer;
        }
        return null;
    }

    public void removeTextBufferListener(TextBufferListener textBufferListener) {
        this._listeners.remove((Object)textBufferListener);
    }

    public void setLoadEncoding(String string) {
        this._loadEncoding = string;
    }

    public void setSaveEncoding(String string) {
        this._saveEncoding = string;
    }

    protected void dataExpired() {
    }

    public Reader getReader() throws IOException {
        TextBuffer textBuffer = this.acquireTextBuffer();
        if (textBuffer != null) {
            return TextBufferFactory.createReader((ReadTextBuffer)textBuffer);
        }
        throw new IllegalStateException("getReader(): null text buffer");
    }

    public boolean hasEmptyTextBuffer() {
        TextBuffer textBuffer = this.acquireTextBuffer();
        boolean bl = textBuffer.getLength() <= 0;
        this.releaseTextBuffer();
        return bl;
    }

    protected void updateReadOnlyFlag(boolean bl) {
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null && textBuffer.isReadOnly() != bl) {
            textBuffer.setReadOnly(bl);
        }
    }

    public String getLoadEncoding() {
        return this._loadEncoding != null ? this._loadEncoding : IdeUtil.getIdeEncoding();
    }

    public String getSaveEncoding() {
        return this._saveEncoding != null ? this._saveEncoding : IdeUtil.getIdeEncoding();
    }

    protected Reader createReader(URL uRL) throws IOException {
        return URLFileSystem.createReader(uRL, this.getLoadEncoding());
    }

    static boolean mav$isTextBufferExpired(TextNode textNode) {
        return textNode.isTextBufferExpired();
    }

    static Object ra$_bufferLock(TextNode textNode) {
        return textNode._bufferLock;
    }

    static WeakDataReference ra$_wrapperReference(TextNode textNode) {
        return textNode._wrapperReference;
    }

    static void mav$purgeTextBuffer(TextNode textNode) {
        textNode.purgeTextBuffer();
    }

    static CopyOnWriteList ra$_listeners(TextNode textNode) {
        return textNode._listeners;
    }

    static List ra$_offsetMarks(TextNode textNode) {
        return textNode._offsetMarks;
    }

    static void wa$_offsetMarks(TextNode textNode, List list) {
        textNode._offsetMarks = list;
    }

    static boolean mav$isLoading(TextNode textNode) {
        return textNode.isLoading();
    }

    static void mav$pin(TextNode textNode) {
        textNode.pin();
    }

    static void mav$unpin(TextNode textNode) {
        textNode.unpin();
    }

    static TextBuffer mav$lookupTextBuffer(TextNode textNode) {
        return textNode.lookupTextBuffer();
    }

    static Log ra$LOG() {
        return LOG;
    }

    public final class 4
    implements Runnable {
        private final /* synthetic */ Exception v$e;
        private final /* synthetic */ String v$message;
        final /* synthetic */ TextNode this$0;

        public void run() {
            ExceptionDialog.showExceptionDialog(IdeUtil.getMainWindow(), this.v$e, ModelArb.getString(47), this.v$message);
        }

        public 4(TextNode textNode, Exception exception, String string) {
            this.v$message = string;
            this.v$e = exception;
            this.this$0 = textNode;
        }
    }

    public static final class 3
    implements Runnable {
        public void run() {
            System.setProperty("buffer.deadlock.detection", "true");
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ Attributes v$oldAttributes;
        final /* synthetic */ TextNode this$0;

        public void run() {
            UpdateMessage.fireAttributeChanged(this.this$0, this.v$oldAttributes);
        }

        public 2(TextNode textNode, Attributes attributes) {
            this.v$oldAttributes = attributes;
            this.this$0 = textNode;
        }
    }

    public final class 1
    implements WeakDataHolder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dataExpired(WeakDataReference weakDataReference) {
            ReadWriteLock readWriteLock = TextNode.this._getReadWriteLockInternal();
            readWriteLock.writeLock();
            try {
                Object object = TextNode.ra$_bufferLock(TextNode.this);
                synchronized (object) {
                    if (weakDataReference != null && weakDataReference == TextNode.ra$_wrapperReference(TextNode.this)) {
                        TextNode.mav$purgeTextBuffer(TextNode.this);
                        TextNode.this.dataExpired();
                    }
                }
            }
            finally {
                readWriteLock.writeUnlock();
            }
        }

        public boolean isExpired() {
            return TextNode.mav$isTextBufferExpired(TextNode.this);
        }
    }

    private static final class TextBufferWrapper
    implements TextBuffer {
        private TextNode _node;
        private TextBuffer _textBuffer;

        public TextBufferWrapper(TextNode textNode, TextBuffer textBuffer) {
            Iterator iterator;
            this._node = textNode;
            this._textBuffer = textBuffer;
            Iterator iterator2 = iterator = TextNode.ra$_offsetMarks(this._node) != null ? TextNode.ra$_offsetMarks(this._node).iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    OffsetMarkWrapper offsetMarkWrapper = (OffsetMarkWrapper)iterator.next();
                    OffsetMark offsetMark = textBuffer.addOffsetMark(offsetMarkWrapper.getOffset(), offsetMarkWrapper.getBias());
                    offsetMarkWrapper.setOffsetMark(offsetMark);
                }
            }
        }

        public OffsetMark addOffsetMark(int n) {
            return this.addOffsetMark(n, true);
        }

        public OffsetMark addOffsetMark(int n, boolean bl) {
            OffsetMark offsetMark = this._textBuffer.addOffsetMark(n, bl);
            if (offsetMark != null) {
                OffsetMarkWrapper offsetMarkWrapper = new OffsetMarkWrapper(offsetMark);
                if (TextNode.ra$_offsetMarks(this._node) == null) {
                    TextNode.wa$_offsetMarks(this._node, new LinkedList());
                }
                TextNode.ra$_offsetMarks(this._node).add(offsetMarkWrapper);
                offsetMark = offsetMarkWrapper;
            }
            return offsetMark;
        }

        public void removeOffsetMark(OffsetMark offsetMark) {
            if (offsetMark == null) {
                return;
            }
            if (TextNode.ra$_offsetMarks(this._node) != null && TextNode.ra$_offsetMarks(this._node).remove(offsetMark)) {
                this._textBuffer.removeOffsetMark(((OffsetMarkWrapper)offsetMark)._offsetMark);
            }
        }

        public void addTextBufferListener(TextBufferListener textBufferListener) {
            if (textBufferListener == null) {
                return;
            }
            boolean bl = TextNode.ra$_listeners(this._node).addIfAbsent((Object)textBufferListener);
        }

        public UndoableEdit append(char[] cArray) throws IndexOutOfBoundsException, ReadOnlyException {
            return this._textBuffer.append(cArray);
        }

        public void beginEdit() throws ReadOnlyException {
            this._textBuffer.beginEdit();
        }

        public void clearModified() {
            this._textBuffer.clearModified();
        }

        public UndoableEdit endEdit() {
            return this._textBuffer.endEdit();
        }

        public int getChangeId() {
            return this._textBuffer.getChangeId();
        }

        public String getEOLType() {
            return this._textBuffer.getEOLType();
        }

        public LineMap getLineMap() {
            return this._textBuffer.getLineMap();
        }

        public String getPlatformEOLType() {
            return this._textBuffer.getPlatformEOLType();
        }

        public UndoableEdit insert(int n, char[] cArray) throws IndexOutOfBoundsException, ReadOnlyException {
            return this._textBuffer.insert(n, cArray);
        }

        public UndoableEdit insert(int n, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
            return this._textBuffer.insert(n, reader);
        }

        public boolean isModified() {
            return this._textBuffer.isModified();
        }

        public boolean isReadOnly() {
            return this._textBuffer.isReadOnly();
        }

        public void read(Reader reader) throws IOException {
            this._textBuffer.read(reader);
        }

        public UndoableEdit remove(int n, int n2) throws IndexOutOfBoundsException, ReadOnlyException {
            return this._textBuffer.remove(n, n2);
        }

        public void removeTextBufferListener(TextBufferListener textBufferListener) {
            if (textBufferListener == null) {
                return;
            }
            boolean bl = TextNode.ra$_listeners(this._node).remove((Object)textBufferListener);
        }

        public UndoableEdit removeToEnd(int n) throws IndexOutOfBoundsException, ReadOnlyException {
            return this._textBuffer.removeToEnd(n);
        }

        public void setEOLType(String string) throws ReadOnlyException {
            this._textBuffer.setEOLType(string);
        }

        public void setReadOnly(boolean bl) {
            this._textBuffer.setReadOnly(bl);
        }

        public void write(Writer writer) throws IOException {
            this._textBuffer.write(writer);
        }

        public void write(Writer writer, boolean bl) throws IOException {
            this._textBuffer.write(writer, bl);
        }

        public int getLength() {
            return this._textBuffer.getLength();
        }

        public char getChar(int n) throws IndexOutOfBoundsException {
            return this._textBuffer.getChar(n);
        }

        public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
            return this._textBuffer.getChars(n, n2);
        }

        public String getString(int n, int n2) throws IndexOutOfBoundsException {
            return this._textBuffer.getString(n, n2);
        }

        public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
            this._textBuffer.getText(n, n2, segment);
        }

        public void writeLock() throws ReadOnlyException {
            this._textBuffer.writeLock();
        }

        public boolean tryWriteLock() throws ReadOnlyException {
            return this._textBuffer.tryWriteLock();
        }

        public void writeUnlock() {
            this._textBuffer.writeUnlock();
        }

        public void readLock() {
            this._textBuffer.readLock();
        }

        public int getLockStatus() {
            return this._textBuffer.getLockStatus();
        }

        public boolean tryReadLock() {
            return this._textBuffer.tryReadLock();
        }

        public void readUnlock() {
            this._textBuffer.readUnlock();
        }

        private TextBuffer getRealTextBuffer() {
            return this._textBuffer;
        }

        static TextBuffer mav$getRealTextBuffer(TextBufferWrapper textBufferWrapper) {
            return textBufferWrapper.getRealTextBuffer();
        }
    }

    private static final class TextBufferForwarder
    implements TextBufferListener {
        private TextNode _node;
        private boolean pinned;

        public TextBufferForwarder(TextNode textNode) {
            this.$init$();
            this._node = textNode;
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            TextBuffer textBuffer2;
            if (!TextNode.mav$isLoading(this._node)) {
                this._node.setTimestampDirectly(System.currentTimeMillis());
            }
            if ((textBuffer2 = TextNode.mav$lookupTextBuffer(this._node)) == null) {
                TextNode.ra$LOG().trace("insert without referents into {0}", (Object)this._node);
                return;
            }
            for (TextBufferListener textBufferListener : TextNode.ra$_listeners(this._node)) {
                textBufferListener.insertUpdate(textBuffer2, n, n2, cArray);
            }
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            TextBuffer textBuffer2;
            if (!TextNode.mav$isLoading(this._node)) {
                this._node.setTimestampDirectly(System.currentTimeMillis());
            }
            if ((textBuffer2 = TextNode.mav$lookupTextBuffer(this._node)) == null) {
                TextNode.ra$LOG().trace("remove without referents into {0}", (Object)this._node);
                return;
            }
            for (TextBufferListener textBufferListener : TextNode.ra$_listeners(this._node)) {
                textBufferListener.removeUpdate(textBuffer2, n, n2, cArray);
            }
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
            TextBuffer textBuffer2;
            if (!TextNode.mav$isLoading(this._node) && n == 5) {
                boolean bl = textBuffer.isModified();
                this._node.markDirty(bl);
                if (bl && !this.pinned) {
                    TextNode.mav$pin(this._node);
                    this.pinned = true;
                } else if (!bl && this.pinned) {
                    TextNode.mav$unpin(this._node);
                    this.pinned = false;
                }
            }
            if ((textBuffer2 = TextNode.mav$lookupTextBuffer(this._node)) == null) {
                TextNode.ra$LOG().trace("attribute updated without referents into {0}", (Object)this._node);
            }
            for (TextBufferListener textBufferListener : TextNode.ra$_listeners(this._node)) {
                textBufferListener.attributeUpdate(textBuffer2, n);
            }
        }

        void $init$() {
            this.pinned = false;
        }
    }

    private static final class OffsetMarkWrapper
    implements OffsetMark {
        OffsetMark _offsetMark;

        public OffsetMarkWrapper(OffsetMark offsetMark) {
            this._offsetMark = offsetMark;
        }

        public void setOffsetMark(OffsetMark offsetMark) {
            this._offsetMark = offsetMark;
        }

        public int getOffset() {
            return this._offsetMark != null ? this._offsetMark.getOffset() : -1;
        }

        public void setOffset(int n) {
            if (this._offsetMark != null) {
                this._offsetMark.setOffset(n);
            }
        }

        public boolean getBias() {
            return this._offsetMark != null ? this._offsetMark.getBias() : true;
        }

        public void setBias(boolean bl) {
            if (this._offsetMark != null) {
                this._offsetMark.setBias(bl);
            }
        }
    }
}

