/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.exception.ChangeVetoException;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.VetoableSubject;

public final class UpdateMessage {
    private static int _lastMessageID = -1;
    private static String[] _debugStrings = new String[30];
    public static final int NO_MESSAGE = UpdateMessage.newMessageID("UpdateMessage.NO_MESSAGE");
    public static final int CHILD_REMOVED = UpdateMessage.newMessageID("UpdateMessage.CHILD_REMOVED");
    public static final int CHILD_ADDED = UpdateMessage.newMessageID("UpdateMessage.CHILD_ADDED");
    public static final int STRUCTURE_CHANGED = UpdateMessage.newMessageID("UpdateMessage.STRUCTURE_CHANGED");
    public static final int PROPERTY_SET = UpdateMessage.newMessageID("UpdateMessage.PROPERTY_SET");
    public static final int OBJECT_RENAMED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_RENAMED");
    public static final int CHILD_RENAMED = UpdateMessage.newMessageID("UpdateMessage.CHILD_RENAMED");
    public static final int OBJECT_CLOSED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_CLOSED");
    public static final int OBJECT_OPENED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_OPENED");
    public static final int OBJECT_RELOADED = UpdateMessage.newMessageID("UpdateMessage.OBJECT_RELOADED");
    public static final int ATTRIBUTE_CHANGED = UpdateMessage.newMessageID("UpdateMessage.ATTRIBUTE_CHANGED");
    public static final int OBJECT_CLOSING = UpdateMessage.newMessageID("UpdateMessage.OBJECT_CLOSING");
    public static final int CAN_REMOVE_CHILD = UpdateMessage.newMessageID("UpdateMessage.CAN_REMOVE_CHILD");
    public static final int CAN_ADD_CHILD = UpdateMessage.newMessageID("UpdateMessage.CAN_ADD_CHILD");
    public static final int CAN_RENAME_CHILD = UpdateMessage.newMessageID("UpdateMessage.CAN_RENAME_CHILD");
    public static final int CAN_CLOSE_OBJECT = UpdateMessage.newMessageID("UpdateMessage.CAN_CLOSE_OBJECT");
    public static final int CONTENT_MODIFIED = UpdateMessage.newMessageID("UpdateMessage.CONTENT_MODIFIED");
    public static final String COMMAND_ID_PROP = "Message.COMMAND_ID_PROP";
    private final int _messageID;
    private final Object _origin;
    private ArrayList _add;
    private ArrayList _remove;
    private ArrayList _modify;
    private Context _context;
    private final HashMap _hash;

    void $init$() {
        this._hash = new HashMap();
    }

    public UpdateMessage(int n, Object object) {
        this.$init$();
        if (n < 0 || n > _lastMessageID) {
            new IllegalArgumentException("UpdateMessage message ID is out of range: " + n).printStackTrace();
        }
        this._messageID = n;
        this._origin = object;
    }

    private UpdateMessage(UpdateMessage updateMessage, int n, Object object) {
        this(n, object);
        this._add = UpdateMessage.copyList(updateMessage._add);
        this._remove = UpdateMessage.copyList(updateMessage._remove);
        this._modify = UpdateMessage.copyList(updateMessage._modify);
        this._hash.putAll(updateMessage._hash);
        this._context = updateMessage._context != null ? new Context(updateMessage._context) : null;
    }

    private static ArrayList copyList(ArrayList arrayList) {
        return arrayList != null ? new ArrayList(arrayList) : null;
    }

    public final Object getProperty(String string) {
        return this._hash.get(string);
    }

    public final void setProperty(String string, Object object) {
        this._hash.put(string, object);
    }

    public final void removeProperty(String string) {
        this._hash.remove(string);
    }

    public final boolean containsProperty(String string) {
        return this._hash.containsKey(string);
    }

    public final int getMessageID() {
        return this._messageID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int newMessageID(String string) {
        Class<UpdateMessage> clazz = UpdateMessage.class;
        synchronized (UpdateMessage.class) {
            int n = ++_lastMessageID;
            int n2 = _debugStrings.length;
            if (n >= n2) {
                String[] stringArray = new String[n2 + 10];
                System.arraycopy(_debugStrings, 0, stringArray, 0, n2);
                _debugStrings = stringArray;
            }
            UpdateMessage._debugStrings[n] = string;
            int n3 = n;
            // ** MonitorExit[var4_1] (shouldn't be in output)
            return n3;
        }
    }

    public final Object getOrigin() {
        return this._origin;
    }

    public final List getAddObjects() {
        if (this._add == null) {
            this._add = new ArrayList();
        }
        return this._add;
    }

    public final List getRemoveObjects() {
        if (this._remove == null) {
            this._remove = new ArrayList();
        }
        return this._remove;
    }

    public final List getModifyObjects() {
        if (this._modify == null) {
            this._modify = new ArrayList();
        }
        return this._modify;
    }

    public final Context getContext() {
        return this._context;
    }

    public final void setContext(Context context) {
        this._context = context;
    }

    public final UpdateMessage copyMessage() {
        return new UpdateMessage(this, this.getMessageID(), this.getOrigin());
    }

    public final UpdateMessage forNewMessageID(int n) {
        return new UpdateMessage(this, n, this.getOrigin());
    }

    public final UpdateMessage forNewOrigin(Object object) {
        return new UpdateMessage(this, this.getMessageID(), object);
    }

    public static void fireChildAdded(Subject subject, Element element) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_ADDED, null);
        updateMessage.getAddObjects().add(element);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildrenAdded(Subject subject, Collection collection) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_ADDED, null);
        updateMessage.getAddObjects().addAll(collection);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildRemoved(Subject subject, Element element) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_REMOVED, null);
        updateMessage.getRemoveObjects().add(element);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireChildrenRemoved(Subject subject, Collection collection) {
        UpdateMessage updateMessage = new UpdateMessage(CHILD_REMOVED, null);
        updateMessage.getRemoveObjects().addAll(collection);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireStructureChanged(Subject subject, Collection collection) {
        UpdateMessage updateMessage = new UpdateMessage(STRUCTURE_CHANGED, null);
        updateMessage.getModifyObjects().addAll(collection);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireStructureChanged(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(STRUCTURE_CHANGED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void firePropertiesChanged(Subject subject, PropertyChangeEvent[] propertyChangeEventArray, Object object) {
        UpdateMessage updateMessage = new UpdateMessage(PROPERTY_SET, object);
        if (propertyChangeEventArray != null && propertyChangeEventArray.length > 0) {
            int n = propertyChangeEventArray.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeEvent propertyChangeEvent = propertyChangeEventArray[n2];
                String string = propertyChangeEvent.getPropertyName();
                if (string == null) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                int n3 = 0;
                while (n3 < n) {
                    PropertyChangeEvent propertyChangeEvent = propertyChangeEventArray[n3];
                    String string = propertyChangeEvent.getPropertyName();
                    updateMessage.setProperty(string, propertyChangeEvent);
                    ++n3;
                }
            }
        }
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectRenamed(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_RENAMED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectOpened(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_OPENED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectReloaded(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_RELOADED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireObjectClosed(Subject subject) {
        UpdateMessage updateMessage = new UpdateMessage(OBJECT_CLOSED, null);
        subject.notifyObservers(subject, updateMessage);
    }

    public static void fireAttributeChanged(Subject subject, Attributes attributes) {
        UpdateMessage updateMessage = new UpdateMessage(ATTRIBUTE_CHANGED, null);
        updateMessage.getModifyObjects().add(attributes);
        UpdateMessage.notifyObserversOnEventThread(subject, updateMessage);
    }

    public static void fireCanAddChild(VetoableSubject vetoableSubject, Object object) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_ADD_CHILD, null);
        updateMessage.getAddObjects().add(object);
        vetoableSubject.notifyVetoObservers(vetoableSubject, updateMessage);
    }

    public static void fireCanAddChildren(VetoableSubject vetoableSubject, Collection collection) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_ADD_CHILD, null);
        updateMessage.getAddObjects().addAll(collection);
        vetoableSubject.notifyVetoObservers(vetoableSubject, updateMessage);
    }

    public static void fireCanRemoveChild(VetoableSubject vetoableSubject, Object object) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_REMOVE_CHILD, null);
        updateMessage.getRemoveObjects().add(object);
        vetoableSubject.notifyVetoObservers(vetoableSubject, updateMessage);
    }

    public static void fireCanRemoveChildren(VetoableSubject vetoableSubject, Collection collection) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_REMOVE_CHILD, null);
        updateMessage.getRemoveObjects().addAll(collection);
        vetoableSubject.notifyVetoObservers(vetoableSubject, updateMessage);
    }

    public static void fireCanRenameChild(VetoableSubject vetoableSubject, Object object) throws ChangeVetoException {
        UpdateMessage updateMessage = new UpdateMessage(CAN_RENAME_CHILD, null);
        updateMessage.getModifyObjects().add(object);
        vetoableSubject.notifyVetoObservers(vetoableSubject, updateMessage);
    }

    private static void notifyObserversOnEventThread(Subject subject, UpdateMessage updateMessage) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new 1(subject, updateMessage));
        } else {
            subject.notifyObservers(subject, updateMessage);
        }
    }

    private String debuggerString() {
        return _debugStrings[this._messageID];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UpdateMessage#");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append('{');
        if (this._messageID >= 0 && this._messageID < _debugStrings.length) {
            stringBuffer.append(_debugStrings[this._messageID]);
        } else {
            stringBuffer.append(this._messageID);
        }
        if (this._add != null) {
            stringBuffer.append(',');
            stringBuffer.append("added");
            stringBuffer.append(this._add);
        }
        if (this._remove != null) {
            stringBuffer.append(',');
            stringBuffer.append("removed");
            stringBuffer.append(this._remove);
        }
        if (this._modify != null) {
            stringBuffer.append(',');
            stringBuffer.append("modified");
            stringBuffer.append(this._modify);
        }
        if (this._hash != null) {
            stringBuffer.append(',');
            stringBuffer.append("properties");
            stringBuffer.append(this._hash);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Subject v$subject;
        private final /* synthetic */ UpdateMessage v$message;

        public void run() {
            this.v$subject.notifyObservers(this.v$subject, this.v$message);
        }

        public 1(Subject subject, UpdateMessage updateMessage) {
            this.v$message = updateMessage;
            this.v$subject = subject;
        }
    }
}

