/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.ListStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.util.Copyable;

class UserProperties
implements Copyable,
PropertyStorage {
    private final URL _sharedStorageURL;
    private HashStructure _hash;
    private URL _userStorageURL;

    UserProperties(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        this._sharedStorageURL = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws IOException {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            if (this._hash != null && this._hash.isDirty()) {
                ObjectStore objectStore = this.getIO();
                objectStore.save(this.getUserStorageURL(), (Object)this._hash);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashStructure getProperties() {
        UserProperties userProperties = this;
        synchronized (userProperties) {
            if (this._hash == null) {
                try {
                    URL uRL = this.getUserStorageURL();
                    if (URLFileSystem.exists(uRL)) {
                        ObjectStore objectStore = this.getIO();
                        HashStructure hashStructure = this._hash = (HashStructure)objectStore.load(uRL);
                        return hashStructure;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this._hash = HashStructure.newInstance();
            }
            HashStructure hashStructure = this._hash;
            return hashStructure;
        }
    }

    public Object copyTo(Object object) {
        UserProperties userProperties = object != null ? (UserProperties)object : new UserProperties(this._sharedStorageURL);
        this.copyToImpl(userProperties);
        return userProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void copyToImpl(UserProperties userProperties) {
        UserProperties userProperties2 = this;
        synchronized (userProperties2) {
            UserProperties userProperties3 = userProperties;
            synchronized (userProperties3) {
                if (this._hash != null) {
                    if (userProperties._hash != null) {
                        this._hash.copyTo(userProperties._hash);
                    } else {
                        userProperties._hash = this._hash.copyTo(null);
                    }
                } else {
                    userProperties._hash = null;
                }
                userProperties._userStorageURL = this._userStorageURL;
            }
        }
    }

    protected final ObjectStore getIO() {
        return new HashStructureIO(this.getNamespaceURI(), this.getRootQname());
    }

    protected String getNamespaceURI() {
        return "http://xmlns.oracle.com/ide/project";
    }

    protected String getRootQname() {
        return "jpr:project";
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((UserProperties)object);
    }

    protected final boolean equalsImpl(UserProperties userProperties) {
        return URLFileSystem.equals(this._sharedStorageURL, userProperties._sharedStorageURL) && URLFileSystem.equals(this._userStorageURL, userProperties._userStorageURL) && ModelUtil.areEqual((Object)this._hash, (Object)userProperties._hash);
    }

    private URL getUserStorageURL() throws IOException {
        if (this._userStorageURL == null) {
            this._userStorageURL = Index.getInstance().getUserStorageURL(this._sharedStorageURL);
        }
        return this._userStorageURL;
    }

    private static class Index {
        private static Index _instance;
        private final File _indexDir;
        private final File _indexFile;
        private final ListStructure _list;

        private Index() throws IOException {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            URL uRL = extensionRegistry.getSystemDirectory("oracle.ide");
            this._indexDir = new File(uRL.getPath(), "projects");
            this._indexDir.mkdirs();
            this._indexFile = new File(this._indexDir, "index.xml");
            ListStructure listStructure = null;
            if (this._indexFile.exists()) {
                ListStructureIO listStructureIO = new ListStructureIO(null, null);
                listStructure = (ListStructure)listStructureIO.load(URLFactory.newFileURL(this._indexFile));
            }
            if (listStructure == null) {
                listStructure = ListStructure.newInstance();
            }
            this._list = listStructure;
        }

        static synchronized Index getInstance() throws IOException {
            if (_instance == null) {
                _instance = new Index();
            }
            return _instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        URL getUserStorageURL(URL uRL) {
            ListStructure listStructure = this._list;
            synchronized (listStructure) {
                for (HashStructure hashStructure : this._list) {
                    URL uRL2 = hashStructure.getURL("shared");
                    if (!URLFileSystem.equals(uRL2, uRL)) continue;
                    String string = hashStructure.getString("user");
                    File file = new File(this._indexDir, string);
                    URL uRL3 = URLFactory.newFileURL(file);
                    return uRL3;
                }
                long l = System.currentTimeMillis();
                String string = URLFileSystem.getFileName(uRL);
                String string2 = string + l;
                File file = new File(this._indexDir, string2);
                URL uRL4 = URLFactory.newFileURL(file);
                HashStructure hashStructure = HashStructure.newInstance();
                hashStructure.putURL("shared", uRL);
                hashStructure.putString("user", string2);
                this._list.add((Object)hashStructure);
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                URL uRL5 = uRL4;
                return uRL5;
            }
        }

        private void save() throws IOException {
            ListStructureIO listStructureIO = new ListStructureIO(null, "index");
            URL uRL = URLFactory.newFileURL(this._indexFile);
            listStructureIO.save(uRL, this._list);
        }
    }
}

