/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class WorkingSets
extends HashStructureAdapter {
    public static final boolean ENABLED = Boolean.valueOf(System.getProperty("working.sets.enabled", "true"));
    public static final int ADD_TO_WORKING_SET_CMD_ID = Ide.findOrCreateCmdID("working-set-add-to-working-set");
    public static final String ADD_TO_WORKING_SET_MSG_KEY = "add-to-working-set";
    public static final String DEFAULT_WORKING_SET_LABEL = ModelArb.getString(56);
    public static final String ALL_FILES_WORKING_SET_LABEL = ModelArb.getString(57);
    public static final String DATA_KEY = "working-sets";
    private static final String CURRENT_WORKING_SET_NAME = ".current";
    private static ProjectChangeListener _listener;

    private WorkingSets(Project project) {
        super(project.getPropertiesForOverriding().getOrCreateHashStructure(DATA_KEY));
        project.applyBatchChanges(new 2());
    }

    public static WorkingSets getInstance(Project project) {
        return new WorkingSets(project);
    }

    public WorkingSet getWorkingSet(String string) {
        return WorkingSet.getInstance(this._hash, string);
    }

    public String getCurrentWorkingSetName() {
        return this._hash.getString(CURRENT_WORKING_SET_NAME);
    }

    public void setCurrentWorkingSetName(String string) {
        this._hash.putString(CURRENT_WORKING_SET_NAME, string, true);
    }

    public WorkingSet getCurrentWorkingSet() {
        String string = this.getCurrentWorkingSetName();
        if (string != null) {
            return this.getWorkingSet(string);
        }
        return null;
    }

    public List getWorkingSetNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._hash.keySet());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (this._hash.getObject(string) instanceof HashStructure) continue;
            iterator.remove();
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void deleteWorkingSet(String string) {
        if (!CURRENT_WORKING_SET_NAME.equals(string) && !ALL_FILES_WORKING_SET_LABEL.equals(string)) {
            this._hash.remove(string);
        }
    }

    static synchronized void init() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener(DATA_KEY, _listener);
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            WorkingSets.this.getWorkingSet(ALL_FILES_WORKING_SET_LABEL);
            if (!ALL_FILES_WORKING_SET_LABEL.equals(WorkingSets.this.getCurrentWorkingSetName()) && WorkingSets.this.getWorkingSetNames().size() == 1) {
                WorkingSets.this.getWorkingSet(DEFAULT_WORKING_SET_LABEL);
                WorkingSets.this.setCurrentWorkingSetName(DEFAULT_WORKING_SET_LABEL);
            }
        }
    }

    public static final class 1
    extends ProjectChangeListener {
        private final String _key;

        void $init$() {
            this._key = "last-working-set";
        }

        public void projectOpened(Project project) {
            if (!project.isDefaultProject()) {
                WorkingSets workingSets = WorkingSets.getInstance(project);
                WorkingSet workingSet = workingSets.getCurrentWorkingSet();
                String string = workingSets.getCurrentWorkingSetName();
                HashStructure hashStructure = HashStructure.newInstance();
                WorkingSet workingSet2 = new WorkingSet(hashStructure, string);
                workingSet.copyTo((Object)workingSet2);
                project.getTransientProperties().put("last-working-set", workingSet2);
            }
        }

        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            Project project = projectChangeEvent.getProject();
            if (!project.isDefaultProject()) {
                WorkingSets workingSets = WorkingSets.getInstance(project);
                WorkingSet workingSet = workingSets.getCurrentWorkingSet();
                Map map = project.getTransientProperties();
                WorkingSet workingSet2 = (WorkingSet)((Object)map.get("last-working-set"));
                if (ModelUtil.areDifferent((Object)((Object)workingSet2), (Object)((Object)workingSet))) {
                    map.put("last-working-set", workingSet);
                    UpdateMessage.fireStructureChanged(project);
                }
            }
        }

        public 1() {
            this.$init$();
        }
    }
}

