/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspaces;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.marshal.TransientMarker;

public final class Workspace
extends DataContainer {
    public static final String EXT = ".jws";
    static final String NAMESPACE_URI = "http://xmlns.oracle.com/ide/project";
    static final String ROOT_QNAME = "jws:workspace";
    private transient Project _activeProject;
    private transient URL _activeProjectURL;

    public Workspace() {
        this.getAttributes().set(ElementAttributes.BUILDABLE | ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.NAVIGABLE | ElementAttributes.CLOSEABLE | ElementAttributes.NON_HISTORIED);
    }

    public URL getActiveProjectURL() throws TransientMarker {
        return this._activeProjectURL;
    }

    public void setActiveProjectURL(URL uRL) {
        if (ModelUtil.areDifferent((Object)this._activeProjectURL, (Object)uRL)) {
            this._activeProjectURL = uRL;
            this._activeProject = (Project)NodeFactory.find(this._activeProjectURL);
        }
    }

    public Icon getIcon() {
        return ModelArb.getIcon(12);
    }

    public boolean canAdd(Element element) {
        return element instanceof Project;
    }

    public boolean remove(Element element, boolean bl) {
        boolean bl2 = super.remove(element, bl);
        if (bl2 && (element == this._activeProject || this.size() == 0)) {
            this._activeProject = null;
            this._activeProjectURL = null;
            this.markWorkspacesDirty();
        }
        return bl2;
    }

    protected ObjectStore newObjectStore() {
        return new HashStructureIO(NAMESPACE_URI, ROOT_QNAME);
    }

    protected Object getObjectStoreTarget() {
        return this._hash;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._activeProject = null;
        this.markWorkspacesDirty();
    }

    public Project currentActiveProject() {
        if (this._activeProject != null) {
            return this._activeProject;
        }
        if (this._activeProjectURL != null) {
            try {
                this._activeProject = (Project)NodeFactory.findOrCreate(this._activeProjectURL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._activeProject;
    }

    public void setActiveProject(Project project) {
        if (this._activeProject != project && this.size() > 0) {
            this._activeProject = project;
            if (this._activeProject != null) {
                if (ModelUtil.areDifferent((Object)this._activeProject.getURL(), (Object)this._activeProjectURL)) {
                    this._activeProjectURL = this._activeProject.getURL();
                }
            } else {
                this._activeProjectURL = null;
            }
            this.markWorkspacesDirty();
        }
    }

    private void markWorkspacesDirty() {
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            workspaces.markDirty(true);
        }
    }
}

