/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Version;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;

public class WorkspaceMigrator
extends HashStructureNodeMigrator {
    public static final String MIGRATOR_NAME = Workspace.class.getName();

    public List getPages(MigrationInfo[] migrationInfoArray, TraversableContext traversableContext) {
        List list = this.getChildrenPages(migrationInfoArray, traversableContext);
        list.addAll(super.getPages(migrationInfoArray, traversableContext));
        return list;
    }

    String getRootQname() {
        return "jws:workspace";
    }

    protected String getMsg(MigrationInfo[] migrationInfoArray) {
        String string = IdeArb.format(388, Version.NAME_SHORT, Version.VER);
        if (migrationInfoArray.length > 1) {
            return IdeArb.format(396, string);
        }
        URL uRL = migrationInfoArray[0].getNode().getURL();
        String string2 = URLFileSystem.getPlatformPathName(uRL);
        return IdeArb.format(394, string2, string);
    }

    protected String getTitle() {
        return IdeArb.getString(389);
    }

    protected String getSummaryMsg(MigrationInfo[] migrationInfoArray) {
        if (migrationInfoArray.length > 1) {
            return IdeArb.getString(397);
        }
        URL uRL = migrationInfoArray[0].getNode().getURL();
        String string = URLFileSystem.getPlatformPathName(uRL);
        return IdeArb.format(395, string);
    }

    private List getChildrenPages(MigrationInfo[] migrationInfoArray, TraversableContext traversableContext) {
        int n = 0;
        int n2 = migrationInfoArray.length;
        while (n < n2) {
            this.initContext(migrationInfoArray[n], traversableContext);
            ++n;
        }
        ArrayList arrayList = new ArrayList();
        Map map = this.getInfoToMigratorMap(traversableContext);
        for (NodeMigrator nodeMigrator : map.keySet()) {
            List list = (List)map.get(nodeMigrator);
            MigrationInfo[] migrationInfoArray2 = list.toArray(new MigrationInfo[list.size()]);
            arrayList.addAll(nodeMigrator.getPages(migrationInfoArray2, traversableContext));
        }
        return arrayList;
    }

    private void initContext(MigrationInfo migrationInfo, TraversableContext traversableContext) {
        Workspace workspace = (Workspace)migrationInfo.getNode();
        Iterator iterator = workspace.getChildren();
        Map map = this.getInfoToMigratorMap(traversableContext);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Node)) continue;
            Node node = (Node)e;
            if (URLFileSystem.exists(node.getURL())) {
                String string = NodeMigrator.getLookupKey(node);
                NodeMigrator nodeMigrator = NodeMigrator.getNodeMigrator(string);
                if (nodeMigrator == null) continue;
                MigrationInfo migrationInfo2 = nodeMigrator.getMigrationInfo(node);
                this.mapInfoToMigrator(nodeMigrator, migrationInfo2, map);
                continue;
            }
            workspace.remove(node);
        }
    }
}

