/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Folder;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.ObservableFolder;
import oracle.ide.model.Project;
import oracle.ide.model.SubDirtyable;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ModelUtil;

public class Workspaces
extends ObservableFolder
implements SubDirtyable {
    public static final String WORKSPACES = "Workspaces";
    private URL _workDirectory;
    private transient Workspace _activeWorkspace;
    private URL _activeWorkspaceURL;
    private SubDirtyable _subDirtyable;
    private Map _activeProjectMap;

    void $init$() {
        this._subDirtyable = new DefaultSubDirtyable();
    }

    public Workspaces() {
        this.$init$();
        this.getAttributes().clear();
        this.getAttributes().set(ElementAttributes.BUILDABLE);
    }

    public Workspaces(Workspaces workspaces) {
        this();
        if (workspaces != null) {
            workspaces.copyToImpl(this);
        }
    }

    public Object copyTo(Object object) {
        Workspaces workspaces = object != null ? (Workspaces)object : new Workspaces();
        this.copyToImpl(workspaces);
        return workspaces;
    }

    protected final void copyToImpl(Workspaces workspaces) {
        super.copyToImpl(workspaces);
        workspaces._workDirectory = this._workDirectory;
    }

    public URL getWorkDirectory() {
        return this._workDirectory;
    }

    public void setWorkDirectory(URL uRL) {
        if (!URLFileSystem.equals(this._workDirectory, uRL)) {
            this._workDirectory = uRL;
            this.markDirty(true);
        }
    }

    public URL getActiveWorkspaceURL() {
        return this._activeWorkspaceURL;
    }

    public void setActiveWorkspaceURL(URL uRL) {
        if (ModelUtil.areEqual((Object)this._activeWorkspaceURL, (Object)uRL)) {
            return;
        }
        this._activeWorkspaceURL = uRL;
        this._activeWorkspace = (Workspace)NodeFactory.find(this._activeWorkspaceURL);
        this.markDirty(true);
    }

    public String getShortLabel() {
        return ModelArb.getString(41);
    }

    public Icon getIcon() {
        return ModelArb.getIcon(13);
    }

    public boolean canAdd(Element element) {
        return element instanceof Workspace;
    }

    public boolean remove(Element element) {
        boolean bl = super.remove(element);
        if (bl && (element == this._activeWorkspace || this.size() == 0)) {
            this._activeWorkspaceURL = null;
            this._activeWorkspace = null;
        }
        return bl;
    }

    public void setListOfChildren(List list) {
        super.setListOfChildren(list);
        this.initActiveProjects();
    }

    public boolean isDirty() {
        return this._subDirtyable.isDirty();
    }

    public void markDirty(boolean bl) {
        this._subDirtyable.markDirty(bl);
    }

    public void setOwner(Dirtyable dirtyable) {
        this._subDirtyable.setOwner(dirtyable);
    }

    public Workspace currentActiveWorkspace() {
        if (this._activeWorkspace != null) {
            return this._activeWorkspace;
        }
        if (this._activeWorkspaceURL != null) {
            try {
                this._activeWorkspace = (Workspace)NodeFactory.findOrCreate(this._activeWorkspaceURL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this._activeWorkspace;
    }

    public void setActiveWorkspace(Workspace workspace) {
        if (this._activeWorkspace == workspace) {
            return;
        }
        if (this.size() == 0) {
            return;
        }
        this._activeWorkspace = workspace;
        if (this._activeWorkspace != null) {
            if (!ModelUtil.areEqual((Object)this._activeWorkspace.getURL(), (Object)this._activeWorkspaceURL)) {
                this._activeWorkspaceURL = this._activeWorkspace.getURL();
                this.markDirty(true);
            }
        } else if (this._activeWorkspaceURL != null) {
            this._activeWorkspaceURL = null;
            this.markDirty(true);
        }
    }

    public Map getActiveProjectMap() {
        HashMap<URL, URL> hashMap = new HashMap<URL, URL>();
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            Workspace workspace;
            URL uRL;
            Element element = (Element)iterator.next();
            if (!(element instanceof Workspace) || (uRL = (workspace = (Workspace)element).getActiveProjectURL()) == null) continue;
            hashMap.put(workspace.getURL(), uRL);
        }
        return hashMap;
    }

    public void setActiveProjectMap(Map map) {
        this._activeProjectMap = map;
        if (this._children.size() > 0) {
            this.initActiveProjects();
        }
    }

    public static final Folder findOwner(Element element, Context context) {
        Workspaces workspaces;
        if (context != null) {
            Folder folder;
            Project project = context.getProject();
            if (project != null && !(element instanceof Project) && (folder = project.findOwner(element)) != null) {
                return folder;
            }
            Workspace workspace = context.getWorkspace();
            if (workspace != null && !(element instanceof Workspace) && workspace.containsChild(element)) {
                return workspace;
            }
        }
        if ((workspaces = Ide.getWorkspaces()) != null && workspaces.containsChild(element)) {
            return workspaces;
        }
        return null;
    }

    private void initActiveProjects() {
        if (this._activeProjectMap == null) {
            return;
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            Workspace workspace;
            URL uRL;
            Element element = (Element)iterator.next();
            if (!(element instanceof Workspace) || (uRL = (URL)this._activeProjectMap.get((workspace = (Workspace)element).getURL())) == null) continue;
            workspace.setActiveProjectURL(uRL);
        }
        this._activeProjectMap = null;
    }
}

