/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.XMLDataNode;

public class XMLDataContainer
extends XMLDataNode
implements Folder {
    static final String ROOT_ELEMENT_NAME = "XMLDataContainer";

    public boolean mayHaveChildren() {
        return true;
    }

    public boolean canAdd(Element element) {
        if (element == null) {
            return false;
        }
        Folder folder = this.getDataFolder();
        if (folder == null) {
            return false;
        }
        return folder.canAdd(element);
    }

    public boolean add(Element element) {
        return this.add(element, false);
    }

    public boolean canRemove(Element element) {
        if (element == null) {
            return false;
        }
        Folder folder = this.getDataFolder();
        if (folder == null) {
            return false;
        }
        return folder.canRemove(element);
    }

    public boolean remove(Element element) {
        return this.remove(element, false);
    }

    public boolean containsChild(Element element) {
        Folder folder = this.getDataFolder();
        return folder.containsChild(element);
    }

    public int size() {
        Folder folder = this.getDataFolder();
        return folder.size();
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public boolean add(Element element, boolean bl) {
        Folder folder = this.getDataFolder();
        boolean bl2 = false;
        if (!folder.containsChild(element) && (bl2 = folder.add(element)) && bl) {
            UpdateMessage.fireChildAdded(this, element);
        }
        return bl2;
    }

    public boolean remove(Element element, boolean bl) {
        Folder folder = this.getDataFolder();
        boolean bl2 = false;
        if (!folder.containsChild(element)) {
            return false;
        }
        bl2 = folder.remove(element);
        if (bl2 && bl) {
            UpdateMessage.fireChildRemoved(this, element);
        }
        return bl2;
    }

    public void removeAll(boolean bl) {
        Folder folder = this.getDataFolder();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = folder.getChildren();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        folder.removeAll();
        if (bl && arrayList.size() > 0) {
            UpdateMessage.fireChildrenRemoved(this, arrayList);
        }
    }

    protected final Folder getDataFolder() throws IllegalStateException {
        try {
            this.open();
            XMLDataNode.DataCastPacket dataCastPacket = this.getDataCastPacketDirectly();
            if (dataCastPacket == null || dataCastPacket.folder == null) {
                throw new IllegalStateException();
            }
            Folder folder = dataCastPacket.folder;
            return folder;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Folder folder = null;
            return folder;
        }
    }
}

