/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.ApplyNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.Traversable;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.Namespace;
import oracle.javatools.data.ListStructure;

public abstract class ProjectContentNavigable
extends Navigable {
    private static String _defaultContentSetKey;
    private transient Navigable _navigable;
    public static final String PROPERTIES_NODE_LABEL;

    static {
        PROPERTIES_NODE_LABEL = PanelsArb.getString(51);
    }

    public ProjectContentNavigable() {
        super(PROPERTIES_NODE_LABEL);
        this.setChildComparator(ContentLevel.getContentSetDisplayableComparator());
    }

    public static void setDefaultContentSet(String string) {
        if (_defaultContentSetKey != null) {
            System.err.println("*** Warning: Replacing previously registered default content set '" + _defaultContentSetKey + "' with '" + string + "'.");
        }
        _defaultContentSetKey = string;
    }

    protected abstract Navigable getGenericNavigable(String var1, String var2);

    public Traversable newTraversable(ApplyNotifier applyNotifier) {
        return this.getNavigableImpl().newTraversable(applyNotifier);
    }

    public Class getTraversableClass() {
        return this.getNavigableImpl().getTraversableClass();
    }

    public boolean isUsingTraversableDefaultConstructor() {
        return this.getNavigableImpl().isUsingTraversableDefaultConstructor();
    }

    protected boolean mayHaveChildren(NavigableContext navigableContext) {
        Namespace namespace = navigableContext.getScope();
        Project project = (Project)namespace.find("Project");
        if (project != null) {
            boolean bl = ProjectSettingsTraversablePanel.isDefaultProject(namespace);
            if (bl) {
                ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
                if (contentSetProviderArray.length > 1) {
                    return true;
                }
                if (contentSetProviderArray.length == 1) {
                    if (_defaultContentSetKey != null) {
                        return _defaultContentSetKey.equals(contentSetProviderArray[0].getKey()) ^ true;
                    }
                    return true;
                }
                return false;
            }
            ListStructure listStructure = ProjectContent.getInstance(project).getContentSetList();
            for (Object e : listStructure) {
                String string;
                if (e == null || (string = e.toString()).equals(_defaultContentSetKey)) continue;
                return true;
            }
        }
        return false;
    }

    protected void appendChildNavigables(DefaultMutableTreeNode defaultMutableTreeNode, NavigableContext navigableContext) {
        Navigable[] navigableArray;
        ArrayList<Navigable> arrayList = new ArrayList<Navigable>();
        Namespace namespace = navigableContext.getScope();
        Project project = (Project)namespace.find("Project");
        boolean bl = ProjectSettingsTraversablePanel.isDefaultProject(namespace);
        if (project != null) {
            Iterator iterator;
            ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
            int n = contentSetProviderArray.length;
            if (bl) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n2 = 0;
                while (n2 < n) {
                    ContentSetProvider contentSetProvider = contentSetProviderArray[n2];
                    String string = contentSetProvider.getKey();
                    if (string != null) {
                        arrayList2.add(string);
                    }
                    ++n2;
                }
                iterator = arrayList2.iterator();
            } else {
                iterator = ProjectContent.getInstance(project).getContentSetList().iterator();
            }
            block1: while (iterator.hasNext()) {
                String string;
                Object e = iterator.next();
                if (e == null || (string = e.toString()).equals(_defaultContentSetKey)) continue;
                int n3 = 0;
                while (n3 < n) {
                    ContentSetProvider contentSetProvider = contentSetProviderArray[n3];
                    if (string.equals(contentSetProvider.getKey())) {
                        Navigable navigable = contentSetProvider.getNavigable();
                        if (navigable == null) continue block1;
                        arrayList.add(navigable);
                        continue block1;
                    }
                    ++n3;
                }
                int n4 = string.lastIndexOf(47);
                int n5 = n4 + 1;
                String string2 = n5 < string.length() ? string.substring(n5) : string.substring(0, n4);
                String string3 = "<" + string2 + ">";
                Navigable navigable = this.getGenericNavigable(string3, string);
                if (navigable == null) continue;
                arrayList.add(navigable);
            }
        }
        if (!bl && (navigableArray = this.getChildNavigables()) != null) {
            arrayList.addAll(Arrays.asList(navigableArray));
        }
        Navigable[] navigableArray2 = arrayList.toArray(new Navigable[arrayList.size()]);
        this.appendChildNodes(defaultMutableTreeNode, navigableArray2, navigableContext);
    }

    private static Navigable emptyPanel() {
        return new Navigable(PROPERTIES_NODE_LABEL, DefaultTraversablePanel.class);
    }

    private Navigable getNavigableImpl() {
        if (this._navigable == null) {
            if (_defaultContentSetKey == null) {
                this._navigable = ProjectContentNavigable.emptyPanel();
            } else {
                ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
                int n = contentSetProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentSetProvider contentSetProvider = contentSetProviderArray[n2];
                    if (_defaultContentSetKey.equals(contentSetProvider.getKey())) {
                        this._navigable = contentSetProvider.getNavigable();
                        if (this._navigable != null) break;
                        this._navigable = ProjectContentNavigable.emptyPanel();
                        break;
                    }
                    ++n2;
                }
            }
        }
        return this._navigable;
    }
}

