/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectContentNavigable;
import oracle.ide.model.panels.ProjectPropertiesMDDPanel;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.resource.ProjectPropertiesArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.StructureChangeListener;

public final class ProjectPropertiesDialog {
    private static final ArrayList _rootNavigables = new ArrayList();
    private static String[] _oldPath = null;

    private ProjectPropertiesDialog() {
    }

    public static void addPanel(Navigable navigable) {
        if (navigable != null && !_rootNavigables.contains(navigable)) {
            _rootNavigables.add(navigable);
        }
    }

    public static void removePanel(Navigable navigable) {
        _rootNavigables.remove(navigable);
    }

    public static void showDialog(Project project) {
        ProjectPropertiesDialog.showDialog((Frame)((Object)Ide.getMainWindow()), project);
    }

    public static void showDialog(Frame frame, Project project) {
        ProjectPropertiesDialog.showDialog(frame, project, false, ProjectPropertiesArb.format(5, project.getLongLabel()), null);
    }

    public static void showDialog(Frame frame, Project project, String[] stringArray) {
        ProjectPropertiesDialog.showDialog(frame, project, false, ProjectPropertiesArb.format(5, project.getLongLabel()), stringArray);
    }

    private static void showDialog(Frame frame, Project project, boolean bl, String string, String[] stringArray) {
        MDDPanel mDDPanel;
        if (project == null || project.getUserPropertiesOnly() == null) {
            return;
        }
        frame.setCursor(Cursor.getPredefinedCursor(3));
        Project project2 = (Project)project.copyTo(null);
        ChangeBuffer changeBuffer = new ChangeBuffer();
        project2.getSharedPropertiesOnly().addStructureChangeListener((StructureChangeListener)changeBuffer);
        ChangeBuffer changeBuffer2 = new ChangeBuffer();
        project2.getUserPropertiesOnly().addStructureChangeListener((StructureChangeListener)changeBuffer2);
        boolean bl2 = project.isDefaultProject();
        Namespace namespace = new Namespace();
        namespace.put("Project", (Object)project2);
        namespace.put("IsDefaultProject", (Object)bl2);
        namespace.put("PropertyData", (Object)project2.getSharedPropertiesOnly());
        namespace.put("IsUserPropertyData", (Object)Boolean.FALSE);
        namespace.put("ChainedPropertyData", (Object)project2.getProperties());
        namespace.put("UserOnlyPropertyData", (Object)project2.getUserPropertiesOnly());
        if (bl2) {
            mDDPanel = new MDDPanel(ProjectPropertiesDialog.getRootNavigables(), bl);
            mDDPanel.setChildComparator(new Navigable.NavigableComparator(ProjectContentNavigable.PROPERTIES_NODE_LABEL));
        } else {
            Namespace namespace2 = new Namespace();
            namespace2.put("Project", (Object)project2);
            namespace2.put("IsDefaultProject", (Object)bl2);
            namespace2.put("PropertyData", (Object)project2.getPropertiesForOverriding());
            namespace2.put("IsUserPropertyData", (Object)Boolean.TRUE);
            mDDPanel = new ProjectPropertiesMDDPanel(ProjectPropertiesDialog.getRootNavigables(), bl, namespace2);
            mDDPanel.setChildComparator(new Navigable.NavigableComparator(ProjectContentNavigable.PROPERTIES_NODE_LABEL));
        }
        mDDPanel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
        mDDPanel.setTitleDepth(2);
        if (bl2) {
            string = ProjectPropertiesArb.getString(6);
        }
        TDialogLauncher tDialogLauncher = new TDialogLauncher(frame, string, mDDPanel, namespace, new SizeKeeperCallback("project.settings"));
        if (stringArray != null) {
            mDDPanel.setTree1SelectionPath(stringArray);
        } else if (_oldPath != null) {
            mDDPanel.setTree1SelectionPath(_oldPath);
        }
        frame.setCursor(Cursor.getDefaultCursor());
        boolean bl3 = tDialogLauncher.showDialog();
        project2.getSharedPropertiesOnly().removeStructureChangeListener((StructureChangeListener)changeBuffer);
        project2.getUserPropertiesOnly().removeStructureChangeListener((StructureChangeListener)changeBuffer2);
        tDialogLauncher.dispose();
        _oldPath = mDDPanel.getTree1SelectionPath();
        if (bl3 && ModelUtil.areDifferent((Object)project, (Object)project2)) {
            project.applyBatchChanges(new 1(project, changeBuffer, changeBuffer2));
            try {
                project.saveUserProperties();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bl2) {
                try {
                    project.save();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        try {
            project2.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Navigable[] getRootNavigables() {
        Navigable[] navigableArray = _rootNavigables.toArray(new Navigable[0]);
        return navigableArray;
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ ChangeBuffer v$projectChangeBuffer;
        private final /* synthetic */ ChangeBuffer v$userChangeBuffer;

        public void run() {
            this.v$project.getSharedPropertiesOnly().applyChanges(this.v$projectChangeBuffer.getChanges());
            this.v$project.getUserPropertiesOnly().applyChanges(this.v$userChangeBuffer.getChanges());
        }

        public 1(Project project, ChangeBuffer changeBuffer, ChangeBuffer changeBuffer2) {
            this.v$userChangeBuffer = changeBuffer2;
            this.v$projectChangeBuffer = changeBuffer;
            this.v$project = project;
        }
    }
}

