/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.panels;

import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public abstract class ProjectSettingsTraversablePanel
extends DefaultTraversablePanel {
    private int propertiesAreOverridden;
    private static final int OVERRIDDEN = 1;
    private static final int NOT_OVERRIDDEN = 0;
    public static final String DEFAULT_PROJECT_KEY = "IsDefaultProject";
    public static final String EDITING_CUSTOM_PROPERTIES_KEY = "IsUserPropertyData";
    public static final String PROPERTY_DATA_KEY = "PropertyData";
    public static final String CHAINED_PROPERTY_DATA_KEY = "ChainedPropertyData";
    public static final String USER_ONLY_PROPERTY_DATA_KEY = "UserOnlyPropertyData";

    void $init$() {
        this.propertiesAreOverridden = -1;
    }

    public final void onEntry(TraversableContext traversableContext) {
        if (traversableContext.contains(EDITING_CUSTOM_PROPERTIES_KEY) && Boolean.FALSE.equals(traversableContext.get(EDITING_CUSTOM_PROPERTIES_KEY))) {
            String[] stringArray = this.getPropertyKeys();
            if (this.propertiesAreOverridden < 0) {
                HashStructure hashStructure = (HashStructure)traversableContext.find(CHAINED_PROPERTY_DATA_KEY);
                HashStructure hashStructure2 = this.getPanelProperties(hashStructure);
                this.propertiesAreOverridden = hashStructure2.isAnyValueOverridden(stringArray) ? 1 : 0;
            }
        }
        this.onProjectPanelEntry(traversableContext);
    }

    public abstract void onProjectPanelEntry(TraversableContext var1);

    public abstract String getDataKey();

    public abstract String[] getPropertyKeys();

    protected static Project getProject(Namespace namespace) {
        return (Project)namespace.find("Project");
    }

    protected static PropertyStorage getPropertyData(Namespace namespace) {
        HashStructure hashStructure = (HashStructure)namespace.find(PROPERTY_DATA_KEY);
        return new PropertyData(hashStructure);
    }

    public boolean isUserOnly() {
        return false;
    }

    public static final boolean isDefaultProject(Namespace namespace) {
        return Boolean.TRUE.equals(namespace.find(DEFAULT_PROJECT_KEY));
    }

    public static final boolean editingUserProperties(Namespace namespace) {
        return Boolean.TRUE.equals(namespace.find(EDITING_CUSTOM_PROPERTIES_KEY));
    }

    public final void activateProperties(TraversableContext traversableContext, boolean bl) {
        HashStructure hashStructure = (HashStructure)traversableContext.get(USER_ONLY_PROPERTY_DATA_KEY);
        HashStructure hashStructure2 = this.getPanelProperties(hashStructure);
        String[] stringArray = this.getPropertyKeys();
        if (bl) {
            hashStructure2.recoverValues(stringArray);
        } else {
            hashStructure2.hideValues(stringArray);
        }
    }

    public boolean arePropertiesOverridden() {
        return 1 == this.propertiesAreOverridden;
    }

    private HashStructure getPanelProperties(HashStructure hashStructure) {
        String string = this.getDataKey();
        if (string != null) {
            return hashStructure.getOrCreateHashStructure(string);
        }
        return hashStructure;
    }

    public ProjectSettingsTraversablePanel() {
        this.$init$();
    }

    private static class PropertyData
    implements PropertyStorage {
        private HashStructure propertyData;

        public PropertyData(HashStructure hashStructure) {
            if (hashStructure == null) {
                throw new IllegalArgumentException("The HashStructure cannot be null.");
            }
            this.propertyData = hashStructure;
        }

        public HashStructure getProperties() {
            return this.propertyData;
        }
    }
}

