/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.natives;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFileSystem;

public class DirectoryWatcher {
    private URL _rootURL;
    private boolean _recursive;
    private DirectoryListener _listener;
    private boolean _active;
    private static final boolean DEBUG_VERBOSE = false;
    static Object WATCH_LOCK = new int[0];
    private static List _watchEntryList = new ArrayList();
    private static boolean _watchThreadStarted = false;

    public static DirectoryWatcher createDirectoryWatcher(URL uRL, DirectoryListener directoryListener) {
        return DirectoryWatcher.createDirectoryWatcherImpl(uRL, true, directoryListener);
    }

    public static void destroyDirectoryWatcher(DirectoryWatcher directoryWatcher) {
        DirectoryWatcher.destroyDirectoryWatcherImpl(directoryWatcher);
    }

    private DirectoryWatcher(URL uRL, boolean bl, DirectoryListener directoryListener) {
        this._rootURL = uRL;
        this._recursive = bl;
        this._listener = directoryListener;
        this._active = true;
    }

    public URL getRootURL() {
        return this._rootURL;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        String string = URLFileSystem.getPlatformPathName(this.getRootURL());
        return "DW: " + string + " recurse(" + this._recursive + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryWatcher createDirectoryWatcherImpl(URL uRL, boolean bl, DirectoryListener directoryListener) {
        if (!NativeHandler.isLoaded()) {
            return null;
        }
        if (uRL == null) {
            return null;
        }
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        DirectoryWatcher.startWatchThread();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry watchEntry = DirectoryWatcher.findWatchEntry(uRL, bl);
            if (watchEntry == null) {
                String string = URLFileSystem.getPlatformPathName(uRL);
                int n = NativeHandler.startDirectoryWatch(string, bl);
                if (n == -1) {
                    DirectoryWatcher directoryWatcher = null;
                    return directoryWatcher;
                }
                watchEntry = new WatchEntry(new ArrayList(), uRL, n, bl, null);
                _watchEntryList.add(watchEntry);
            }
            DirectoryWatcher directoryWatcher = new DirectoryWatcher(uRL, bl, directoryListener);
            WatchEntry.ra$watchers(watchEntry).add(directoryWatcher);
            DirectoryWatcher directoryWatcher2 = directoryWatcher;
            return directoryWatcher2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyDirectoryWatcherImpl(DirectoryWatcher directoryWatcher) {
        Object object = WATCH_LOCK;
        synchronized (object) {
            directoryWatcher._active = false;
            WatchEntry watchEntry = DirectoryWatcher.findWatchEntry(directoryWatcher._rootURL, directoryWatcher._recursive);
            if (watchEntry != null) {
                WatchEntry.ra$watchers(watchEntry).remove(directoryWatcher);
                if (WatchEntry.ra$watchers(watchEntry).size() == 0) {
                    _watchEntryList.remove(watchEntry);
                    String string = URLFileSystem.getPlatformPathName(WatchEntry.ra$rootURL(watchEntry));
                    NativeHandler.stopDirectoryWatch(string, WatchEntry.ra$cookie(watchEntry));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startWatchThread() {
        if (!_watchThreadStarted) {
            Object object = WATCH_LOCK;
            synchronized (object) {
                if (!_watchThreadStarted) {
                    NativeHandler.startWatcherThread(new WatchEventRedirector(null));
                    _watchThreadStarted = true;
                }
            }
        }
    }

    private static WatchEntry findWatchEntry(int n) {
        int n2 = _watchEntryList.size();
        int n3 = 0;
        while (n3 < n2) {
            WatchEntry watchEntry = (WatchEntry)_watchEntryList.get(n3);
            if (watchEntry != null && WatchEntry.ra$cookie(watchEntry) == n) {
                return watchEntry;
            }
            ++n3;
        }
        return null;
    }

    private static WatchEntry findWatchEntry(URL uRL, boolean bl) {
        int n = _watchEntryList.size();
        int n2 = 0;
        while (n2 < n) {
            WatchEntry watchEntry = (WatchEntry)_watchEntryList.get(n2);
            if (watchEntry != null && WatchEntry.ra$recursive(watchEntry) == bl && WatchEntry.ra$rootURL(watchEntry).equals(uRL)) {
                return watchEntry;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireWatchEvent(int n, int n2, String string) {
        ArrayList<DirectoryListener> arrayList = new ArrayList<DirectoryListener>();
        ArrayList<DirectoryEvent> arrayList2 = new ArrayList<DirectoryEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry watchEntry = DirectoryWatcher.findWatchEntry(n);
            if (watchEntry == null) {
                return;
            }
            if (WatchEntry.ra$oldFilenameForRename(watchEntry) == null || n2 != 5) {
                // empty if block
            }
            int n3 = -1;
            String string2 = null;
            switch (n2) {
                case 1: {
                    n3 = 1;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    n3 = 3;
                    break;
                }
                case 4: {
                    WatchEntry.wa$oldFilenameForRename(watchEntry, string);
                    return;
                }
                case 5: {
                    n3 = 4;
                    string2 = WatchEntry.ra$oldFilenameForRename(watchEntry);
                    WatchEntry.wa$oldFilenameForRename(watchEntry, null);
                    if (string2 != null) break;
                    return;
                }
            }
            if (n3 == -1) {
                return;
            }
            int n4 = WatchEntry.ra$watchers(watchEntry).size();
            int n5 = 0;
            while (n5 < n4) {
                DirectoryWatcher directoryWatcher;
                DirectoryWatcher directoryWatcher2 = directoryWatcher = (DirectoryWatcher)WatchEntry.ra$watchers(watchEntry).get(n5);
                directoryWatcher2.getClass();
                DirectoryEvent directoryEvent = directoryWatcher2.new DirectoryEvent(n3, string, null);
                DirectoryEvent.mav$setOldFileName(directoryEvent, string2);
                DirectoryListener directoryListener = directoryWatcher._listener;
                arrayList2.add(directoryEvent);
                arrayList.add(directoryListener);
                ++n5;
            }
        }
        int n6 = arrayList.size();
        int n7 = 0;
        while (n7 < n6) {
            DirectoryListener directoryListener = (DirectoryListener)arrayList.get(n7);
            DirectoryEvent directoryEvent = (DirectoryEvent)arrayList2.get(n7);
            if (directoryListener != null && directoryEvent != null) {
                try {
                    directoryListener.directoryUpdate(directoryEvent);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            ++n7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireCancelledEvent(int n) {
        ArrayList<DirectoryListener> arrayList = new ArrayList<DirectoryListener>();
        ArrayList<DirectoryEvent> arrayList2 = new ArrayList<DirectoryEvent>();
        Object object = WATCH_LOCK;
        synchronized (object) {
            WatchEntry watchEntry = DirectoryWatcher.findWatchEntry(n);
            if (watchEntry == null) {
                return;
            }
            int n2 = WatchEntry.ra$watchers(watchEntry).size();
            int n3 = 0;
            while (n3 < n2) {
                DirectoryWatcher directoryWatcher = (DirectoryWatcher)WatchEntry.ra$watchers(watchEntry).get(n3);
                directoryWatcher._active = false;
                DirectoryWatcher directoryWatcher2 = directoryWatcher;
                directoryWatcher2.getClass();
                DirectoryEvent directoryEvent = directoryWatcher2.new DirectoryEvent(15, null);
                DirectoryListener directoryListener = directoryWatcher._listener;
                arrayList2.add(directoryEvent);
                arrayList.add(directoryListener);
                ++n3;
            }
            _watchEntryList.remove(watchEntry);
        }
        int n4 = arrayList.size();
        int n5 = 0;
        while (n5 < n4) {
            DirectoryListener directoryListener = (DirectoryListener)arrayList.get(n5);
            DirectoryEvent directoryEvent = (DirectoryEvent)arrayList2.get(n5);
            if (directoryListener != null && directoryEvent != null) {
                try {
                    directoryListener.watchCancelled(directoryEvent);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            ++n5;
        }
    }

    static void maS$fireCancelledEvent(int n) {
        DirectoryWatcher.fireCancelledEvent(n);
    }

    static void maS$fireWatchEvent(int n, int n2, String string) {
        DirectoryWatcher.fireWatchEvent(n, n2, string);
    }

    public class DirectoryEvent {
        public static final int FILE_ADDED = 1;
        public static final int FILE_REMOVED = 2;
        public static final int FILE_MODIFIED = 3;
        public static final int FILE_RENAMED = 4;
        public static final int WATCH_CANCELLED = 15;
        private String _filename;
        private int _type;
        private String _oldname;

        private DirectoryEvent(int n) {
            this._filename = null;
            this._oldname = null;
            this._type = n;
        }

        private DirectoryEvent(int n, String string) {
            this._filename = string;
            this._oldname = null;
            this._type = n;
        }

        private void setOldFileName(String string) {
            this._oldname = string;
        }

        public int getEventType() {
            return this._type;
        }

        public String getFileName() {
            return this._filename;
        }

        public String getOldFileName() {
            return this._oldname;
        }

        public DirectoryWatcher getDirectoryWatcher() {
            return DirectoryWatcher.this;
        }

        public URL getRootURL() {
            return this.getDirectoryWatcher().getRootURL();
        }

        DirectoryEvent(int n, 1 var3_3) {
            this(n);
        }

        DirectoryEvent(int n, String string, 1 var4_4) {
            this(n, string);
        }

        static void mav$setOldFileName(DirectoryEvent directoryEvent, String string) {
            directoryEvent.setOldFileName(string);
        }

        public final class 1 {
        }
    }

    public static interface DirectoryListener {
        public void directoryUpdate(DirectoryEvent var1);

        public void watchCancelled(DirectoryEvent var1);
    }

    private static class WatchEventRedirector
    implements NativeHandler.WatchListener {
        public void notifyWatchEvent(int n, int n2, String string) {
            DirectoryWatcher.maS$fireWatchEvent(n, n2, string);
        }

        public void notifyWatchEnded(int n) {
            DirectoryWatcher.maS$fireCancelledEvent(n);
        }

        private WatchEventRedirector() {
        }

        WatchEventRedirector(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class WatchEntry {
        private List watchers;
        private URL rootURL;
        private int cookie;
        private boolean recursive;
        private String oldFilenameForRename;

        private WatchEntry(List list, URL uRL, int n, boolean bl) {
            this.$init$();
            this.watchers = list;
            this.rootURL = uRL;
            this.cookie = n;
            this.recursive = bl;
        }

        void $init$() {
            this.oldFilenameForRename = null;
        }

        static List ra$watchers(WatchEntry watchEntry) {
            return watchEntry.watchers;
        }

        static String ra$oldFilenameForRename(WatchEntry watchEntry) {
            return watchEntry.oldFilenameForRename;
        }

        static void wa$oldFilenameForRename(WatchEntry watchEntry, String string) {
            watchEntry.oldFilenameForRename = string;
        }

        static boolean ra$recursive(WatchEntry watchEntry) {
            return watchEntry.recursive;
        }

        static URL ra$rootURL(WatchEntry watchEntry) {
            return watchEntry.rootURL;
        }

        static int ra$cookie(WatchEntry watchEntry) {
            return watchEntry.cookie;
        }

        WatchEntry(List list, URL uRL, int n, boolean bl, 1 var5_5) {
            this(list, uRL, n, bl);
        }

        public final class 1 {
        }
    }
}

